/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerHelper;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class UniversalConnectionPoolMBeanBase
implements UniversalConnectionPoolMBean {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniversalConnectionPoolMBeanBase.class.getCanonicalName());
    protected UniversalConnectionPool m_connectionPool = null;

    public UniversalConnectionPoolMBeanBase(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        if (null == connectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        this.m_connectionPool = connectionPool;
    }

    public void refresh() throws UniversalConnectionPoolException {
        logger.finest("entering");
        this.m_connectionPool.refresh();
    }

    public void recycle() throws UniversalConnectionPoolException {
        logger.finest("entering");
        this.m_connectionPool.recycle();
    }

    public void purge() throws UniversalConnectionPoolException {
        logger.finest("entering");
        this.m_connectionPool.purge();
    }

    public void start() throws UniversalConnectionPoolException {
        logger.finest("entering");
        this.m_connectionPool.start();
    }

    public void stop() throws UniversalConnectionPoolException {
        logger.finest("entering");
        this.m_connectionPool.stop();
    }

    public String getName() {
        return this.m_connectionPool.getName();
    }

    public void setName(String name) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "name: {0}", name);
        try {
            UniversalConnectionPoolManagerHelper umh = new UniversalConnectionPoolManagerHelper(this.m_connectionPool);
            umh.setManagerPoolID(name);
        }
        catch (UniversalConnectionPoolException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(379);
        }
        this.m_connectionPool.setName(name);
    }

    public int getInitialPoolSize() {
        return this.m_connectionPool.getInitialPoolSize();
    }

    public void setInitialPoolSize(int initialPoolSize) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "initialPoolSize: {0}", initialPoolSize);
        this.m_connectionPool.setInitialPoolSize(initialPoolSize);
    }

    public int getMinPoolSize() {
        return this.m_connectionPool.getMinPoolSize();
    }

    public void setMinPoolSize(int minPoolSize) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "minPoolSize: {0}", minPoolSize);
        this.m_connectionPool.setMinPoolSize(minPoolSize);
    }

    public int getMaxPoolSize() {
        return this.m_connectionPool.getMaxPoolSize();
    }

    public void setMaxPoolSize(int maxPoolSize) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "maxPoolSize: {0}", maxPoolSize);
        this.m_connectionPool.setMaxPoolSize(maxPoolSize);
    }

    public int getInactiveConnectionTimeout() {
        return this.m_connectionPool.getInactiveConnectionTimeout();
    }

    public void setInactiveConnectionTimeout(int inactiveConnectionTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "inactivityTimeout: {0}", inactiveConnectionTimeout);
        this.m_connectionPool.setInactiveConnectionTimeout(inactiveConnectionTimeout);
    }

    public int getAbandonedConnectionTimeout() {
        return this.m_connectionPool.getAbandonedConnectionTimeout();
    }

    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "abandonedConnectionTimeout: {0}", abandonedConnectionTimeout);
        this.m_connectionPool.setAbandonedConnectionTimeout(abandonedConnectionTimeout);
    }

    public int getConnectionWaitTimeout() {
        return this.m_connectionPool.getConnectionWaitTimeout();
    }

    public void setConnectionWaitTimeout(int connectionWaitTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "connectionWaitTimeout: {0}", connectionWaitTimeout);
        this.m_connectionPool.setConnectionWaitTimeout(connectionWaitTimeout);
    }

    public int getTimeToLiveConnectionTimeout() {
        return this.m_connectionPool.getTimeToLiveConnectionTimeout();
    }

    public void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "timeToLiveConnectionTimeout: {0}", timeToLiveConnectionTimeout);
        this.m_connectionPool.setTimeToLiveConnectionTimeout(timeToLiveConnectionTimeout);
    }

    public int getTimeoutCheckInterval() {
        return this.m_connectionPool.getTimeoutCheckInterval();
    }

    public void setTimeoutCheckInterval(int timeoutCheckInterval) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "timeoutCheckInterval: {0}", timeoutCheckInterval);
        this.m_connectionPool.setTimeoutCheckInterval(timeoutCheckInterval);
    }

    public boolean getValidateConnectionOnBorrow() {
        return this.m_connectionPool.getValidateConnectionOnBorrow();
    }

    public void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) {
        logger.log(Level.FINEST, "validateConnectionOnBorrow: {0}", validateConnectionOnBorrow);
        this.m_connectionPool.setValidateConnectionOnBorrow(validateConnectionOnBorrow);
    }

    public int getConnectionHarvestTriggerCount() {
        return this.m_connectionPool.getConnectionHarvestTriggerCount();
    }

    public void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "connectionHarvestTriggerCount: {0}", connectionHarvestTriggerCount);
        this.m_connectionPool.setConnectionHarvestTriggerCount(connectionHarvestTriggerCount);
    }

    public int getConnectionHarvestMaxCount() {
        return this.m_connectionPool.getConnectionHarvestMaxCount();
    }

    public void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "connectionHarvestMaxCount: {0}", connectionHarvestMaxCount);
        this.m_connectionPool.setConnectionHarvestMaxCount(connectionHarvestMaxCount);
    }

    public long getMaxConnectionReuseTime() {
        return this.m_connectionPool.getMaxConnectionReuseTime();
    }

    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "maxConnectionReuseTime: {0}", maxConnectionReuseTime);
        this.m_connectionPool.setMaxConnectionReuseTime(maxConnectionReuseTime);
    }

    public int getMaxConnectionReuseCount() {
        return this.m_connectionPool.getMaxConnectionReuseCount();
    }

    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "maxConnectionReuseCount: {0}", maxConnectionReuseCount);
        this.m_connectionPool.setMaxConnectionReuseCount(maxConnectionReuseCount);
    }

    public int getAvailableConnectionsCount() {
        return this.m_connectionPool.getAvailableConnectionsCount();
    }

    public int getBorrowedConnectionsCount() {
        return this.m_connectionPool.getBorrowedConnectionsCount();
    }

    public UniversalConnectionPoolStatistics getStatistics() {
        return this.m_connectionPool.getStatistics();
    }

    public UniversalConnectionPoolLifeCycleState getLifeCycleState() {
        return this.m_connectionPool.getLifeCycleState();
    }

    public ModelMBeanInfo getMBeanInfo(ObjectName mbeanObjName, String mbeanDisplayName) throws UniversalConnectionPoolException {
        logger.finest("constructing MBeanInfo");
        if (mbeanObjName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(381);
        }
        if (mbeanDisplayName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(382);
        }
        ModelMBeanInfoSupport modelMBeanInfo = null;
        try {
            String descriptorType = "mbean";
            String mbeanName = "oracle.ucp.admin.UniversalConnectionPoolMBean";
            String mbeanDescription = "UniversalConnectionPoolMBean Object";
            DescriptorSupport modelMBeanDescriptor = new DescriptorSupport("name=" + mbeanObjName, "descriptorType=" + descriptorType, "displayName=" + mbeanDisplayName);
            modelMBeanInfo = new ModelMBeanInfoSupport(mbeanName, mbeanDescription, this.getUCPMBeanAttributes(), UniversalConnectionPoolMBeanBase.getConstructorsInfo(), this.getUCPMBeanOperations(), UniversalConnectionPoolMBeanBase.getNotificationsInfo());
            modelMBeanInfo.setMBeanDescriptor(modelMBeanDescriptor);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(374, e);
        }
        catch (MBeanException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(373, e);
        }
        return modelMBeanInfo;
    }

    private static ModelMBeanConstructorInfo[] getConstructorsInfo() throws UniversalConnectionPoolException {
        ModelMBeanConstructorInfo[] constInfo = new ModelMBeanConstructorInfo[]{};
        return constInfo;
    }

    public ModelMBeanAttributeInfo[] getUCPMBeanAttributes() throws UniversalConnectionPoolException {
        ModelMBeanAttributeInfo[] ucpMBeanAttributeInfo = new ModelMBeanAttributeInfo[16];
        logger.finest("constructing AttributesInfo");
        try {
            DescriptorSupport poolNameAttribute = new DescriptorSupport();
            poolNameAttribute.setField("name", "poolName");
            poolNameAttribute.setField("descriptorType", "attribute");
            poolNameAttribute.setField("displayName", UCPErrorHandler.findMessage("PoolNameAttrDisplayName"));
            poolNameAttribute.setField("getMethod", "getName");
            poolNameAttribute.setField("setMethod", "setName");
            ucpMBeanAttributeInfo[0] = new ModelMBeanAttributeInfo("poolName", "java.lang.String", UCPErrorHandler.findMessage("PoolNameAttrDescription"), true, true, false, poolNameAttribute);
            DescriptorSupport initialPoolSizeAttribute = new DescriptorSupport();
            initialPoolSizeAttribute.setField("name", "initialPoolSize");
            initialPoolSizeAttribute.setField("descriptorType", "attribute");
            initialPoolSizeAttribute.setField("displayName", UCPErrorHandler.findMessage("InitialPoolSizeAttrDisplayName"));
            initialPoolSizeAttribute.setField("getMethod", "getInitialPoolSize");
            initialPoolSizeAttribute.setField("setMethod", "setInitialPoolSize");
            ucpMBeanAttributeInfo[1] = new ModelMBeanAttributeInfo("initialPoolSize", "int", UCPErrorHandler.findMessage("InitialPoolSizeAttrDescription"), true, true, false, initialPoolSizeAttribute);
            DescriptorSupport minPoolSizeAttribute = new DescriptorSupport();
            minPoolSizeAttribute.setField("name", "minPoolSize");
            minPoolSizeAttribute.setField("descriptorType", "attribute");
            minPoolSizeAttribute.setField("displayName", UCPErrorHandler.findMessage("MinPoolSizeAttrDisplayName"));
            minPoolSizeAttribute.setField("getMethod", "getMinPoolSize");
            minPoolSizeAttribute.setField("setMethod", "setMinPoolSize");
            ucpMBeanAttributeInfo[2] = new ModelMBeanAttributeInfo("minPoolSize", "int", UCPErrorHandler.findMessage("MinPoolSizeAttrDescription"), true, true, false, minPoolSizeAttribute);
            DescriptorSupport maxPoolSizeAttribute = new DescriptorSupport();
            maxPoolSizeAttribute.setField("name", "maxPoolSize");
            maxPoolSizeAttribute.setField("descriptorType", "attribute");
            maxPoolSizeAttribute.setField("displayName", UCPErrorHandler.findMessage("MaxPoolSizeAttrDisplayName"));
            maxPoolSizeAttribute.setField("getMethod", "getMaxPoolSize");
            maxPoolSizeAttribute.setField("setMethod", "setMaxPoolSize");
            ucpMBeanAttributeInfo[3] = new ModelMBeanAttributeInfo("maxPoolSize", "int", UCPErrorHandler.findMessage("MaxPoolSizeAttrDescription"), true, true, false, maxPoolSizeAttribute);
            DescriptorSupport inactiveConnectionTimeoutAttribute = new DescriptorSupport();
            inactiveConnectionTimeoutAttribute.setField("name", "inactiveConnectionTimeout");
            inactiveConnectionTimeoutAttribute.setField("descriptorType", "attribute");
            inactiveConnectionTimeoutAttribute.setField("displayName", UCPErrorHandler.findMessage("InactiveConnectionTimeoutAttrDisplayName"));
            inactiveConnectionTimeoutAttribute.setField("getMethod", "getInactiveConnectionTimeout");
            inactiveConnectionTimeoutAttribute.setField("setMethod", "setInactiveConnectionTimeout");
            ucpMBeanAttributeInfo[4] = new ModelMBeanAttributeInfo("inactiveConnectionTimeout", "int", UCPErrorHandler.findMessage("InactiveConnectionTimeoutAttrDescription"), true, true, false, inactiveConnectionTimeoutAttribute);
            DescriptorSupport abandonedConnectionTimeoutAttribue = new DescriptorSupport();
            abandonedConnectionTimeoutAttribue.setField("name", "abandonedConnectionTimeout");
            abandonedConnectionTimeoutAttribue.setField("descriptorType", "attribute");
            abandonedConnectionTimeoutAttribue.setField("displayName", UCPErrorHandler.findMessage("AbandonedConnectionTimeoutAttrDisplayName"));
            abandonedConnectionTimeoutAttribue.setField("getMethod", "getAbandonedConnectionTimeout");
            abandonedConnectionTimeoutAttribue.setField("setMethod", "setAbandonedConnectionTimeout");
            ucpMBeanAttributeInfo[5] = new ModelMBeanAttributeInfo("abandonedConnectionTimeout", "int", UCPErrorHandler.findMessage("AbandonedConnectionTimeoutAttrDescription"), true, true, false, abandonedConnectionTimeoutAttribue);
            DescriptorSupport connectionWaitTimeoutAttribute = new DescriptorSupport();
            connectionWaitTimeoutAttribute.setField("name", "connectionWaitTimeout");
            connectionWaitTimeoutAttribute.setField("descriptorType", "attribute");
            connectionWaitTimeoutAttribute.setField("displayName", UCPErrorHandler.findMessage("ConnectionWaitTimeoutAttrDisplayName"));
            connectionWaitTimeoutAttribute.setField("getMethod", "getConnectionWaitTimeout");
            connectionWaitTimeoutAttribute.setField("setMethod", "setConnectionWaitTimeout");
            ucpMBeanAttributeInfo[6] = new ModelMBeanAttributeInfo("connectionWaitTimeout", "int", UCPErrorHandler.findMessage("ConnectionWaitTimeoutAttrDescription"), true, true, false, connectionWaitTimeoutAttribute);
            DescriptorSupport timeToLiveConnectionTimeoutAttribute = new DescriptorSupport();
            timeToLiveConnectionTimeoutAttribute.setField("name", "timeToLiveConnectionTimeout");
            timeToLiveConnectionTimeoutAttribute.setField("descriptorType", "attribute");
            timeToLiveConnectionTimeoutAttribute.setField("displayName", UCPErrorHandler.findMessage("TimeToLiveConnectionTimeoutAttrDisplayName"));
            timeToLiveConnectionTimeoutAttribute.setField("getMethod", "getTimeToLiveConnectionTimeout");
            timeToLiveConnectionTimeoutAttribute.setField("setMethod", "setTimeToLiveConnectionTimeout");
            ucpMBeanAttributeInfo[7] = new ModelMBeanAttributeInfo("timeToLiveConnectionTimeout", "int", UCPErrorHandler.findMessage("TimeToLiveConnectionTimeoutAttrDescription"), true, true, false, timeToLiveConnectionTimeoutAttribute);
            DescriptorSupport timeoutCheckIntervalAttribute = new DescriptorSupport();
            timeoutCheckIntervalAttribute.setField("name", "timeoutCheckInterval");
            timeoutCheckIntervalAttribute.setField("descriptorType", "attribute");
            timeoutCheckIntervalAttribute.setField("displayName", UCPErrorHandler.findMessage("TimeoutCheckIntervalAttrDisplayName"));
            timeoutCheckIntervalAttribute.setField("getMethod", "getTimeoutCheckInterval");
            timeoutCheckIntervalAttribute.setField("setMethod", "setTimeoutCheckInterval");
            ucpMBeanAttributeInfo[8] = new ModelMBeanAttributeInfo("timeoutCheckInterval", "int", UCPErrorHandler.findMessage("TimeoutCheckIntervalAttrDescription"), true, true, false, timeoutCheckIntervalAttribute);
            DescriptorSupport validateConnectionOnBorrowAttribute = new DescriptorSupport();
            validateConnectionOnBorrowAttribute.setField("name", "validateConnectionOnBorrow");
            validateConnectionOnBorrowAttribute.setField("descriptorType", "attribute");
            validateConnectionOnBorrowAttribute.setField("displayName", UCPErrorHandler.findMessage("ValidateConnectionOnBorrowAttrDisplayName"));
            validateConnectionOnBorrowAttribute.setField("getMethod", "getValidateConnectionOnBorrow");
            validateConnectionOnBorrowAttribute.setField("setMethod", "setValidateConnectionOnBorrow");
            ucpMBeanAttributeInfo[9] = new ModelMBeanAttributeInfo("validateConnectionOnBorrow", "boolean", UCPErrorHandler.findMessage("ValidateConnectionOnBorrowAttrDescription"), true, true, false, validateConnectionOnBorrowAttribute);
            DescriptorSupport connectionHarvestTriggerCountAttribue = new DescriptorSupport();
            connectionHarvestTriggerCountAttribue.setField("name", "connectionHarvestTriggerCount");
            connectionHarvestTriggerCountAttribue.setField("descriptorType", "attribute");
            connectionHarvestTriggerCountAttribue.setField("displayName", UCPErrorHandler.findMessage("ConnectionHarvestTriggerCountAttrDisplayName"));
            connectionHarvestTriggerCountAttribue.setField("getMethod", "getConnectionHarvestTriggerCount");
            connectionHarvestTriggerCountAttribue.setField("setMethod", "setConnectionHarvestTriggerCount");
            ucpMBeanAttributeInfo[10] = new ModelMBeanAttributeInfo("connectionHarvestTriggerCount", "int", UCPErrorHandler.findMessage("ConnectionHarvestTriggerCountAttrDescription"), true, true, false, connectionHarvestTriggerCountAttribue);
            DescriptorSupport connectionHarvestMaxCountAttribute = new DescriptorSupport();
            connectionHarvestMaxCountAttribute.setField("name", "connectionHarvestMaxCount");
            connectionHarvestMaxCountAttribute.setField("descriptorType", "attribute");
            connectionHarvestMaxCountAttribute.setField("displayName", UCPErrorHandler.findMessage("ConnectionHarvestMaxCountAttrDisplayName"));
            connectionHarvestMaxCountAttribute.setField("getMethod", "getConnectionHarvestMaxCount");
            connectionHarvestMaxCountAttribute.setField("setMethod", "setConnectionHarvestMaxCount");
            ucpMBeanAttributeInfo[11] = new ModelMBeanAttributeInfo("connectionHarvestMaxCount", "int", UCPErrorHandler.findMessage("ConnectionHarvestMaxCountAttrDescription"), true, true, false, connectionHarvestMaxCountAttribute);
            DescriptorSupport availableConnectionsCountAttribute = new DescriptorSupport();
            availableConnectionsCountAttribute.setField("name", "availableConnectionsCount");
            availableConnectionsCountAttribute.setField("descriptorType", "attribute");
            availableConnectionsCountAttribute.setField("displayName", UCPErrorHandler.findMessage("AvailableConnectionsCountAttrDisplayName"));
            availableConnectionsCountAttribute.setField("getMethod", "getAvailableConnectionsCount");
            ucpMBeanAttributeInfo[12] = new ModelMBeanAttributeInfo("availableConnectionsCount", "int", UCPErrorHandler.findMessage("AvailableConnectionsCountAttrDescription"), true, false, false, availableConnectionsCountAttribute);
            DescriptorSupport borrowedConnectionsCountAttribute = new DescriptorSupport();
            borrowedConnectionsCountAttribute.setField("name", "borrowedConnectionsCount");
            borrowedConnectionsCountAttribute.setField("descriptorType", "attribute");
            borrowedConnectionsCountAttribute.setField("displayName", UCPErrorHandler.findMessage("BorrowedConnectionsCountAttrDisplayName"));
            borrowedConnectionsCountAttribute.setField("getMethod", "getBorrowedConnectionsCount");
            ucpMBeanAttributeInfo[13] = new ModelMBeanAttributeInfo("borrowedConnectionsCount", "int", UCPErrorHandler.findMessage("BorrowedConnectionsCountAttrDescription"), true, false, false, borrowedConnectionsCountAttribute);
            DescriptorSupport maxConnectionReuseTimeAttribute = new DescriptorSupport();
            maxConnectionReuseTimeAttribute.setField("name", "maxConnectionReuseTime");
            maxConnectionReuseTimeAttribute.setField("descriptorType", "attribute");
            maxConnectionReuseTimeAttribute.setField("displayName", UCPErrorHandler.findMessage("MaxConnectionReuseTimeAttrDisplayName"));
            maxConnectionReuseTimeAttribute.setField("getMethod", "getMaxConnectionReuseTime");
            maxConnectionReuseTimeAttribute.setField("setMethod", "setMaxConnectionReuseTime");
            ucpMBeanAttributeInfo[14] = new ModelMBeanAttributeInfo("maxConnectionReuseTime", "long", UCPErrorHandler.findMessage("MaxConnectionReuseTimeAttrDescription"), true, true, false, maxConnectionReuseTimeAttribute);
            DescriptorSupport maxConnectionReuseCountAttribute = new DescriptorSupport();
            maxConnectionReuseCountAttribute.setField("name", "maxConnectionReuseCount");
            maxConnectionReuseCountAttribute.setField("descriptorType", "attribute");
            maxConnectionReuseCountAttribute.setField("displayName", UCPErrorHandler.findMessage("MaxConnectionReuseCountAttrDisplayName"));
            maxConnectionReuseCountAttribute.setField("getMethod", "getMaxConnectionReuseCount");
            maxConnectionReuseCountAttribute.setField("setMethod", "setMaxConnectionReuseCount");
            ucpMBeanAttributeInfo[15] = new ModelMBeanAttributeInfo("maxConnectionReuseCount", "int", UCPErrorHandler.findMessage("MaxConnectionReuseCountAttrDescription"), true, true, false, maxConnectionReuseCountAttribute);
        }
        catch (RuntimeOperationsException ex) {
            UCPErrorHandler.throwUniversalConnectionPoolException(371, ex);
        }
        return ucpMBeanAttributeInfo;
    }

    public ModelMBeanOperationInfo[] getUCPMBeanOperations() throws UniversalConnectionPoolException {
        ModelMBeanOperationInfo[] ucpMBeanOperationInfo = new ModelMBeanOperationInfo[37];
        logger.finest("constructing OperationsInfo");
        try {
            MBeanParameterInfo[] params = null;
            String mBeanName = "oracle.ucp.admin.UniversalConnectionPoolMBean";
            DescriptorSupport startOperation = new DescriptorSupport();
            startOperation.setField("name", "start");
            startOperation.setField("descriptorType", "operation");
            startOperation.setField("class", mBeanName);
            startOperation.setField("role", "operation");
            ucpMBeanOperationInfo[0] = new ModelMBeanOperationInfo("start", UCPErrorHandler.findMessage("StartOperationDescription"), params, "void", 1, startOperation);
            DescriptorSupport stopOperation = new DescriptorSupport();
            stopOperation.setField("name", "stop");
            stopOperation.setField("descriptorType", "operation");
            stopOperation.setField("class", mBeanName);
            stopOperation.setField("role", "operation");
            ucpMBeanOperationInfo[1] = new ModelMBeanOperationInfo("stop", UCPErrorHandler.findMessage("StopOperationDescription"), params, "void", 1, stopOperation);
            DescriptorSupport refreshOperation = new DescriptorSupport();
            refreshOperation.setField("name", "refresh");
            refreshOperation.setField("descriptorType", "operation");
            refreshOperation.setField("class", mBeanName);
            refreshOperation.setField("role", "operation");
            ucpMBeanOperationInfo[2] = new ModelMBeanOperationInfo("refresh", UCPErrorHandler.findMessage("RefreshOperationDescription"), params, "void", 1, refreshOperation);
            DescriptorSupport recycleOperation = new DescriptorSupport();
            recycleOperation.setField("name", "recycle");
            recycleOperation.setField("descriptorType", "operation");
            recycleOperation.setField("class", mBeanName);
            recycleOperation.setField("role", "operation");
            ucpMBeanOperationInfo[3] = new ModelMBeanOperationInfo("recycle", UCPErrorHandler.findMessage("RecycleOperationDescription"), params, "void", 1, recycleOperation);
            DescriptorSupport purgeOperation = new DescriptorSupport();
            purgeOperation.setField("name", "purge");
            purgeOperation.setField("descriptorType", "operation");
            purgeOperation.setField("class", mBeanName);
            purgeOperation.setField("role", "operation");
            ucpMBeanOperationInfo[4] = new ModelMBeanOperationInfo("purge", UCPErrorHandler.findMessage("PurgeOperationDescription"), params, "void", 1, purgeOperation);
            DescriptorSupport getNameOperation = new DescriptorSupport();
            getNameOperation.setField("name", "getName");
            getNameOperation.setField("descriptorType", "operation");
            getNameOperation.setField("class", mBeanName);
            getNameOperation.setField("role", "getter");
            ucpMBeanOperationInfo[5] = new ModelMBeanOperationInfo("getName", UCPErrorHandler.findMessage("GetNameOperationDescription"), params, "String", 0, getNameOperation);
            DescriptorSupport setNameOperation = new DescriptorSupport();
            setNameOperation.setField("name", "setName");
            setNameOperation.setField("descriptorType", "operation");
            setNameOperation.setField("class", mBeanName);
            setNameOperation.setField("role", "setter");
            String setNameOperationDescription = UCPErrorHandler.findMessage("SetNameOperationDescription");
            MBeanParameterInfo[] nameParams = new MBeanParameterInfo[]{new MBeanParameterInfo("poolName", "java.lang.String", setNameOperationDescription)};
            ucpMBeanOperationInfo[6] = new ModelMBeanOperationInfo("setName", setNameOperationDescription, nameParams, "void", 1, setNameOperation);
            DescriptorSupport getInitialPoolSizeOperation = new DescriptorSupport();
            getInitialPoolSizeOperation.setField("name", "getInitialPoolSize");
            getInitialPoolSizeOperation.setField("descriptorType", "operation");
            getInitialPoolSizeOperation.setField("class", mBeanName);
            getInitialPoolSizeOperation.setField("role", "getter");
            ucpMBeanOperationInfo[7] = new ModelMBeanOperationInfo("getInitialPoolSize", UCPErrorHandler.findMessage("GetInitialPoolSizeOperationDescription"), params, "int", 0, getInitialPoolSizeOperation);
            DescriptorSupport setInitialPoolSizeOperation = new DescriptorSupport();
            setInitialPoolSizeOperation.setField("name", "setInitialPoolSize");
            setInitialPoolSizeOperation.setField("descriptorType", "operation");
            setInitialPoolSizeOperation.setField("class", mBeanName);
            setInitialPoolSizeOperation.setField("role", "setter");
            String setInitialPoolSizeOperationDescription = UCPErrorHandler.findMessage("SetInitialPoolSizeOperationDescription");
            MBeanParameterInfo[] initParams = new MBeanParameterInfo[]{new MBeanParameterInfo("initialPoolSize", "java.lang.Integer", setInitialPoolSizeOperationDescription)};
            ucpMBeanOperationInfo[8] = new ModelMBeanOperationInfo("setInitialPoolSize", setInitialPoolSizeOperationDescription, initParams, "void", 1, setInitialPoolSizeOperation);
            DescriptorSupport getMinPoolSizeOperation = new DescriptorSupport();
            getMinPoolSizeOperation.setField("name", "getMinPoolSize");
            getMinPoolSizeOperation.setField("descriptorType", "operation");
            getMinPoolSizeOperation.setField("class", mBeanName);
            getMinPoolSizeOperation.setField("role", "getter");
            ucpMBeanOperationInfo[9] = new ModelMBeanOperationInfo("getMinPoolSize", UCPErrorHandler.findMessage("GetMinPoolSizeOperationDescription"), params, "int", 0, getMinPoolSizeOperation);
            DescriptorSupport setMinPoolSizeOperation = new DescriptorSupport();
            setMinPoolSizeOperation.setField("name", "setMinPoolSize");
            setMinPoolSizeOperation.setField("descriptorType", "operation");
            setMinPoolSizeOperation.setField("class", mBeanName);
            setMinPoolSizeOperation.setField("role", "setter");
            String setMinPoolSizeOperationDescription = UCPErrorHandler.findMessage("SetMinPoolSizeOperationDescription");
            MBeanParameterInfo[] minParams = new MBeanParameterInfo[]{new MBeanParameterInfo("minPoolSize", "java.lang.Integer", setMinPoolSizeOperationDescription)};
            ucpMBeanOperationInfo[10] = new ModelMBeanOperationInfo("setMinPoolSize", setMinPoolSizeOperationDescription, minParams, "void", 1, setMinPoolSizeOperation);
            DescriptorSupport getMaxPoolSizeOperation = new DescriptorSupport();
            getMaxPoolSizeOperation.setField("name", "getMaxPoolSize");
            getMaxPoolSizeOperation.setField("descriptorType", "operation");
            getMaxPoolSizeOperation.setField("class", mBeanName);
            getMaxPoolSizeOperation.setField("role", "getter");
            ucpMBeanOperationInfo[11] = new ModelMBeanOperationInfo("getMaxPoolSize", UCPErrorHandler.findMessage("GetMaxPoolSizeOperationDescription"), params, "int", 0, getMaxPoolSizeOperation);
            DescriptorSupport setMaxPoolSizeOperation = new DescriptorSupport();
            setMaxPoolSizeOperation.setField("name", "setMaxPoolSize");
            setMaxPoolSizeOperation.setField("descriptorType", "operation");
            setMaxPoolSizeOperation.setField("class", mBeanName);
            setMaxPoolSizeOperation.setField("role", "setter");
            String setMaxPoolSizeOperationDescription = UCPErrorHandler.findMessage("SetMaxPoolSizeOperationDescription");
            MBeanParameterInfo[] maxParams = new MBeanParameterInfo[]{new MBeanParameterInfo("maxPoolSize", "java.lang.Integer", setMaxPoolSizeOperationDescription)};
            ucpMBeanOperationInfo[12] = new ModelMBeanOperationInfo("setMaxPoolSize", setMaxPoolSizeOperationDescription, maxParams, "void", 1, setMaxPoolSizeOperation);
            DescriptorSupport getInactiveConnectionTimeoutOperation = new DescriptorSupport();
            getInactiveConnectionTimeoutOperation.setField("name", "getInactiveConnectionTimeout");
            getInactiveConnectionTimeoutOperation.setField("descriptorType", "operation");
            getInactiveConnectionTimeoutOperation.setField("class", mBeanName);
            getInactiveConnectionTimeoutOperation.setField("role", "getter");
            ucpMBeanOperationInfo[13] = new ModelMBeanOperationInfo("getInactiveConnectionTimeout", UCPErrorHandler.findMessage("GetInactiveConnectionTimeoutOperationDescription"), params, "int", 0, getInactiveConnectionTimeoutOperation);
            DescriptorSupport setInactiveConnectionTimeoutOperation = new DescriptorSupport();
            setInactiveConnectionTimeoutOperation.setField("name", "setInactiveConnectionTimeout");
            setInactiveConnectionTimeoutOperation.setField("descriptorType", "operation");
            setInactiveConnectionTimeoutOperation.setField("class", mBeanName);
            setInactiveConnectionTimeoutOperation.setField("role", "setter");
            String setInactiveConnectionTimeoutOperationDescription = UCPErrorHandler.findMessage("SetInactiveConnectionTimeoutOperationDescription");
            MBeanParameterInfo[] inactiveParams = new MBeanParameterInfo[]{new MBeanParameterInfo("inactiveConnectionTimeout", "java.lang.Integer", setInactiveConnectionTimeoutOperationDescription)};
            ucpMBeanOperationInfo[14] = new ModelMBeanOperationInfo("setInactiveConnectionTimeout", setInactiveConnectionTimeoutOperationDescription, inactiveParams, "void", 1, setInactiveConnectionTimeoutOperation);
            DescriptorSupport getAbandonedConnectionTimeoutOperation = new DescriptorSupport();
            getAbandonedConnectionTimeoutOperation.setField("name", "getAbandonedConnectionTimeout");
            getAbandonedConnectionTimeoutOperation.setField("descriptorType", "operation");
            getAbandonedConnectionTimeoutOperation.setField("class", mBeanName);
            getAbandonedConnectionTimeoutOperation.setField("role", "getter");
            ucpMBeanOperationInfo[15] = new ModelMBeanOperationInfo("getAbandonedConnectionTimeout", UCPErrorHandler.findMessage("GetAbandonedConnectionTimeoutOperationDescription"), params, "int", 0, getAbandonedConnectionTimeoutOperation);
            DescriptorSupport setAbandonedConnectionTimeoutOperation = new DescriptorSupport();
            setAbandonedConnectionTimeoutOperation.setField("name", "setAbandonedConnectionTimeout");
            setAbandonedConnectionTimeoutOperation.setField("descriptorType", "operation");
            setAbandonedConnectionTimeoutOperation.setField("class", mBeanName);
            setAbandonedConnectionTimeoutOperation.setField("role", "setter");
            String setAbandonedConnectionTimeoutOperationDescription = UCPErrorHandler.findMessage("SetAbandonedConnectionTimeoutOperationDescription");
            MBeanParameterInfo[] abanParams = new MBeanParameterInfo[]{new MBeanParameterInfo("abandonedConnectionTimeout", "java.lang.Integer", setAbandonedConnectionTimeoutOperationDescription)};
            ucpMBeanOperationInfo[16] = new ModelMBeanOperationInfo("setAbandonedConnectionTimeout", setAbandonedConnectionTimeoutOperationDescription, abanParams, "void", 1, setAbandonedConnectionTimeoutOperation);
            DescriptorSupport getConnectionWaitTimeoutOperation = new DescriptorSupport();
            getConnectionWaitTimeoutOperation.setField("name", "getConnectionWaitTimeout");
            getConnectionWaitTimeoutOperation.setField("descriptorType", "operation");
            getConnectionWaitTimeoutOperation.setField("class", mBeanName);
            getConnectionWaitTimeoutOperation.setField("role", "getter");
            ucpMBeanOperationInfo[17] = new ModelMBeanOperationInfo("getConnectionWaitTimeout", UCPErrorHandler.findMessage("GetConnectionWaitTimeoutOperationDescription"), params, "int", 0, getConnectionWaitTimeoutOperation);
            DescriptorSupport setConnectionWaitTimeoutOperation = new DescriptorSupport();
            setConnectionWaitTimeoutOperation.setField("name", "setConnectionWaitTimeout");
            setConnectionWaitTimeoutOperation.setField("descriptorType", "operation");
            setConnectionWaitTimeoutOperation.setField("class", mBeanName);
            setConnectionWaitTimeoutOperation.setField("role", "setter");
            String setConnectionWaitTimeoutOperationDescription = UCPErrorHandler.findMessage("SetConnectionWaitTimeoutOperationDescription");
            MBeanParameterInfo[] connParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionWaitTimeout", "java.lang.Integer", setConnectionWaitTimeoutOperationDescription)};
            ucpMBeanOperationInfo[18] = new ModelMBeanOperationInfo("setConnectionWaitTimeout", setConnectionWaitTimeoutOperationDescription, connParams, "void", 1, setConnectionWaitTimeoutOperation);
            DescriptorSupport getTimeToLiveConnectionTimeoutOperation = new DescriptorSupport();
            getTimeToLiveConnectionTimeoutOperation.setField("name", "getTimeToLiveConnectionTimeout");
            getTimeToLiveConnectionTimeoutOperation.setField("descriptorType", "operation");
            getTimeToLiveConnectionTimeoutOperation.setField("class", mBeanName);
            getTimeToLiveConnectionTimeoutOperation.setField("role", "getter");
            ucpMBeanOperationInfo[19] = new ModelMBeanOperationInfo("getTimeToLiveConnectionTimeout", UCPErrorHandler.findMessage("GetTimeToLiveConnectionTimeoutOperationDescription"), params, "int", 0, getTimeToLiveConnectionTimeoutOperation);
            DescriptorSupport setTimeToLiveConnectionTimeoutOperation = new DescriptorSupport();
            setTimeToLiveConnectionTimeoutOperation.setField("name", "setTimeToLiveConnectionTimeout");
            setTimeToLiveConnectionTimeoutOperation.setField("descriptorType", "operation");
            setTimeToLiveConnectionTimeoutOperation.setField("class", mBeanName);
            setTimeToLiveConnectionTimeoutOperation.setField("role", "setter");
            String setTimeToLiveConnectionTimeoutOperationDescription = UCPErrorHandler.findMessage("SetTimeToLiveConnectionTimeoutOperationDescription");
            MBeanParameterInfo[] timeParams = new MBeanParameterInfo[]{new MBeanParameterInfo("timeToLiveConnectionTimeout", "java.lang.Integer", setTimeToLiveConnectionTimeoutOperationDescription)};
            ucpMBeanOperationInfo[20] = new ModelMBeanOperationInfo("setTimeToLiveConnectionTimeout", setTimeToLiveConnectionTimeoutOperationDescription, timeParams, "void", 1, setTimeToLiveConnectionTimeoutOperation);
            DescriptorSupport getTimeoutCheckIntervalOperation = new DescriptorSupport();
            getTimeoutCheckIntervalOperation.setField("name", "getTimeoutCheckInterval");
            getTimeoutCheckIntervalOperation.setField("descriptorType", "operation");
            getTimeoutCheckIntervalOperation.setField("class", mBeanName);
            getTimeoutCheckIntervalOperation.setField("role", "getter");
            ucpMBeanOperationInfo[21] = new ModelMBeanOperationInfo("getTimeoutCheckInterval", UCPErrorHandler.findMessage("GetTimeoutCheckIntervalOperationDescription"), params, "int", 0, getTimeoutCheckIntervalOperation);
            DescriptorSupport setTimeoutCheckIntervalOperation = new DescriptorSupport();
            setTimeoutCheckIntervalOperation.setField("name", "setTimeoutCheckInterval");
            setTimeoutCheckIntervalOperation.setField("descriptorType", "operation");
            setTimeoutCheckIntervalOperation.setField("class", mBeanName);
            setTimeoutCheckIntervalOperation.setField("role", "setter");
            String setTimeoutCheckIntervalOperationDescription = UCPErrorHandler.findMessage("SetTimeoutCheckIntervalOperationDescription");
            MBeanParameterInfo[] timeckParams = new MBeanParameterInfo[]{new MBeanParameterInfo("timeoutCheckInterval", "java.lang.Integer", setTimeoutCheckIntervalOperationDescription)};
            ucpMBeanOperationInfo[22] = new ModelMBeanOperationInfo("setTimeoutCheckInterval", setTimeoutCheckIntervalOperationDescription, timeckParams, "void", 1, setTimeoutCheckIntervalOperation);
            DescriptorSupport getValidateConnectionOnBorrowOperation = new DescriptorSupport();
            getValidateConnectionOnBorrowOperation.setField("name", "getValidateConnectionOnBorrow");
            getValidateConnectionOnBorrowOperation.setField("descriptorType", "operation");
            getValidateConnectionOnBorrowOperation.setField("class", mBeanName);
            getValidateConnectionOnBorrowOperation.setField("role", "getter");
            ucpMBeanOperationInfo[23] = new ModelMBeanOperationInfo("getValidateConnectionOnBorrow", UCPErrorHandler.findMessage("GetValidateConnectionOnBorrowOperationDescription"), params, "boolean", 0, getValidateConnectionOnBorrowOperation);
            DescriptorSupport setValidateConnectionOnBorrowOperation = new DescriptorSupport();
            setValidateConnectionOnBorrowOperation.setField("name", "setValidateConnectionOnBorrow");
            setValidateConnectionOnBorrowOperation.setField("descriptorType", "operation");
            setValidateConnectionOnBorrowOperation.setField("class", mBeanName);
            setValidateConnectionOnBorrowOperation.setField("role", "setter");
            String setValidateConnectionOnBorrowOperationDescription = UCPErrorHandler.findMessage("SetValidateConnectionOnBorrowOperationDescription");
            MBeanParameterInfo[] validateParams = new MBeanParameterInfo[]{new MBeanParameterInfo("validateConnectionOnBorrow", "java.lang.Boolean", setValidateConnectionOnBorrowOperationDescription)};
            ucpMBeanOperationInfo[24] = new ModelMBeanOperationInfo("setValidateConnectionOnBorrow", setValidateConnectionOnBorrowOperationDescription, validateParams, "void", 1, setValidateConnectionOnBorrowOperation);
            DescriptorSupport getConnectionHarvestTriggerCountOperation = new DescriptorSupport();
            getConnectionHarvestTriggerCountOperation.setField("name", "getConnectionHarvestTriggerCount");
            getConnectionHarvestTriggerCountOperation.setField("descriptorType", "operation");
            getConnectionHarvestTriggerCountOperation.setField("class", mBeanName);
            getConnectionHarvestTriggerCountOperation.setField("role", "getter");
            ucpMBeanOperationInfo[25] = new ModelMBeanOperationInfo("getConnectionHarvestTriggerCount", UCPErrorHandler.findMessage("GetConnectionHarvestTriggerCountOperationDescription"), params, "int", 0, getConnectionHarvestTriggerCountOperation);
            DescriptorSupport setConnectionHarvestTriggerCountOperation = new DescriptorSupport();
            setConnectionHarvestTriggerCountOperation.setField("name", "setConnectionHarvestTriggerCount");
            setConnectionHarvestTriggerCountOperation.setField("descriptorType", "operation");
            setConnectionHarvestTriggerCountOperation.setField("class", mBeanName);
            setConnectionHarvestTriggerCountOperation.setField("role", "setter");
            String setConnectionHarvestTriggerCountOperationDescription = UCPErrorHandler.findMessage("SetConnectionHarvestTriggerCountOperationDescription");
            MBeanParameterInfo[] harvestParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionHarvestTriggerCount", "java.lang.Integer", setConnectionHarvestTriggerCountOperationDescription)};
            ucpMBeanOperationInfo[26] = new ModelMBeanOperationInfo("setConnectionHarvestTriggerCount", setConnectionHarvestTriggerCountOperationDescription, harvestParams, "void", 1, setConnectionHarvestTriggerCountOperation);
            DescriptorSupport getConnectionHarvestMaxCountOperation = new DescriptorSupport();
            getConnectionHarvestMaxCountOperation.setField("name", "getConnectionHarvestMaxCount");
            getConnectionHarvestMaxCountOperation.setField("descriptorType", "operation");
            getConnectionHarvestMaxCountOperation.setField("class", mBeanName);
            getConnectionHarvestMaxCountOperation.setField("role", "getter");
            ucpMBeanOperationInfo[27] = new ModelMBeanOperationInfo("getConnectionHarvestMaxCount", UCPErrorHandler.findMessage("GetConnectionHarvestMaxCountOperationDescription"), params, "int", 0, getConnectionHarvestMaxCountOperation);
            DescriptorSupport setConnectionHarvestMaxCountOperation = new DescriptorSupport();
            setConnectionHarvestMaxCountOperation.setField("name", "setConnectionHarvestMaxCount");
            setConnectionHarvestMaxCountOperation.setField("descriptorType", "operation");
            setConnectionHarvestMaxCountOperation.setField("class", mBeanName);
            setConnectionHarvestMaxCountOperation.setField("role", "setter");
            String setConnectionHarvestMaxCountOperationDescription = UCPErrorHandler.findMessage("SetConnectionHarvestMaxCountOperationDescription");
            MBeanParameterInfo[] harvestMaxParams = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionHarvestMaxCount", "java.lang.Integer", setConnectionHarvestMaxCountOperationDescription)};
            ucpMBeanOperationInfo[28] = new ModelMBeanOperationInfo("setConnectionHarvestMaxCount", setConnectionHarvestMaxCountOperationDescription, harvestMaxParams, "void", 1, setConnectionHarvestMaxCountOperation);
            DescriptorSupport getAvailableConnectionsCountOperation = new DescriptorSupport();
            getAvailableConnectionsCountOperation.setField("name", "getAvailableConnectionsCount");
            getAvailableConnectionsCountOperation.setField("descriptorType", "operation");
            getAvailableConnectionsCountOperation.setField("class", mBeanName);
            getAvailableConnectionsCountOperation.setField("role", "getter");
            ucpMBeanOperationInfo[29] = new ModelMBeanOperationInfo("getAvailableConnectionsCount", UCPErrorHandler.findMessage("GetAvailableConnectionsCountOperationDescription"), params, "int", 0, getAvailableConnectionsCountOperation);
            DescriptorSupport getBorrowedConnectionsCountOperation = new DescriptorSupport();
            getBorrowedConnectionsCountOperation.setField("name", "getBorrowedConnectionsCount");
            getBorrowedConnectionsCountOperation.setField("descriptorType", "operation");
            getBorrowedConnectionsCountOperation.setField("class", mBeanName);
            getBorrowedConnectionsCountOperation.setField("role", "getter");
            ucpMBeanOperationInfo[30] = new ModelMBeanOperationInfo("getBorrowedConnectionsCount", UCPErrorHandler.findMessage("GetBorrowedConnectionsCountOperationDescription"), params, "int", 0, getBorrowedConnectionsCountOperation);
            DescriptorSupport getStatisticsOperation = new DescriptorSupport();
            getStatisticsOperation.setField("name", "getStatistics");
            getStatisticsOperation.setField("descriptorType", "operation");
            getStatisticsOperation.setField("class", mBeanName);
            getStatisticsOperation.setField("role", "operation");
            ucpMBeanOperationInfo[31] = new ModelMBeanOperationInfo("getStatistics", UCPErrorHandler.findMessage("GetStatisticsOperationDescription"), params, "UniversalConnectionPoolStatistics", 1, getStatisticsOperation);
            DescriptorSupport getLifeCycleStateOperation = new DescriptorSupport();
            getLifeCycleStateOperation.setField("name", "getLifeCycleState");
            getLifeCycleStateOperation.setField("descriptorType", "operation");
            getLifeCycleStateOperation.setField("class", mBeanName);
            getLifeCycleStateOperation.setField("role", "operation");
            ucpMBeanOperationInfo[32] = new ModelMBeanOperationInfo("getLifeCycleState", UCPErrorHandler.findMessage("GetLifeCycleStateOperationDescription"), params, "UniversalConnectionPoolLifeCycleState", 1, getLifeCycleStateOperation);
            DescriptorSupport getMaxConnectionReuseTimeOperation = new DescriptorSupport();
            getMaxConnectionReuseTimeOperation.setField("name", "getMaxConnectionReuseTime");
            getMaxConnectionReuseTimeOperation.setField("descriptorType", "operation");
            getMaxConnectionReuseTimeOperation.setField("class", mBeanName);
            getMaxConnectionReuseTimeOperation.setField("role", "getter");
            ucpMBeanOperationInfo[33] = new ModelMBeanOperationInfo("getMaxConnectionReuseTime", UCPErrorHandler.findMessage("GetMaxConnectionReuseTimeOperationDescription"), params, "long", 0, getMaxConnectionReuseTimeOperation);
            DescriptorSupport setMaxConnectionReuseTimeOperation = new DescriptorSupport();
            setMaxConnectionReuseTimeOperation.setField("name", "setMaxConnectionReuseTime");
            setMaxConnectionReuseTimeOperation.setField("descriptorType", "operation");
            setMaxConnectionReuseTimeOperation.setField("class", mBeanName);
            setMaxConnectionReuseTimeOperation.setField("role", "setter");
            String setMaxConnectionReuseTimeOperationDescription = UCPErrorHandler.findMessage("SetMaxConnectionReuseTimeOperationDescription");
            MBeanParameterInfo[] maxConnectionReuseParams = new MBeanParameterInfo[]{new MBeanParameterInfo("maxConnectionReuseTime", "java.lang.Long", setMaxConnectionReuseTimeOperationDescription)};
            ucpMBeanOperationInfo[34] = new ModelMBeanOperationInfo("setMaxConnectionReuseTime", setMaxConnectionReuseTimeOperationDescription, maxConnectionReuseParams, "void", 1, setMaxConnectionReuseTimeOperation);
            DescriptorSupport getMaxConnectionReuseCountOperation = new DescriptorSupport();
            getMaxConnectionReuseCountOperation.setField("name", "getMaxConnectionReuseCount");
            getMaxConnectionReuseCountOperation.setField("descriptorType", "operation");
            getMaxConnectionReuseCountOperation.setField("class", mBeanName);
            getMaxConnectionReuseCountOperation.setField("role", "getter");
            ucpMBeanOperationInfo[35] = new ModelMBeanOperationInfo("getMaxConnectionReuseCount", UCPErrorHandler.findMessage("GetMaxConnectionReuseCountOperationDescription"), params, "int", 0, getMaxConnectionReuseCountOperation);
            DescriptorSupport setMaxConnectionReuseCountOperation = new DescriptorSupport();
            setMaxConnectionReuseCountOperation.setField("name", "setMaxConnectionReuseCount");
            setMaxConnectionReuseCountOperation.setField("descriptorType", "operation");
            setMaxConnectionReuseCountOperation.setField("class", mBeanName);
            setMaxConnectionReuseCountOperation.setField("role", "setter");
            String setMaxConnectionReuseCountOperationDescription = UCPErrorHandler.findMessage("SetMaxConnectionReuseCountOperationDescription");
            MBeanParameterInfo[] maxConnectionReuseCountParams = new MBeanParameterInfo[]{new MBeanParameterInfo("maxConnectionReuseCount", "java.lang.Integer", setMaxConnectionReuseCountOperationDescription)};
            ucpMBeanOperationInfo[36] = new ModelMBeanOperationInfo("setMaxConnectionReuseCount", setMaxConnectionReuseCountOperationDescription, maxConnectionReuseCountParams, "void", 1, setMaxConnectionReuseCountOperation);
        }
        catch (RuntimeOperationsException e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(372, e);
        }
        return ucpMBeanOperationInfo;
    }

    private static ModelMBeanNotificationInfo[] getNotificationsInfo() throws UniversalConnectionPoolException {
        ModelMBeanNotificationInfo[] notifInfo = new ModelMBeanNotificationInfo[]{};
        return notifInfo;
    }
}

