/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

class InactiveConnectionTimerTask
extends UCPTimerTaskImpl {
    private static final Logger logger = UCPLoggerFactory.createLogger(InactiveConnectionTimerTask.class.getCanonicalName());
    private final UniversalConnectionPoolBase m_connectionPool;

    InactiveConnectionTimerTask(UniversalConnectionPoolBase connectionPool) throws UniversalConnectionPoolException {
        if (connectionPool == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(54);
            logger.throwing(this.getClass().getName(), "InactiveConnectionTimerTask", ucpe);
            throw ucpe;
        }
        this.m_connectionPool = connectionPool;
    }

    public void run() {
        this.m_connectionPool.processInactiveConnections();
    }

    UniversalConnectionPool getConnectionPool() {
        return this.m_connectionPool;
    }
}

