/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCPTaskManagerImpl
implements TaskManager {
    private static final Logger logger = UCPLoggerFactory.createLogger(UCPTaskManagerImpl.class.getCanonicalName());
    public static final int THREAD_POOL_MAX_SIZE = 24;
    public static final int THREAD_POOL_CORE_SIZE = 4;
    public static final int THREAD_POOL_QUEUE_SIZE = 4;
    public static final int THREAD_POOL_KEEP_ALIVE_TIME = 180;
    private ExecutorService wtp = null;

    @Override
    public synchronized void start() {
        if (null != this.wtp) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    ThreadFactory tf = new ThreadFactory(){
                        private final AtomicInteger numCreatedThreads = new AtomicInteger(0);
                        private static final String THREAD_NAME_PREFIX = "UCP-worker-thread-";

                        public Thread newThread(Runnable r) {
                            Thread newT = new Thread(null, r, THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                            newT.setPriority(5);
                            newT.setDaemon(true);
                            return newT;
                        }
                    };
                    UCPTaskManagerImpl.this.wtp = new ThreadPoolExecutor(4, 24, 180L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(4), tf, new ThreadPoolExecutor.CallerRunsPolicy());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.log(Level.FINEST, "create worker thread pool", e);
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return null != this.wtp;
    }

    @Override
    public synchronized void stop() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    if (null != UCPTaskManagerImpl.this.wtp) {
                        UCPTaskManagerImpl.this.wtp.shutdown();
                        UCPTaskManagerImpl.this.wtp = null;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.log(Level.FINEST, "shutdown worker thread pool", e);
        }
    }

    @Override
    public <T> TaskHandle<T> submitTask(final Task<T> task) {
        if (null == this.wtp) {
            logger.finest("wtp not started");
            return null;
        }
        if (!(task instanceof UCPTaskBase)) {
            logger.finest("wrong task object");
            return null;
        }
        final Future<T> future = this.wtp.submit(task);
        ((UCPTaskBase)task).setFuture(future);
        return new TaskHandle<T>(){

            @Override
            public T get(long timeout) throws TaskManagerException {
                try {
                    if (timeout == 0L) {
                        return future.get();
                    }
                    return future.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw new TaskManagerException(e);
                }
            }

            @Override
            public Task<T> getTask() {
                return task;
            }
        };
    }

    public ExecutorService getUCPThreadPool() {
        return this.wtp;
    }
}

