/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTaskBase;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.ONSDatabaseFailoverEvent;
import oracle.ucp.jdbc.oracle.ONSOracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskManager;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
class ONSDatabaseEventHandlerTask
extends FailoverEventHandlerTaskBase {
    private final OracleFailoverEventSubscriber m_onsSubscriber;
    private final boolean m_subscriberFailed;
    private final TaskManager m_taskManager;
    private final LinkedList<OracleFailoverEvent> m_recentEvents = new LinkedList();
    private static final int EVENT_AGE_OUT_PERIOD = 120000;
    private long m_timestampOfLastEvent;
    private static final String FAN_STATUS_FIELD = "status";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    ONSDatabaseEventHandlerTask(Failoverable failoverableObject, TaskManager taskManager) throws UniversalConnectionPoolException {
        this(failoverableObject, null, taskManager);
    }

    protected ONSDatabaseEventHandlerTask(Failoverable failoverableObject, OracleFailoverEventSubscriber subscriber, TaskManager taskManager) throws UniversalConnectionPoolException {
        super(failoverableObject);
        ONS currentONS = ((RACManagerImpl)failoverableObject).getONS();
        if (null == subscriber) {
            ONSOracleFailoverEventSubscriber s = new ONSOracleFailoverEventSubscriber(currentONS);
            this.m_subscriberFailed = s.isFailed();
            this.m_onsSubscriber = s;
        } else {
            this.m_subscriberFailed = false;
            this.m_onsSubscriber = subscriber;
        }
        this.m_taskManager = taskManager;
    }

    @Override
    public void run() {
        boolean bl = (0xC0000000000000L & TraceControllerImpl.feature) != 0L;
        Notification event = null;
        boolean retrySubscription = false;
        if (!this.m_subscriberFailed) {
            while (!this.isTerminate()) {
                block14: {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$0, this, "check for events");
                    }
                    try {
                        event = this.m_onsSubscriber.receive();
                        if (event != null) {
                            ONSDatabaseFailoverEvent oracleFailoverEvent = event.get(FAN_STATUS_FIELD) != null ? new ONSDatabaseFailoverEvent(event) : new ONSDatabaseFailoverEvent(event.type(), event.body());
                            this.handleEvent(oracleFailoverEvent);
                            if (bl) {
                                ClioSupport.ilogFinest($$$loggerRef$$$0, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$0, this, "event triggered: " + ((Object)oracleFailoverEvent).toString());
                            }
                        } else if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$0, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$0, this, "received null event");
                        }
                    }
                    catch (UniversalConnectionPoolException ucpEx) {
                        if (bl) {
                            ClioSupport.ilogThrowing($$$loggerRef$$$0, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$0, this, ucpEx);
                        }
                        retrySubscription = true;
                    }
                    if (!retrySubscription) continue;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        if (!bl) break block14;
                        ClioSupport.ilogFinest($$$loggerRef$$$0, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$0, this, "sleep interrupted");
                    }
                }
                retrySubscription = false;
            }
        } else if (bl) {
            ClioSupport.ilogFinest($$$loggerRef$$$0, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$0, this, "ONS subscriber failed");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleEvent(FailoverEvent failoverEvent) throws UniversalConnectionPoolException {
        void event;
        boolean bl = (0xC0000000000000L & TraceControllerImpl.feature) != 0L;
        OracleFailoverEvent oevent = (OracleFailoverEvent)event;
        if (!oevent.isValid()) {
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$1, this, "Invalid HA event received: " + event);
            }
            return;
        }
        long ts = oevent.getTimestamp();
        if (ts >= 0L && ts < this.m_timestampOfLastEvent) {
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$1, this, "Out-of-order HA event received: " + event);
            }
            return;
        }
        Iterator<OracleFailoverEvent> iterator = this.m_recentEvents.descendingIterator();
        boolean foundRedundant = false;
        String newType = oevent.getEventType();
        String newSvc = oevent.getServiceName();
        String newInst = oevent.getInstanceName();
        String newDb = oevent.getDbUniqueName();
        String newHst = oevent.getHostName();
        String newStat = oevent.getStatus();
        if (null != newSvc && newSvc.contains("%")) {
            OracleFailoverEvent nextEvent;
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$1, this, "GDS service name: " + newSvc + ", processing GDS-based filtering");
            }
            if (newType.equals("database/event/service")) {
                String nextInstName = null;
                while (iterator.hasNext()) {
                    nextEvent = iterator.next();
                    nextInstName = nextEvent.getInstanceName();
                    if (newStat == null || !newStat.equals(nextEvent.getStatus()) || newSvc == null || !newSvc.equals(nextEvent.getServiceName()) || newDb == null || !newDb.equals(nextEvent.getDbUniqueName()) || newHst == null || !newHst.equals(nextEvent.getHostName()) || (newInst != null || nextInstName != null) && (newInst == null || nextInstName != null && !newInst.equals(nextInstName))) continue;
                    foundRedundant = true;
                    if (!bl) break;
                    ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$1, this, "Redundant HA service event received and ignored: " + oevent);
                    break;
                }
            } else if (newType.equals("database/event/host")) {
                while (iterator.hasNext()) {
                    nextEvent = iterator.next();
                    if (newHst == null || !newHst.equals(nextEvent.getHostName())) continue;
                    foundRedundant = true;
                    if (!bl) break;
                    ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$1, this, "Redundant HA host event received and ignored: " + oevent);
                    break;
                }
            }
            if (!foundRedundant) {
                this.m_recentEvents.addLast(oevent);
                this.m_timestampOfLastEvent = oevent.getTimestamp();
                super.handleEvent((FailoverEvent)event);
                while ((nextEvent = this.m_recentEvents.peekFirst()) != null && this.m_timestampOfLastEvent > nextEvent.getTimestamp() + 120000L) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$1, this, "about to remove " + nextEvent.toString());
                    }
                    this.m_recentEvents.removeFirst();
                }
            }
        } else {
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$1, ONSDatabaseEventHandlerTask.class, $$$methodRef$$$1, this, "non-GDS service name: " + newSvc + ", skipping GDS-based filtering");
            }
            super.handleEvent((FailoverEvent)event);
        }
    }

    @Override
    public void setTerminate(boolean terminate) {
        super.setTerminate(terminate);
        if (terminate) {
            this.m_onsSubscriber.close();
        }
    }

    @Override
    protected TaskManager getTaskManager() {
        return this.m_taskManager;
    }

    static {
        try {
            $$$methodRef$$$5 = ONSDatabaseEventHandlerTask.class.getDeclaredConstructor(Failoverable.class, OracleFailoverEventSubscriber.class, TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = ONSDatabaseEventHandlerTask.class.getDeclaredConstructor(Failoverable.class, TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("getTaskManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("setTerminate", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("handleEvent", FailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

