/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         Describes the licenses for this project.  This is used
 * to generate
 *         the <a href="/plugins/site/index.html">License</a> page
 * of
 *         the project's web site. Typically the licenses listed
 * for the project
 *         are that of the project itself, and not of dependencies.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class License implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field url
     */
    private String url;

    /**
     * Field distribution
     */
    private String distribution;

    /**
     * Field comments
     */
    private String comments;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Addendum information pertaining to this license.
     *           
     */
    public String getComments()
    {
        return this.comments;
    } //-- String getComments() 

    /**
     * Get 
     *               The primary method by which this project may
     * be distributed.
     *             <dl>
     *               <dt>repo</dt>
     *               <dd>may be downloaded from the Maven
     * repository</dd>
     *               <dt>manual</dt>
     *               <dd>user must manually download and install
     * the dependency.</dd>
     *             </dl>
     *           
     */
    public String getDistribution()
    {
        return this.distribution;
    } //-- String getDistribution() 

    /**
     * Get The full legal name of the license.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get The official url for the license text.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Set 
     *             Addendum information pertaining to this license.
     *           
     * 
     * @param comments
     */
    public void setComments(String comments)
    {
        this.comments = comments;
    } //-- void setComments(String) 

    /**
     * Set 
     *               The primary method by which this project may
     * be distributed.
     *             <dl>
     *               <dt>repo</dt>
     *               <dd>may be downloaded from the Maven
     * repository</dd>
     *               <dt>manual</dt>
     *               <dd>user must manually download and install
     * the dependency.</dd>
     *             </dl>
     *           
     * 
     * @param distribution
     */
    public void setDistribution(String distribution)
    {
        this.distribution = distribution;
    } //-- void setDistribution(String) 

    /**
     * Set The full legal name of the license.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set The official url for the license text.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
