/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ModelBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field modules
     */
    private java.util.List modules;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     * This may be removed or relocated in the near future. It is
     * undecided whether plugins really need a
     *             remote repository set of their own.
     */
    private java.util.List pluginRepositories;

    /**
     * These should ultimately only be compile time dependencies
     * when transitive dependencies come into
     *             play.
     */
    private java.util.List dependencies;

    /**
     * Field reports
     */
    private Object reports;

    /**
     * Field reporting
     */
    private Reporting reporting;

    /**
     * Field dependencyManagement
     */
    private DependencyManagement dependencyManagement;

    /**
     * Field distributionManagement
     */
    private DistributionManagement distributionManagement;

    /**
     * Field properties
     */
    private java.util.Properties properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency
     * 
     * @param dependency
     */
    public void addDependency(Dependency dependency)
    {
        getDependencies().add( dependency );
    } //-- void addDependency(Dependency) 

    /**
     * Method addModule
     * 
     * @param string
     */
    public void addModule(String string)
    {
        getModules().add( string );
    } //-- void addModule(String) 

    /**
     * Method addPluginRepository
     * 
     * @param repository
     */
    public void addPluginRepository(Repository repository)
    {
        getPluginRepositories().add( repository );
    } //-- void addPluginRepository(Repository) 

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Method addRepository
     * 
     * @param repository
     */
    public void addRepository(Repository repository)
    {
        getRepositories().add( repository );
    } //-- void addRepository(Repository) 

    /**
     * Method getDependencies
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
        
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Get 
     *             Default dependency information for grouped
     * projects inheriting from 
     *             this one. The dependency information here will
     * not be checked.
     *             Instead, when a POM derived from this one
     * declares a dependency 
     *             described by a groupId and an artifactId
     * (version not necessary), 
     *             the entries in here will supply default values
     * for that dependency.
     *             Any locally-supplied information for a
     * particular dependency will
     *             overwrite any information specified here for
     * that project.
     *           
     */
    public DependencyManagement getDependencyManagement()
    {
        return this.dependencyManagement;
    } //-- DependencyManagement getDependencyManagement() 

    /**
     * Get Distribution information for a project.
     */
    public DistributionManagement getDistributionManagement()
    {
        return this.distributionManagement;
    } //-- DistributionManagement getDistributionManagement() 

    /**
     * Method getModules
     */
    public java.util.List getModules()
    {
        if ( this.modules == null )
        {
            this.modules = new java.util.ArrayList();
        }
        
        return this.modules;
    } //-- java.util.List getModules() 

    /**
     * Method getPluginRepositories
     */
    public java.util.List getPluginRepositories()
    {
        if ( this.pluginRepositories == null )
        {
            this.pluginRepositories = new java.util.ArrayList();
        }
        
        return this.pluginRepositories;
    } //-- java.util.List getPluginRepositories() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Get 
     *             This element includes the specification of
     * reports to be
     *             included in a Maven-generated site.  These
     * reports will be run
     *             when a user executes <code>maven site</code>. 
     * All of the
     *             reports will be included in the navigation bar
     * for browsing in
     *             the order they are specified.
     *           
     */
    public Reporting getReporting()
    {
        return this.reporting;
    } //-- Reporting getReporting() 

    /**
     * Get 
     *             NOT A VALID ELEMENT. LISTED TO ALLOW LEGACY
     * REPOSITORY POMs TO PARSE.
     *           
     */
    public Object getReports()
    {
        return this.reports;
    } //-- Object getReports() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Method removeDependency
     * 
     * @param dependency
     */
    public void removeDependency(Dependency dependency)
    {
        getDependencies().remove( dependency );
    } //-- void removeDependency(Dependency) 

    /**
     * Method removeModule
     * 
     * @param string
     */
    public void removeModule(String string)
    {
        getModules().remove( string );
    } //-- void removeModule(String) 

    /**
     * Method removePluginRepository
     * 
     * @param repository
     */
    public void removePluginRepository(Repository repository)
    {
        getPluginRepositories().remove( repository );
    } //-- void removePluginRepository(Repository) 

    /**
     * Method removeRepository
     * 
     * @param repository
     */
    public void removeRepository(Repository repository)
    {
        getRepositories().remove( repository );
    } //-- void removeRepository(Repository) 

    /**
     * Set 
     *             <p>
     *               This element describes all of the dependencies
     * associated with a
     *               project.  Each dependency is described by a
     *               <code>dependency</code> element, which is then
     * described by
     *               additional elements (described below).
     *             </p>
     *             <p>
     *               These dependencies are used to construct a
     * classpath for your 
     *               project during the build process.
     *             </p>
     *             <p>
     *               Maven can automatically download these
     * dependencies from a 
     *               <a
     * href="/user-guide.html#Remote%20Repository%20Layout">remote
     * repository</a>.
     *             </p>
     *             <p>
     *               The filename that Maven downloads from the
     * repository is 
     *               <code>artifactId-version.jar</code> where
     * <code>artifactId</code> 
     *               corresponds to the <code>artifactId</code>
     * element and 
     *               <code>version</code> corresponds to the
     * <code>version</code> element.
     *             </p>
     *             <p>
     *               When Maven goes looking for a dependency in
     * the remote repository, 
     *               it uses the dependency element to construct
     * the URL to download 
     *               from. This URL is defined as:
     *             </p>
     *             <div class="source">
     *              
     * <pre>${repo}/${groupId}/${type}s/${artifactId}-${version}.${type}</pre>
     *             </div>
     *             <p>
     *               Where
     *             </p>
     *             <dl>
     *               <dt>repo</dt>
     *               <dd>
     *                 is the remote repository URL specified by 
     *                 <code>${maven.repo.remote}</code>
     *               </dd>
     *               
     *               <dt>groupId</dt>
     *               <dd>is taken from the dependency element</dd>
     *               
     *               <dt>type</dt>
     *               <dd>is taken from the dependency element</dd>
     *               
     *               <dt>artifactId</dt>
     *               <dd>is taken from the dependency element</dd>
     *               
     *               <dt>version</dt>
     *               <dd>is taken from the dependency element</dd>
     *             </dl>
     *           
     * 
     * @param dependencies
     */
    public void setDependencies(java.util.List dependencies)
    {
        this.dependencies = dependencies;
    } //-- void setDependencies(java.util.List) 

    /**
     * Set 
     *             Default dependency information for grouped
     * projects inheriting from 
     *             this one. The dependency information here will
     * not be checked.
     *             Instead, when a POM derived from this one
     * declares a dependency 
     *             described by a groupId and an artifactId
     * (version not necessary), 
     *             the entries in here will supply default values
     * for that dependency.
     *             Any locally-supplied information for a
     * particular dependency will
     *             overwrite any information specified here for
     * that project.
     *           
     * 
     * @param dependencyManagement
     */
    public void setDependencyManagement(DependencyManagement dependencyManagement)
    {
        this.dependencyManagement = dependencyManagement;
    } //-- void setDependencyManagement(DependencyManagement) 

    /**
     * Set Distribution information for a project.
     * 
     * @param distributionManagement
     */
    public void setDistributionManagement(DistributionManagement distributionManagement)
    {
        this.distributionManagement = distributionManagement;
    } //-- void setDistributionManagement(DistributionManagement) 

    /**
     * Set The modules to build in addition to the current project
     * 
     * @param modules
     */
    public void setModules(java.util.List modules)
    {
        this.modules = modules;
    } //-- void setModules(java.util.List) 

    /**
     * Set The lists of the remote repositories for discovering
     * plugins
     * 
     * @param pluginRepositories
     */
    public void setPluginRepositories(java.util.List pluginRepositories)
    {
        this.pluginRepositories = pluginRepositories;
    } //-- void setPluginRepositories(java.util.List) 

    /**
     * Set 
     *              Properties used to fill in plugin configuration
     *           
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 

    /**
     * Set 
     *             This element includes the specification of
     * reports to be
     *             included in a Maven-generated site.  These
     * reports will be run
     *             when a user executes <code>maven site</code>. 
     * All of the
     *             reports will be included in the navigation bar
     * for browsing in
     *             the order they are specified.
     *           
     * 
     * @param reporting
     */
    public void setReporting(Reporting reporting)
    {
        this.reporting = reporting;
    } //-- void setReporting(Reporting) 

    /**
     * Set 
     *             NOT A VALID ELEMENT. LISTED TO ALLOW LEGACY
     * REPOSITORY POMs TO PARSE.
     *           
     * 
     * @param reports
     */
    public void setReports(Object reports)
    {
        this.reports = reports;
    } //-- void setReports(Object) 

    /**
     * Set The lists of the remote repositories
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
