/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Scm implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field connection
     */
    private String connection;

    /**
     * Field developerConnection
     */
    private String developerConnection;

    /**
     * Field tag
     */
    private String tag = "HEAD";

    /**
     * Field url
     */
    private String url;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The source configuration management system URL
     *             that describes the repository and how to connect
     * to the
     *             repository.  This is used by Maven when
     *             <a
     *               href="/plugins/dist/index.html">building
     * versions</a>
     *             from specific ID. <a
     * href="http://maven.apache.org/scm/scm-url-format.html">Url
     * format</a>
     *           
     */
    public String getConnection()
    {
        return this.connection;
    } //-- String getConnection() 

    /**
     * Get 
     *             Just like connection, but for developers, i.e.
     * this scm connection
     *             will not be read only.
     *           
     */
    public String getDeveloperConnection()
    {
        return this.developerConnection;
    } //-- String getDeveloperConnection() 

    /**
     * Get 
     *             The tag of current code. By default, it's set to
     * HEAD during development.
     *           
     */
    public String getTag()
    {
        return this.tag;
    } //-- String getTag() 

    /**
     * Get The URL to the project's browsable CVS repository.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Set 
     *             The source configuration management system URL
     *             that describes the repository and how to connect
     * to the
     *             repository.  This is used by Maven when
     *             <a
     *               href="/plugins/dist/index.html">building
     * versions</a>
     *             from specific ID. <a
     * href="http://maven.apache.org/scm/scm-url-format.html">Url
     * format</a>
     *           
     * 
     * @param connection
     */
    public void setConnection(String connection)
    {
        this.connection = connection;
    } //-- void setConnection(String) 

    /**
     * Set 
     *             Just like connection, but for developers, i.e.
     * this scm connection
     *             will not be read only.
     *           
     * 
     * @param developerConnection
     */
    public void setDeveloperConnection(String developerConnection)
    {
        this.developerConnection = developerConnection;
    } //-- void setDeveloperConnection(String) 

    /**
     * Set 
     *             The tag of current code. By default, it's set to
     * HEAD during development.
     *           
     * 
     * @param tag
     */
    public void setTag(String tag)
    {
        this.tag = tag;
    } //-- void setTag(String) 

    /**
     * Set The URL to the project's browsable CVS repository.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
