/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.sshext;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ScpExternalWagon
extends AbstractWagon
implements CommandExecutor {
    private String scpExecutable = "scp";
    private String sshExecutable = "ssh";
    private String scpArgs = null;
    private String sshArgs = null;
    private int port;
    private File privateKey;

    public void openConnection() throws AuthenticationException {
        File privateKey;
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
        if (this.authenticationInfo.getUserName() == null) {
            this.authenticationInfo.setUserName(System.getProperty("user.name"));
        }
        this.port = this.getRepository().getPort();
        if (this.authenticationInfo.getPassword() == null && (privateKey = this.authenticationInfo.getPrivateKey() != null ? new File(this.authenticationInfo.getPrivateKey()) : this.findPrivateKey()).exists()) {
            if (this.authenticationInfo.getPassphrase() == null) {
                this.authenticationInfo.setPassphrase("");
            }
            this.fireSessionDebug("Using private key: " + privateKey);
            this.privateKey = privateKey;
        }
    }

    private File findPrivateKey() {
        File privateKey;
        String privateKeyDirectory = System.getProperty("wagon.privateKeyDirectory");
        if (privateKeyDirectory == null) {
            privateKeyDirectory = System.getProperty("user.home");
        }
        if (!(privateKey = new File(privateKeyDirectory, ".ssh/id_dsa")).exists()) {
            privateKey = new File(privateKeyDirectory, ".ssh/id_rsa");
        }
        return privateKey;
    }

    public void closeConnection() {
    }

    public void executeCommand(String command) throws CommandExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable(this.sshExecutable);
        if (this.privateKey != null) {
            cl.createArgument().setValue("-i");
            cl.createArgument().setFile(this.privateKey);
        }
        if (this.port != -1) {
            if (this.sshExecutable.indexOf("plink") >= 0) {
                cl.createArgument().setLine("-P " + this.port);
            } else {
                cl.createArgument().setLine("-p " + this.port);
            }
        }
        if (this.sshExecutable.indexOf("plink") >= 0) {
            cl.createArgument().setValue("-batch");
        } else {
            cl.createArgument().setValue("-o");
            cl.createArgument().setValue("BatchMode yes");
        }
        if (this.sshArgs != null) {
            cl.createArgument().setLine(this.sshArgs);
        }
        String remoteHost = this.authenticationInfo.getUserName() + "@" + this.getRepository().getHost();
        cl.createArgument().setValue(remoteHost);
        cl.createArgument().setValue(command);
        try {
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)err);
            if (exitCode != 0) {
                throw new CommandExecutionException("Exit code " + exitCode + " - " + err.getOutput());
            }
        }
        catch (CommandLineException e) {
            throw new CommandExecutionException("Error executing command line", (Throwable)e);
        }
    }

    private void executeScpCommand(File localFile, String remoteFile, boolean put) throws TransferFailedException, ResourceDoesNotExistException {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(localFile.getParentFile().getAbsolutePath());
        cl.setExecutable(this.scpExecutable);
        if (this.privateKey != null) {
            cl.createArgument().setValue("-i");
            cl.createArgument().setFile(this.privateKey);
        }
        if (this.port != -1) {
            cl.createArgument().setLine("-P " + this.port);
        }
        if (this.sshExecutable.indexOf("pscp") >= 0) {
            cl.createArgument().setValue("-batch");
        } else {
            cl.createArgument().setValue("-o");
            cl.createArgument().setValue("BatchMode yes");
        }
        if (this.scpArgs != null) {
            cl.createArgument().setLine(this.scpArgs);
        }
        String qualifiedRemoteFile = this.authenticationInfo.getUserName() + "@" + this.getRepository().getHost() + ":" + remoteFile;
        if (put) {
            cl.createArgument().setValue(localFile.getName());
            cl.createArgument().setValue(qualifiedRemoteFile);
        } else {
            cl.createArgument().setValue(qualifiedRemoteFile);
            cl.createArgument().setValue(localFile.getName());
        }
        try {
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)err);
            if (exitCode != 0) {
                if (!put && err.getOutput().trim().endsWith("No such file or directory")) {
                    throw new ResourceDoesNotExistException(err.getOutput());
                }
                throw new TransferFailedException("Exit code: " + exitCode + " - " + err.getOutput());
            }
        }
        catch (CommandLineException e) {
            throw new TransferFailedException("Error executing command line", (Throwable)e);
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        if (!source.exists()) {
            throw new TransferFailedException("Specified source file does not exist: " + source);
        }
        String basedir = this.getRepository().getBasedir();
        resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
        String dir = PathUtils.dirname((String)resourceName);
        dir = StringUtils.replace((String)dir, (String)"\\", (String)"/");
        String mkdirCmd = "mkdir -p " + basedir + "/" + dir + "\n";
        try {
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error executing command for transfer", (Throwable)e);
        }
        this.firePutStarted(resource, source);
        this.executeScpCommand(source, basedir + "/" + resourceName, true);
        this.postProcessListeners(resource, source, 6);
        try {
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -f " + permissions.getGroup() + " " + basedir + "/" + resourceName + "\n");
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -f " + permissions.getFileMode() + " " + basedir + "/" + resourceName + "\n");
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error executing command for transfer", (Throwable)e);
        }
        this.firePutCompleted(resource, source);
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String basedir = this.getRepository().getBasedir();
        resourceName = StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
        this.createParentDirectories(destination);
        Resource resource = new Resource(resourceName);
        this.fireGetStarted(resource, destination);
        this.executeScpCommand(destination, basedir + "/" + resourceName, false);
        this.postProcessListeners(resource, destination, 5);
        this.fireGetCompleted(resource, destination);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) {
        throw new UnsupportedOperationException("getIfNewer is scp wagon must be still implemented");
    }

    public String getScpExecutable() {
        return this.scpExecutable;
    }

    public void setScpExecutable(String scpExecutable) {
        this.scpExecutable = scpExecutable;
    }

    public String getSshExecutable() {
        return this.sshExecutable;
    }

    public void setSshExecutable(String sshExecutable) {
        this.sshExecutable = sshExecutable;
    }

    public String getScpArgs() {
        return this.scpArgs;
    }

    public void setScpArgs(String scpArgs) {
        this.scpArgs = scpArgs;
    }

    public String getSshArgs() {
        return this.sshArgs;
    }

    public void setSshArgs(String sshArgs) {
        this.sshArgs = sshArgs;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File zipFile;
        String basedir = this.getRepository().getBasedir();
        destinationDirectory = StringUtils.replace((String)destinationDirectory, (String)"\\", (String)"/");
        String path = AbstractWagon.getPath((String)basedir, (String)destinationDirectory);
        try {
            String dirPerms;
            if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
                String umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor((String)dirPerms);
                this.executeCommand(umaskCmd);
            }
            String mkdirCmd = "mkdir -p " + path;
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", (Throwable)e);
        }
        try {
            zipFile = File.createTempFile("wagon", ".zip");
            zipFile.deleteOnExit();
            List files = FileUtils.getFileNames((File)sourceDirectory, (String)"**/**", (String)"", (boolean)false);
            this.createZip(files, zipFile, sourceDirectory);
        }
        catch (IOException e) {
            throw new TransferFailedException("Unable to create ZIP archive of directory", (Throwable)e);
        }
        this.put(zipFile, AbstractWagon.getPath((String)destinationDirectory, (String)zipFile.getName()));
        try {
            this.executeCommand("cd " + path + "; unzip -o " + zipFile.getName() + "; rm -f " + zipFile.getName());
            zipFile.delete();
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -Rf " + permissions.getGroup() + " " + path);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -Rf " + permissions.getFileMode() + " " + path);
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", (Throwable)e);
        }
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }
}

