/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PageResizer {
    private static final float EPSILON = 1.0E-6f;
    private static final int NUMBER_FORMAT_PRECISION = 10000;
    private static final Set<String> SCALABLE_DA_OPERATORS = new HashSet<String>(Arrays.asList("Tf", "TL", "Tc", "Tw", "Ts"));
    private static final Set<String> SCALABLE_RC_PROPERTIES = new HashSet<String>(Arrays.asList("font-size", "line-height", "text-indent", "padding-top", "padding-right", "padding-bottom", "padding-left", "margin-top", "margin-right", "margin-bottom", "margin-left", "border-top-width", "border-right-width", "border-bottom-width", "border-left-width", "width", "height", "letter-spacing", "word-spacing"));
    private static final Set<String> SCALABLE_UNITS = new HashSet<String>(Arrays.asList("pt", "pc", "in", "cm", "mm", "px"));
    private final PageSize size;
    private VerticalAnchorPoint verticalAnchorPoint = VerticalAnchorPoint.CENTER;
    private HorizontalAnchorPoint horizontalAnchorPoint = HorizontalAnchorPoint.CENTER;
    private final ResizeType type;

    public PageResizer(PageSize size, ResizeType type) {
        this.size = size;
        this.type = type;
    }

    public HorizontalAnchorPoint getHorizontalAnchorPoint() {
        return this.horizontalAnchorPoint;
    }

    public void setHorizontalAnchorPoint(HorizontalAnchorPoint anchorPoint) {
        this.horizontalAnchorPoint = anchorPoint;
    }

    public VerticalAnchorPoint getVerticalAnchorPoint() {
        return this.verticalAnchorPoint;
    }

    public void setVerticalAnchorPoint(VerticalAnchorPoint anchorPoint) {
        this.verticalAnchorPoint = anchorPoint;
    }

    public void resize(PdfPage page) {
        if (this.size == null || this.size.getWidth() < 1.0E-6f || this.size.getHeight() < 1.0E-6f) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"Can't resize page to the given size {0} because it is negative or zero", (Object[])new Object[]{this.size}));
        }
        if (page == null) {
            return;
        }
        Rectangle originalPageSize = page.getMediaBox();
        double horizontalScale = this.size.getWidth() / originalPageSize.getWidth();
        double verticalScale = this.size.getHeight() / originalPageSize.getHeight();
        double horizontalFreeSpace = 0.0;
        double verticalFreeSpace = 0.0;
        if (ResizeType.MAINTAIN_ASPECT_RATIO == this.type) {
            double scale;
            horizontalScale = scale = Math.min(horizontalScale, verticalScale);
            verticalScale = scale;
            horizontalFreeSpace = (double)this.size.getWidth() - (double)originalPageSize.getWidth() * scale;
            verticalFreeSpace = (double)this.size.getHeight() - (double)originalPageSize.getHeight() * scale;
        }
        this.updateBoxes(page, originalPageSize);
        AffineTransform scalingMatrix = this.calculateAffineTransform(horizontalScale, verticalScale, horizontalFreeSpace, verticalFreeSpace);
        PdfResources resources = page.getResources();
        if (resources == null) {
            resources = new PdfResources();
            ((PdfDictionary)page.getPdfObject()).put(PdfName.Resources, (PdfObject)resources.getPdfObject());
        }
        PdfCanvas pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), page.getDocument());
        pdfCanvas.concatMatrix(scalingMatrix);
        for (PdfName resName : page.getResources().getResourceNames()) {
            PdfPattern pattern = page.getResources().getPattern(resName);
            if (pattern == null) continue;
            PageResizer.resizePattern(page.getResources(), resName, scalingMatrix);
        }
        for (PdfAnnotation annot : page.getAnnotations()) {
            PageResizer.resizeAnnotation(annot, scalingMatrix);
        }
    }

    static String scaleDaString(String daString, double scale) {
        if (daString == null || daString.trim().isEmpty() || Math.abs(scale - 1.0) < (double)1.0E-6f) {
            return daString;
        }
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(daString.trim().split("\\s+")));
        block2: for (int i = 0; i < tokens.size(); ++i) {
            if (!SCALABLE_DA_OPERATORS.contains(tokens.get(i))) continue;
            int operandIdx = i - 1;
            while (operandIdx >= 0) {
                String token = (String)tokens.get(operandIdx);
                if (token.startsWith("/")) {
                    --operandIdx;
                    continue;
                }
                try {
                    double value = Double.parseDouble(token);
                    tokens.set(operandIdx, PageResizer.formatNumber(value * scale));
                    continue block2;
                }
                catch (NumberFormatException ignore) {
                    --operandIdx;
                }
            }
        }
        return String.join((CharSequence)" ", tokens);
    }

    static String scaleRcString(String rcString, double scale) {
        if (PageResizer.isEmpty(rcString) || Math.abs(scale - 1.0) < (double)1.0E-6f) {
            return rcString;
        }
        boolean containsScalable = false;
        for (String p : SCALABLE_RC_PROPERTIES) {
            if (!rcString.contains(p)) continue;
            containsScalable = true;
            break;
        }
        if (!containsScalable) {
            return rcString;
        }
        RcPropertyParser parser = new RcPropertyParser(rcString);
        StringBuilder out = new StringBuilder();
        int lastWrite = 0;
        while (parser.findNext()) {
            RcPropertyParserResult result = parser.getResult();
            double newValue = result.getParsedValue() * scale;
            String formatted = PageResizer.formatNumber(newValue);
            out.append(rcString.substring(lastWrite, result.getValueStart())).append(formatted);
            lastWrite = result.getValueEnd();
        }
        if (lastWrite == 0) {
            return rcString;
        }
        out.append(rcString.substring(lastWrite, rcString.length()));
        return out.toString();
    }

    static Rectangle scalePageBox(Rectangle originalPageSize, PageSize newPageSize, Rectangle box) {
        if (originalPageSize == null || newPageSize == null || box == null) {
            return box;
        }
        float origW = originalPageSize.getWidth();
        float origH = originalPageSize.getHeight();
        float newW = newPageSize.getWidth();
        float newH = newPageSize.getHeight();
        if (origW < 1.0E-6f || origH < 1.0E-6f) {
            return box;
        }
        float left = box.getLeft() * newW / origW;
        float bottom = box.getBottom() * newH / origH;
        float width = box.getWidth() * newW / origW;
        float height = box.getHeight() * newH / origH;
        return new Rectangle(left, bottom, width, height);
    }

    static void resizeAppearanceStreams(PdfAnnotation annot, AffineTransform scalingMatrix) {
        PdfDictionary ap = annot.getAppearanceDictionary();
        if (ap == null) {
            return;
        }
        for (PdfName key : ap.keySet()) {
            PdfObject apState = ap.get(key);
            if (apState.isStream()) {
                PageResizer.resizeAppearanceStream((PdfStream)apState, scalingMatrix);
                continue;
            }
            if (!apState.isDictionary()) continue;
            PdfDictionary apStateDict = (PdfDictionary)apState;
            for (PdfName subKeyState : apStateDict.keySet()) {
                PdfObject subApState = apStateDict.get(subKeyState);
                if (!subApState.isStream()) continue;
                PageResizer.resizeAppearanceStream((PdfStream)subApState, scalingMatrix);
            }
        }
    }

    private static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void resizePattern(PdfResources resources, PdfName resName, AffineTransform scalingMatrix) {
        AffineTransform newTransform;
        if (resources == null || resName == null || scalingMatrix == null) {
            return;
        }
        PdfDictionary patternDictContainer = resources.getResource(PdfName.Pattern);
        if (patternDictContainer == null) {
            return;
        }
        PdfObject patternObj = resources.getResourceObject(PdfName.Pattern, resName);
        if (patternObj == null) {
            return;
        }
        PdfObject clonedObj = patternObj.clone();
        PdfDictionary clonedPatternDict = (PdfDictionary)clonedObj;
        PdfArray existingMatrix = clonedPatternDict.getAsArray(PdfName.Matrix);
        if (existingMatrix == null) {
            newTransform = new AffineTransform(scalingMatrix);
        } else {
            newTransform = new AffineTransform(existingMatrix.toDoubleArray());
            newTransform.preConcatenate(scalingMatrix);
        }
        double[] newMatrixArray = new double[6];
        newTransform.getMatrix(newMatrixArray);
        clonedPatternDict.put(PdfName.Matrix, new PdfArray(newMatrixArray));
        patternDictContainer.put(resName, clonedPatternDict);
    }

    private static void resizeAnnotation(PdfAnnotation annot, AffineTransform scalingMatrix) {
        PdfArray rectArray = annot.getRectangle();
        if (rectArray != null) {
            double[] rectPoints = new double[]{rectArray.getAsNumber(0).doubleValue(), rectArray.getAsNumber(1).doubleValue(), rectArray.getAsNumber(2).doubleValue(), rectArray.getAsNumber(3).doubleValue()};
            scalingMatrix.transform(rectPoints, 0, rectPoints, 0, 1);
            scalingMatrix.transform(rectPoints, 2, rectPoints, 2, 1);
            annot.setRectangle(new PdfArray(rectPoints));
        }
        PdfDictionary annotDict = (PdfDictionary)annot.getPdfObject();
        PageResizer.transformCoordinateArray(annotDict.getAsArray(PdfName.L), scalingMatrix);
        PageResizer.transformCoordinateArray(annotDict.getAsArray(PdfName.Vertices), scalingMatrix);
        PageResizer.transformCoordinateArray(annotDict.getAsArray(PdfName.QuadPoints), scalingMatrix);
        PageResizer.transformCoordinateArray(annotDict.getAsArray(PdfName.CL), scalingMatrix);
        PdfArray inkList = annotDict.getAsArray(PdfName.InkList);
        if (inkList != null) {
            for (int i = 0; i < inkList.size(); ++i) {
                PageResizer.transformCoordinateArray(inkList.getAsArray(i), scalingMatrix);
            }
        }
        PageResizer.scaleAnnotationScalarProperties(annot, scalingMatrix.getScaleX(), scalingMatrix.getScaleY());
        PageResizer.resizeAppearanceStreams(annot, scalingMatrix);
    }

    private static void transformCoordinateArray(PdfArray coordinateArray, AffineTransform transform) {
        int i;
        if (coordinateArray == null) {
            return;
        }
        if (coordinateArray.size() % 2 != 0) {
            return;
        }
        double[] points = new double[coordinateArray.size()];
        for (i = 0; i < coordinateArray.size(); ++i) {
            points[i] = coordinateArray.getAsNumber(i).doubleValue();
        }
        transform.transform(points, 0, points, 0, points.length / 2);
        for (i = 0; i < coordinateArray.size(); ++i) {
            coordinateArray.set(i, new PdfNumber(points[i]));
        }
    }

    private static void scaleAnnotationScalarProperties(PdfAnnotation annot, double horizontalScale, double verticalScale) {
        PdfDictionary acroFormDictionary;
        PdfArray rd;
        PdfNumber width;
        PdfDictionary bs;
        PdfDictionary annotDict = (PdfDictionary)annot.getPdfObject();
        PdfArray border = annotDict.getAsArray(PdfName.Border);
        if (border != null && border.size() >= 3) {
            border.set(0, new PdfNumber(border.getAsNumber(0).doubleValue() * horizontalScale));
            border.set(1, new PdfNumber(border.getAsNumber(1).doubleValue() * verticalScale));
            border.set(2, new PdfNumber(border.getAsNumber(2).doubleValue() * Math.min(horizontalScale, verticalScale)));
        }
        if ((bs = annotDict.getAsDictionary(PdfName.BS)) != null && (width = bs.getAsNumber(PdfName.W)) != null) {
            bs.put(PdfName.W, new PdfNumber(width.doubleValue() * Math.min(horizontalScale, verticalScale)));
        }
        if ((rd = annotDict.getAsArray(PdfName.RD)) != null && rd.size() == 4) {
            rd.set(0, new PdfNumber(rd.getAsNumber(0).doubleValue() * horizontalScale));
            rd.set(1, new PdfNumber(rd.getAsNumber(1).doubleValue() * verticalScale));
            rd.set(2, new PdfNumber(rd.getAsNumber(2).doubleValue() * horizontalScale));
            rd.set(3, new PdfNumber(rd.getAsNumber(3).doubleValue() * verticalScale));
        }
        double lengthScale = Math.min(horizontalScale, verticalScale);
        if (annotDict.getAsNumber(PdfName.LL) != null) {
            annotDict.put(PdfName.LL, new PdfNumber(annotDict.getAsNumber(PdfName.LL).doubleValue() * lengthScale));
        }
        if (annotDict.getAsNumber(PdfName.LLE) != null) {
            annotDict.put(PdfName.LLE, new PdfNumber(annotDict.getAsNumber(PdfName.LLE).doubleValue() * lengthScale));
        }
        if (annotDict.getAsNumber(PdfName.LLO) != null) {
            annotDict.put(PdfName.LLO, new PdfNumber(annotDict.getAsNumber(PdfName.LLO).doubleValue() * lengthScale));
        }
        String da = null;
        if (annotDict.getAsString(PdfName.DA) != null) {
            da = annotDict.getAsString(PdfName.DA).toUnicodeString();
        } else if (PdfName.Widget.equals(annotDict.getAsName(PdfName.Subtype)) && (da = PageResizer.getDaFromParent(annotDict)) == null && (acroFormDictionary = ((PdfDictionary)annot.getPage().getDocument().getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm)) != null && acroFormDictionary.getAsString(PdfName.DA) != null) {
            da = acroFormDictionary.getAsString(PdfName.DA).toUnicodeString();
        }
        if (da != null) {
            annotDict.put(PdfName.DA, new PdfString(PageResizer.scaleDaString(da, lengthScale)));
        }
        if (annotDict.getAsString(PdfName.RC) != null) {
            String rc = annotDict.getAsString(PdfName.RC).toUnicodeString();
            annotDict.put(PdfName.RC, new PdfString(PageResizer.scaleRcString(rc, lengthScale)));
        }
        if (annotDict.getAsString(PdfName.DS) != null) {
            String ds = annotDict.getAsString(PdfName.DS).toUnicodeString();
            annotDict.put(PdfName.DS, new PdfString(PageResizer.scaleRcString(ds, lengthScale)));
        }
    }

    private static String formatNumber(double v) {
        if (Double.isNaN(v)) {
            return Double.toString(v);
        }
        if (Math.abs(v) < (double)1.0E-6f) {
            return "0";
        }
        long scaled = Math.round(v * 10000.0);
        if (scaled == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (scaled < 0L) {
            sb.append('-');
            scaled = -scaled;
        }
        long wholePart = scaled / 10000L;
        long fractionalPart = scaled % 10000L;
        sb.append(wholePart);
        if (fractionalPart > 0L) {
            sb.append('.');
            String fractionalStr = String.valueOf(10000L + fractionalPart).substring(1);
            sb.append(fractionalStr);
            while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '0') {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    private static void resizeAppearanceStream(PdfStream appearanceStream, AffineTransform scalingMatrix) {
        AffineTransform newMatrix;
        AffineTransform scaleOnlyMatrix = new AffineTransform();
        scaleOnlyMatrix.scale(scalingMatrix.getScaleX(), scalingMatrix.getScaleY());
        PdfArray existingMatrix = appearanceStream.getAsArray(PdfName.Matrix);
        if (existingMatrix == null) {
            newMatrix = scaleOnlyMatrix;
        } else {
            newMatrix = new AffineTransform(existingMatrix.toDoubleArray());
            newMatrix.preConcatenate(scaleOnlyMatrix);
        }
        double[] newMatrixArray = new double[6];
        newMatrix.getMatrix(newMatrixArray);
        appearanceStream.put(PdfName.Matrix, new PdfArray(newMatrixArray));
    }

    private static String getDaFromParent(PdfDictionary dict) {
        PdfDictionary parentDict = dict.getAsDictionary(PdfName.Parent);
        if (parentDict == null) {
            return null;
        }
        PdfString da = parentDict.getAsString(PdfName.DA);
        if (da != null) {
            return da.toUnicodeString();
        }
        return PageResizer.getDaFromParent(parentDict);
    }

    private void updateBoxes(PdfPage page, Rectangle originalPageSize) {
        Rectangle newCP = PageResizer.scalePageBox(originalPageSize, this.size, page.getCropBox());
        Rectangle newTB = PageResizer.scalePageBox(originalPageSize, this.size, page.getTrimBox());
        Rectangle newBB = PageResizer.scalePageBox(originalPageSize, this.size, page.getBleedBox());
        Rectangle newAB = PageResizer.scalePageBox(originalPageSize, this.size, page.getArtBox());
        page.setMediaBox(this.size);
        if (((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.CropBox) != null) {
            page.setCropBox(newCP);
        }
        if (((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.TrimBox) != null) {
            page.setTrimBox(newTB);
        }
        if (((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.BleedBox) != null) {
            page.setBleedBox(newBB);
        }
        if (((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.ArtBox) != null) {
            page.setArtBox(newAB);
        }
    }

    private AffineTransform calculateAffineTransform(double horizontalScale, double verticalScale, double horizontalFreeSpace, double verticalFreeSpace) {
        AffineTransform scalingMatrix = new AffineTransform();
        scalingMatrix.scale(horizontalScale, verticalScale);
        AffineTransform transformMatrix = new AffineTransform();
        switch (this.horizontalAnchorPoint) {
            case CENTER: {
                transformMatrix.translate(horizontalFreeSpace / 2.0, 0.0);
                break;
            }
            case RIGHT: {
                transformMatrix.translate(horizontalFreeSpace, 0.0);
                break;
            }
        }
        switch (this.verticalAnchorPoint) {
            case CENTER: {
                transformMatrix.translate(0.0, verticalFreeSpace / 2.0);
                break;
            }
            case TOP: {
                transformMatrix.translate(0.0, verticalFreeSpace);
                break;
            }
        }
        transformMatrix.concatenate(scalingMatrix);
        scalingMatrix = transformMatrix;
        return scalingMatrix;
    }

    private static class RcPropertyParser {
        private final String source;
        private final int length;
        private int cursor;
        private RcPropertyParserResult result;

        RcPropertyParser(String source) {
            this.source = source;
            this.length = source.length();
            this.cursor = 0;
        }

        public boolean findNext() {
            while (this.cursor < this.length) {
                int newCursor;
                int matchedPropEnd = this.findAndMatchProperty(this.cursor);
                if (matchedPropEnd != -1 && (newCursor = this.parseAndSetScalableValue(matchedPropEnd)) != -1) {
                    this.cursor = newCursor;
                    return true;
                }
                ++this.cursor;
            }
            return false;
        }

        public RcPropertyParserResult getResult() {
            return this.result;
        }

        private int findAndMatchProperty(int i) {
            boolean validLeadingBoundary;
            char c = this.source.charAt(i);
            boolean bl = validLeadingBoundary = i == 0 || !RcPropertyParser.isPropertyNameChar(this.source.charAt(i - 1));
            if ((c >= 'a' && c <= 'z' || c == '-') && validLeadingBoundary) {
                for (String p : SCALABLE_RC_PROPERTIES) {
                    int len = p.length();
                    if (i + len > this.length || !RcPropertyParser.compareRegions(this.source, i, p, 0, len)) continue;
                    return i + len;
                }
            }
            return -1;
        }

        private static boolean compareRegions(String first, int firstOffset, String second, int secondOffset, int len) {
            if (firstOffset < 0 || secondOffset < 0 || len < 0 || firstOffset + len > first.length() || secondOffset + len > second.length()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char c2;
                char c1 = first.charAt(firstOffset + i);
                if (c1 == (c2 = second.charAt(secondOffset + i))) continue;
                return false;
            }
            return true;
        }

        private int parseAndSetScalableValue(int matchedPropEnd) {
            double value;
            int k = RcPropertyParser.skipWhitespace(this.source, matchedPropEnd);
            if (k >= this.length || this.source.charAt(k) != ':') {
                return -1;
            }
            ++k;
            int numStart = k = RcPropertyParser.skipWhitespace(this.source, k);
            if (numStart >= this.length) {
                return -1;
            }
            int numEnd = RcPropertyParser.parseCssNumber(this.source, numStart);
            if (numEnd <= numStart) {
                return -1;
            }
            int unitStart = RcPropertyParser.skipWhitespace(this.source, numEnd);
            int unitEnd = RcPropertyParser.parseCssUnit(this.source, unitStart);
            if (unitEnd <= unitStart) {
                return -1;
            }
            String unit = this.source.substring(unitStart, unitEnd).toLowerCase();
            if (!SCALABLE_UNITS.contains(unit)) {
                return -1;
            }
            String numStr = this.source.substring(numStart, numEnd);
            try {
                value = Double.parseDouble(numStr);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
            this.result = new RcPropertyParserResult(numStart, numEnd, value);
            return unitEnd;
        }

        private static boolean isPropertyNameChar(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || Character.isDigit(c);
        }

        private static int skipWhitespace(String str, int index) {
            while (index < str.length() && Character.isWhitespace(str.charAt(index))) {
                ++index;
            }
            return index;
        }

        private static int parseCssNumber(String str, int startIndex) {
            int d;
            int n = str.length();
            if (startIndex >= n) {
                return startIndex;
            }
            int i = startIndex;
            if (str.charAt(i) == '+' || str.charAt(i) == '-') {
                ++i;
            }
            int digitsBefore = 0;
            int digitsAfter = 0;
            for (d = i; d < n && Character.isDigit(str.charAt(d)); ++d) {
            }
            digitsBefore = d - i;
            i = d;
            if (i < n && str.charAt(i) == '.') {
                int a;
                for (a = ++i; a < n && Character.isDigit(str.charAt(a)); ++a) {
                }
                digitsAfter = a - i;
                i = a;
            }
            if (digitsBefore == 0 && digitsAfter == 0) {
                return startIndex;
            }
            i = RcPropertyParser.parseExponent(str, i, n);
            return i;
        }

        private static int parseExponent(String str, int i, int n) {
            if (i < n && (str.charAt(i) == 'e' || str.charAt(i) == 'E')) {
                int expPos = i + 1;
                if (expPos < n && (str.charAt(expPos) == '+' || str.charAt(expPos) == '-')) {
                    ++expPos;
                }
                int expDigitsStart = expPos;
                while (expPos < n && Character.isDigit(str.charAt(expPos))) {
                    ++expPos;
                }
                if (expPos > expDigitsStart) {
                    return expPos;
                }
            }
            return i;
        }

        private static int parseCssUnit(String str, int startIndex) {
            char ch;
            int i;
            for (i = startIndex; i < str.length() && ((ch = str.charAt(i)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z'); ++i) {
            }
            return i;
        }
    }

    private static class RcPropertyParserResult {
        private int valueStart;
        private int valueEnd;
        private double parsedValue;

        public RcPropertyParserResult(int valueStart, int valueEnd, double parsedValue) {
            this.valueStart = valueStart;
            this.valueEnd = valueEnd;
            this.parsedValue = parsedValue;
        }

        public int getValueStart() {
            return this.valueStart;
        }

        public int getValueEnd() {
            return this.valueEnd;
        }

        public double getParsedValue() {
            return this.parsedValue;
        }
    }

    public static enum HorizontalAnchorPoint {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VerticalAnchorPoint {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum ResizeType {
        MAINTAIN_ASPECT_RATIO,
        DEFAULT;

    }
}

