/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import oracle.jdbc.OraclePooledConnectionBuilder;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.datasource.OraclePooledConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc.pool")
@Supports(value={Feature.CONN_POOL})
public abstract class OraclePooledConnectionBuilderImpl
implements OraclePooledConnectionBuilder {
    protected String user = null;
    protected String password = null;
    protected String serviceName = null;
    protected String instanceName = null;
    protected OracleShardingKey shardingKey = null;
    protected OracleShardingKey superShardingKey = null;
    protected GSSCredential gssCredential = null;

    @Override
    public abstract OraclePooledConnection build() throws SQLException;

    @Override
    public OraclePooledConnectionBuilderImpl password(@Blind String string) {
        this.password = string;
        return this;
    }

    @Override
    public OraclePooledConnectionBuilderImpl user(String string) {
        this.user = string;
        return this;
    }

    public OraclePooledConnectionBuilderImpl serviceName(String string) {
        this.serviceName = string;
        return this;
    }

    public OraclePooledConnectionBuilderImpl instanceName(String string) {
        this.instanceName = string;
        return this;
    }

    @Override
    public OraclePooledConnectionBuilderImpl shardingKey(OracleShardingKey oracleShardingKey) {
        this.shardingKey = oracleShardingKey;
        return this;
    }

    @Override
    public OraclePooledConnectionBuilderImpl superShardingKey(OracleShardingKey oracleShardingKey) {
        this.superShardingKey = oracleShardingKey;
        if (oracleShardingKey != null) {
            ((OracleShardingKeyImpl)oracleShardingKey).markSuperShardingKey(true);
        }
        return this;
    }

    @Override
    public OraclePooledConnectionBuilderImpl gssCredential(GSSCredential gSSCredential) {
        if (gSSCredential == null) {
            throw new NullPointerException();
        }
        this.gssCredential = gSSCredential;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    @Blind
    public String getPassword() {
        return this.password;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }

    @Blind
    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }
}

