/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.NonTxnReplayableArray;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableBfile;
import oracle.jdbc.replay.driver.NonTxnReplayableBlob;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.NonTxnReplayableNClob;
import oracle.jdbc.replay.driver.NonTxnReplayableOpaque;
import oracle.jdbc.replay.driver.NonTxnReplayableOthers;
import oracle.jdbc.replay.driver.NonTxnReplayableRef;
import oracle.jdbc.replay.driver.NonTxnReplayableResultSet;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.NonTxnReplayableStruct;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.TxnReplayableArray;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBfile;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.jdbc.replay.driver.TxnReplayableOpaque;
import oracle.jdbc.replay.driver.TxnReplayableOthers;
import oracle.jdbc.replay.driver.TxnReplayableRef;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableSqlxml;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class OracleDataSourceImpl
implements OracleDataSource,
Serializable,
Referenceable,
ObjectFactory {
    private static final long serialVersionUID = 5634196469087099680L;
    private static ProxyFactory PROXY_FACTORY = null;
    private static ProxyFactory NON_TXN_PROXY_FACTORY = null;
    private static final Object proxyFactoryLock;
    protected oracle.jdbc.pool.OracleDataSource ods = null;
    protected oracle.jdbc.pool.OracleDataSource odsReconnectOnly = null;
    protected String user = null;
    protected OpaqueString password = null;
    private String url = null;
    private String serverName = null;
    private int portNumber = 0;
    private String databaseName = null;
    private String dataSourceName = null;
    private String description = null;
    private String networkProtocol = null;
    private String roleName = null;
    protected Properties connectionProperties = null;
    protected Properties reconnectionProperties = null;
    private int maxStatements = 0;
    private boolean implicitCachingEnabled = false;
    private boolean explicitCachingEnabled = false;
    private ConnectionInitializationCallback connectionInitializationCallback = null;
    protected AtomicBoolean isFirstConnection = new AtomicBoolean(true);
    protected static final String RECONNECT_DELAY_PROPERTY = "AUTH_FAILOVER_DELAY";
    protected static final String RECONNECT_RETRIES_PROPERTY = "AUTH_FAILOVER_RETRIES";
    protected int reconnectDelay = 10;
    protected int reconnectRetries = 30;
    protected static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    protected static final int FAILOVER_TYPE_TRANSACTION = 8;
    protected static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    protected static final int FAILOVER_TYPE_AUTO = 32;
    protected boolean isTransactionReplayEnabled = false;
    protected boolean isAutoACEnabled = false;
    protected static final String SESSION_STATE_PROPERTY = "AUTH_SESSION_STATE_CONSISTENCY";
    protected boolean isReplayInDynamicMode = true;
    protected static final String FAILOVER_RESTORE_PROPERTY = "AUTH_FAILOVER_RESTORE";
    protected static final int FAILOVER_RESTORE_NONE = 0;
    protected static final int FAILOVER_RESTORE_LEVEL1 = 1;
    protected static final int FAILOVER_RESTORE_AUTO = 2;
    protected ReplayableConnection.StateRestorationType stateRestorationType = ReplayableConnection.StateRestorationType.NONE;
    protected boolean isStateRestorationAuto = false;
    protected static final String INITIATION_TIMEOUT_PROPERTY = "AUTH_FAILOVER_REPLAYTIMEOUT";
    protected int replayInitiationTimeout = 300;
    protected static final String CHECKSUM_PROPERTY = "oracle.jdbc.calculateChecksum";
    protected final String clientChecksum12x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS.toString();
    protected final String clientChecksum11203x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL.toString();
    protected static final String IGNORE_AC_CONTEXT_PROPERTY = "oracle.jdbc.ignoreReplayContextFromAuthentication";
    private static final String AC_11203_COMPATIBLE_SYSTEM_PROPERTY = "oracle.jdbc.AC11203Compatible";
    private static final String IMPLICIT_BEGIN_REQUEST_SYSTEM_PROPERTY = "oracle.jdbc.beginRequestAtConnectionCreation";
    protected static final String REQUEST_SIZE_LIMIT_PROPERTY = "oracle.jdbc.replay.protectedRequestSizeLimit";
    private LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> acStatistics = new LinkedList();
    protected AtomicBoolean doneDumpOnMemoryPressure = new AtomicBoolean(false);

    public OracleDataSourceImpl() {
        try {
            this.ods = new oracle.jdbc.pool.OracleDataSource();
            this.odsReconnectOnly = new oracle.jdbc.pool.OracleDataSource();
        }
        catch (SQLException sQLException) {
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        String string = null;
        if (this.password != null) {
            string = this.password.get();
        }
        return this.getConnection(this.user, string);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnectionInternal(this.createConnectionBuilder().user(string).password(string2), true);
    }

    protected Connection getConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        return this.getConnectionInternal(oracleConnectionBuilderImpl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnectionNoProxy(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        int n2 = 1;
        Connection connection = null;
        Exception exception = null;
        do {
            try {
                exception = null;
                oracleConnectionBuilderImpl.instanceName(null);
                connection = this.getConnectionInternal(oracleConnectionBuilderImpl, false);
                OracleConnection oracleConnection = (OracleConnection)connection;
                if (oracleConnection.isDRCPEnabled()) {
                    oracleConnection.attachServerConnection();
                }
            }
            catch (Exception exception2) {
                connection = null;
                exception = exception2;
            }
            finally {
                if (connection != null && exception == null) {
                    return connection;
                }
                ++n2;
            }
            try {
                if (this.reconnectDelay <= 0) continue;
                Thread.sleep(this.reconnectDelay * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        } while (n2 <= this.reconnectRetries);
        return null;
    }

    private Connection getConnectionInternal(OracleConnectionBuilderImpl oracleConnectionBuilderImpl, boolean bl) throws SQLException {
        Connection connection = null;
        this.setupACSpecificProperties();
        if (bl) {
            connection = this.ods.getConnection(oracleConnectionBuilderImpl);
            connection = this.enableACAndProxifyIfNecessary(connection, oracleConnectionBuilderImpl);
        } else {
            connection = this.odsReconnectOnly.getConnection(oracleConnectionBuilderImpl);
        }
        this.isFirstConnection.set(false);
        return connection;
    }

    protected void setupACSpecificProperties() throws SQLException {
        if (this.isFirstConnection.get()) {
            this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum12x);
            this.reconnectionProperties.setProperty(IGNORE_AC_CONTEXT_PROPERTY, "true");
            this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection enableACAndProxifyIfNecessary(Connection connection, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        Object object;
        String string;
        String string2;
        String string3;
        int n2;
        String string4;
        int n3;
        boolean bl = true;
        short s2 = 0;
        OracleConnection oracleConnection = (OracleConnection)connection;
        Properties properties = oracleConnection.getServerSessionInfo();
        String string5 = properties.getProperty(RECONNECT_DELAY_PROPERTY);
        if (string5 != null && !"".equals(string5) && (n3 = Integer.parseInt(string5)) > 0) {
            this.reconnectDelay = n3;
        }
        if ((string4 = properties.getProperty(RECONNECT_RETRIES_PROPERTY)) != null && !"".equals(string4) && (n2 = Integer.parseInt(string4)) > 0) {
            this.reconnectRetries = n2;
        }
        if ((string3 = properties.getProperty(FAILOVER_TYPE_PROPERTY)) != null && !"".equals(string3)) {
            int n4;
            try {
                n4 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = 0;
            }
            this.isAutoACEnabled = (n4 & 0x20) == 32;
            this.isTransactionReplayEnabled = this.isAutoACEnabled || (n4 & 8) == 8;
            boolean bl2 = this.isReplayInDynamicMode = (n4 & 0x10) == 0;
        }
        if ((string2 = properties.getProperty(FAILOVER_RESTORE_PROPERTY)) != null && !"".equals(string2) && "thin".equals(oracleConnection.getProtocolType())) {
            int n5 = Integer.parseInt(string2);
            this.stateRestorationType = ReplayableConnection.StateRestorationType.values()[n5];
            if (this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.NONE) > 0) {
                boolean bl3 = this.isStateRestorationAuto = this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.AUTO) >= 0;
                if (this.isAutoACEnabled && !this.isStateRestorationAuto) {
                    bl = false;
                }
            }
        }
        if ((string = properties.getProperty(INITIATION_TIMEOUT_PROPERTY)) != null && !"".equals(string)) {
            this.replayInitiationTimeout = Integer.parseInt(string);
        }
        if ((s2 = oracleConnection.getVersionNumber()) < 11203) {
            bl = false;
        } else if (s2 >= 12100 && !this.isTransactionReplayEnabled) {
            bl = false;
        } else if (s2 >= 11203 && s2 < 12100) {
            boolean bl4 = "true".equalsIgnoreCase(OracleDataSourceImpl.getSystemProperty(AC_11203_COMPATIBLE_SYSTEM_PROPERTY, "false"));
            if (bl4) {
                connection.close();
                this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum11203x);
                connection = this.ods.getConnection(oracleConnectionBuilderImpl);
                object = proxyFactoryLock;
                synchronized (object) {
                    PROXY_FACTORY = NON_TXN_PROXY_FACTORY;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            Connection connection2 = PROXY_FACTORY.proxyFor(connection);
            object = (ReplayableConnection)((Object)connection2);
            object.initialize(this, oracleConnectionBuilderImpl);
            if (s2 >= 12100) {
                object.setReplayInitiationTimeout(this.replayInitiationTimeout);
                object.setAutoAC(this.isAutoACEnabled);
                object.setSessionStateConsistency(!this.isReplayInDynamicMode);
                object.setSessionStateRestoration(this.stateRestorationType);
            }
            ((OracleConnection)connection).getReplayContext();
            boolean bl5 = "true".equalsIgnoreCase(OracleDataSourceImpl.getSystemProperty(IMPLICIT_BEGIN_REQUEST_SYSTEM_PROPERTY, "true"));
            if (this.isAutoACEnabled && bl5) {
                object.beginRequest();
            }
            return connection2;
        }
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int n2) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String string) throws SQLException {
        this.user = string;
        this.ods.setUser(string);
        this.odsReconnectOnly.setUser(string);
    }

    @Override
    public void setPassword(String string) throws SQLException {
        this.password = OpaqueString.newOpaqueString(string);
        this.ods.setPassword(string);
        this.odsReconnectOnly.setPassword(string);
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String string) throws SQLException {
        this.url = string;
        this.ods.setURL(string);
        this.odsReconnectOnly.setURL(string);
    }

    @Override
    public void setServerName(String string) throws SQLException {
        this.serverName = string;
        this.ods.setServerName(string);
        this.odsReconnectOnly.setServerName(string);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setPortNumber(int n2) throws SQLException {
        this.portNumber = n2;
        this.ods.setPortNumber(n2);
        this.odsReconnectOnly.setPortNumber(n2);
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setDatabaseName(String string) throws SQLException {
        this.databaseName = string;
        this.ods.setDatabaseName(string);
        this.odsReconnectOnly.setDatabaseName(string);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
        this.ods.setDataSourceName(string);
        this.odsReconnectOnly.setDataSourceName(string);
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setDescription(String string) throws SQLException {
        this.description = string;
        this.ods.setDescription(string);
        this.odsReconnectOnly.setDescription(string);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setNetworkProtocol(String string) throws SQLException {
        this.networkProtocol = string;
        this.ods.setNetworkProtocol(string);
        this.odsReconnectOnly.setNetworkProtocol(string);
    }

    @Override
    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    @Override
    public void setRoleName(String string) throws SQLException {
        this.roleName = string;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        if (connectionInitializationCallback == null) {
            throw DatabaseError.createSqlException(68);
        }
        this.connectionInitializationCallback = connectionInitializationCallback;
    }

    @Override
    public void unregisterConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        if (connectionInitializationCallback == null || this.connectionInitializationCallback != connectionInitializationCallback) {
            throw DatabaseError.createSqlException(68);
        }
        this.connectionInitializationCallback = null;
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        return this.connectionInitializationCallback;
    }

    @Override
    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public String getConnectionProperty(String string) {
        return this.connectionProperties.getProperty(string);
    }

    @Override
    public void setConnectionProperty(String string, String string2) throws SQLException {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException();
        }
        if (this.connectionProperties == null) {
            this.connectionProperties = new Properties();
        }
        if (this.reconnectionProperties == null) {
            this.reconnectionProperties = new Properties();
        }
        this.connectionProperties.setProperty(string, string2);
        this.reconnectionProperties.setProperty(string, string2);
        this.ods.setConnectionProperties(this.connectionProperties);
        this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
    }

    @Override
    public void setConnectionProperties(Properties properties) throws SQLException {
        if (properties == null) {
            this.connectionProperties = null;
            this.reconnectionProperties = null;
        } else {
            this.connectionProperties = (Properties)properties.clone();
            this.reconnectionProperties = (Properties)properties.clone();
        }
        this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum12x);
        this.reconnectionProperties.setProperty(IGNORE_AC_CONTEXT_PROPERTY, "true");
        this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
    }

    @Override
    public void setMaxStatements(int n2) throws SQLException {
        this.maxStatements = n2;
        this.ods.setMaxStatements(n2);
        this.odsReconnectOnly.setMaxStatements(n2);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        this.implicitCachingEnabled = bl;
        this.ods.setImplicitCachingEnabled(bl);
        this.odsReconnectOnly.setImplicitCachingEnabled(bl);
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.implicitCachingEnabled;
    }

    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        this.explicitCachingEnabled = bl;
        this.ods.setExplicitCachingEnabled(bl);
        this.odsReconnectOnly.setExplicitCachingEnabled(bl);
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.explicitCachingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplayStatistics getReplayStatistics() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        int[] nArray = new int[31];
        Cloneable cloneable = this.acStatistics;
        synchronized (cloneable) {
            for (oracle.jdbc.replay.internal.ReplayStatistics replayStatistics : this.acStatistics) {
                l2 += replayStatistics.getTotalRequests();
                l3 += replayStatistics.getTotalCompletedRequests();
                l4 += replayStatistics.getTotalCalls();
                l5 += replayStatistics.getTotalProtectedCalls();
                l6 += replayStatistics.getTotalCallsAffectedByOutages();
                l7 += replayStatistics.getTotalCallsTriggeringReplay();
                l8 += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
                l9 += replayStatistics.getSuccessfulReplayCount();
                l10 += replayStatistics.getFailedReplayCount();
                l11 += replayStatistics.getReplayDisablingCount();
                l12 += replayStatistics.getTotalReplayAttempts();
                int[] nArray2 = replayStatistics.getRequestSizeHistogram();
                if (nArray2 == null || nArray2.length <= 0) continue;
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    int n2 = i2;
                    nArray[n2] = nArray[n2] + nArray2[i2];
                }
            }
        }
        cloneable = new ReplayStatisticsImpl(l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, 0);
        ((ReplayStatisticsImpl)cloneable).setRequestSizeHistogram(nArray);
        return cloneable;
    }

    @Override
    public void clearDoneDumpOnMemoryPressure() {
        this.doneDumpOnMemoryPressure.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DisableTrace
    public String getReplayStatisticsString() {
        if (this.doneDumpOnMemoryPressure.compareAndSet(false, true)) {
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        int[] nArray = new int[31];
        StringBuilder stringBuilder = new StringBuilder().append("All current in-flight AC request sizes:").append("\n===============================================");
        Cloneable cloneable = this.acStatistics;
        synchronized (cloneable) {
            for (oracle.jdbc.replay.internal.ReplayStatistics replayStatistics : this.acStatistics) {
                l2 += replayStatistics.getTotalRequests();
                l3 += replayStatistics.getTotalCompletedRequests();
                l4 += replayStatistics.getTotalCalls();
                l5 += replayStatistics.getTotalProtectedCalls();
                l6 += replayStatistics.getTotalCallsAffectedByOutages();
                l7 += replayStatistics.getTotalCallsTriggeringReplay();
                l8 += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
                l9 += replayStatistics.getSuccessfulReplayCount();
                l10 += replayStatistics.getFailedReplayCount();
                l11 += replayStatistics.getReplayDisablingCount();
                l12 += replayStatistics.getTotalReplayAttempts();
                stringBuilder.append("\n  ").append(replayStatistics.getCurrentRequestSize());
                int[] nArray2 = replayStatistics.getRequestSizeHistogram();
                if (nArray2 == null || nArray2.length <= 0) continue;
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    int n2 = i2;
                    nArray[n2] = nArray[n2] + nArray2[i2];
                }
            }
        }
        cloneable = new ReplayStatisticsImpl(l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, 0);
        ((ReplayStatisticsImpl)cloneable).setRequestSizeHistogram(nArray);
        stringBuilder.append("\n===============================================").append("\n\n").append(((ReplayStatisticsImpl)cloneable).toString()).append("\n\n").append(((ReplayStatisticsImpl)cloneable).getRequestSizeHistogramString()).append("\n\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearReplayStatistics() {
        LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> linkedList = this.acStatistics;
        synchronized (linkedList) {
            for (oracle.jdbc.replay.internal.ReplayStatistics replayStatistics : this.acStatistics) {
                replayStatistics.clear();
            }
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.replay.OracleDataSourceImpl", null);
        if (this.user != null) {
            reference.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null && !this.password.isNull()) {
            reference.add(new StringRefAddr("password", this.password.get()));
        }
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName != null) {
            reference.add(new StringRefAddr("dataSourceName", this.dataSourceName.toString()));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description.toString()));
        }
        if (this.networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.networkProtocol.toString()));
        }
        if (this.roleName != null) {
            reference.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.connectionProperties.size() > 0) {
            reference.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
        }
        if (this.maxStatements != 0) {
            reference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabled) {
            reference.add(new StringRefAddr("implicitCachingEnabled", "true"));
        }
        if (this.explicitCachingEnabled) {
            reference.add(new StringRefAddr("explicitCachingEnabled", "true"));
        }
        return reference;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        String string;
        Reference reference = (Reference)object;
        String string2 = reference.getClassName();
        OracleDataSourceImpl oracleDataSourceImpl = null;
        if (string2.equals("oracle.jdbc.replay.OracleDataSource") || string2.equals("oracle.jdbc.replay.OracleDataSourceImpl")) {
            oracleDataSourceImpl = new OracleDataSourceImpl();
        }
        if (oracleDataSourceImpl == null) {
            return null;
        }
        StringRefAddr stringRefAddr = (StringRefAddr)reference.get("user");
        if (stringRefAddr != null) {
            oracleDataSourceImpl.setUser((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("password")) != null) {
            oracleDataSourceImpl.setPassword((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("url")) != null) {
            oracleDataSourceImpl.setURL((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("serverName")) != null) {
            oracleDataSourceImpl.setServerName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("portNumber")) != null) {
            oracleDataSourceImpl.setPortNumber(Integer.parseInt((String)stringRefAddr.getContent()));
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("databaseName")) != null) {
            oracleDataSourceImpl.setDatabaseName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("dataSourceName")) != null) {
            oracleDataSourceImpl.setDataSourceName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("description")) != null) {
            oracleDataSourceImpl.setDescription((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("networkProtocol")) != null) {
            oracleDataSourceImpl.setNetworkProtocol((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("roleName")) != null) {
            oracleDataSourceImpl.setRoleName((String)stringRefAddr.getContent());
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("connectionProperties")) != null) {
            String[] stringArray;
            string = (String)stringRefAddr.getContent();
            Properties properties = new Properties();
            for (String string3 : stringArray = string.substring(1, string.length() - 1).split(", ")) {
                String[] stringArray2 = string3.split("=");
                properties.setProperty(stringArray2[0], stringArray2[1]);
            }
            oracleDataSourceImpl.setConnectionProperties(properties);
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("maxStatements")) != null) {
            oracleDataSourceImpl.setMaxStatements(Integer.parseInt((String)stringRefAddr.getContent()));
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("implicitCachingEnabled")) != null) {
            string = (String)stringRefAddr.getContent();
            if (string.equalsIgnoreCase("true")) {
                oracleDataSourceImpl.setImplicitCachingEnabled(true);
            } else {
                oracleDataSourceImpl.setImplicitCachingEnabled(false);
            }
        }
        if ((stringRefAddr = (StringRefAddr)reference.get("explicitCachingEnabled")) != null) {
            string = (String)stringRefAddr.getContent();
            if (string.equalsIgnoreCase("true")) {
                oracleDataSourceImpl.setExplicitCachingEnabled(true);
            } else {
                oracleDataSourceImpl.setExplicitCachingEnabled(false);
            }
        }
        return oracleDataSourceImpl;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("oracle");
    }

    private static String getSystemProperty(String string, String string2) {
        if (string != null) {
            final String string3 = string;
            final String string4 = string2;
            final String[] stringArray = new String[]{string2};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    stringArray[0] = System.getProperty(string3, string4);
                    return null;
                }
            });
            return stringArray[0];
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReplayStatistics(oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> linkedList = this.acStatistics;
        synchronized (linkedList) {
            this.acStatistics.add(replayStatistics);
        }
    }

    @Override
    public int getRequestSizeLimit() throws SQLException {
        int n2 = Integer.MAX_VALUE;
        String string = OracleDataSourceImpl.getSystemProperty(REQUEST_SIZE_LIMIT_PROPERTY, null);
        if (string == null) {
            string = this.getConnectionProperty(REQUEST_SIZE_LIMIT_PROPERTY);
        }
        if (string == null) {
            string = Integer.toString(Integer.MAX_VALUE);
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    @Override
    public ProxyFactory getProxyFactory() throws SQLException {
        return PROXY_FACTORY;
    }

    @Override
    public OracleConnectionBuilderImpl createConnectionBuilder() {
        return new OracleConnectionBuilderImpl(){

            @Override
            public OracleConnection build() throws SQLException {
                return (OracleConnection)OracleDataSourceImpl.this.getConnectionInternal(this, true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = proxyFactoryLock = new Object();
        synchronized (object) {
            if (PROXY_FACTORY == null) {
                NON_TXN_PROXY_FACTORY = ProxyFactory.createProxyFactory(NonTxnReplayableBase.class, NonTxnReplayableConnection.class, NonTxnReplayableStatement.class, NonTxnReplayableResultSet.class, NonTxnReplayableArray.class, NonTxnReplayableBfile.class, NonTxnReplayableBlob.class, NonTxnReplayableClob.class, NonTxnReplayableNClob.class, NonTxnReplayableOpaque.class, NonTxnReplayableRef.class, NonTxnReplayableStruct.class, NonTxnReplayableOthers.class);
                PROXY_FACTORY = ProxyFactory.createProxyFactory(TxnReplayableBase.class, TxnReplayableConnection.class, TxnReplayableStatement.class, TxnReplayableResultSet.class, TxnReplayableArray.class, TxnReplayableBfile.class, TxnReplayableBlob.class, TxnReplayableClob.class, TxnReplayableNClob.class, TxnReplayableOpaque.class, TxnReplayableRef.class, TxnReplayableSqlxml.class, TxnReplayableStruct.class, TxnReplayableOthers.class);
            }
        }
    }
}

