/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.jdbc.OracleClob;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={Clob.class, OracleClob.class, oracle.jdbc.internal.OracleClob.class})
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableClob
extends NonTxnReplayableBase
implements Replayable {
    private static final Method GETASCIISTREAM_METHOD = NonTxnReplayableClob.getGetAsciiStreamMethod();
    private static final Method GETASCIISTREAM_LONG_METHOD = NonTxnReplayableClob.getGetAsciiStreamLongMethod();
    private static final Method GETCHARSTREAM_METHOD = NonTxnReplayableClob.getGetCharacterStreamMethod();
    private static final Method GETCHARSTREAM_LONG_METHOD = NonTxnReplayableClob.getGetCharacterStreamLongMethod();
    private static final Method GETCHARSTREAM_LONG_LONG_METHOD = NonTxnReplayableClob.getGetCharacterStreamLongLongMethod();
    private static final Method SETASCIISTREAM_LONG_METHOD = NonTxnReplayableClob.getSetAsciiStreamLongMethod();
    private static final Method SETCHARSTREAM_LONG_METHOD = NonTxnReplayableClob.getSetCharacterStreamLongMethod();
    protected boolean isFreed = false;

    private static final Method getGetAsciiStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetAsciiStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetAsciiStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("setAsciiStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetCharacterStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("setCharacterStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="free", args={})})
    protected void preForFree(Method method, Object object, Object ... objectArray) {
        this.isFreed = true;
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="setString", args={long.class, String.class}), @Signature(name="setString", args={long.class, String.class, int.class, int.class}), @Signature(name="truncate", args={long.class})})
    protected void preForClobWrites(Method method, Object object, Object ... objectArray) {
        block1: {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        }
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)object;
            nonTxnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getAsciiStream() throws SQLException {
        if (GETASCIISTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method method = GETASCIISTREAM_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getAsciiStream() : oracleClob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)((Object)this), oracleClob.getBufferSize(), 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        if (GETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method method = GETASCIISTREAM_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getAsciiStream(l2) : oracleClob.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)((Object)this), oracleClob.getBufferSize(), l2);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (GETCHARSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Reader reader = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getCharacterStream() : oracleClob.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), oracleClob.getBufferSize(), 0L);
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        if (GETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Reader reader = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getCharacterStream(l2) : oracleClob.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), oracleClob.getBufferSize(), l2);
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (GETCHARSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_LONG_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            Reader reader;
            oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleClob.canReadBasicLobDataInLocator()) {
                reader = oracleClob.getCharacterStream(l2, l3);
            } else {
                long l4 = oracleClob.length();
                if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                reader = oracleClob.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), oracleClob.getBufferSize(), l2, l3);
            }
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (SETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set ascii stream");
        }
        Method method = SETASCIISTREAM_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            OutputStream outputStream = oracleClob.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleClob)((Object)this), oracleClob.getBufferSize(), l2, true);
            return (OutputStream)this.postForAll(method, outputStream);
        }
        catch (SQLException sQLException) {
            return (OutputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        if (SETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set character stream");
        }
        Method method = SETCHARSTREAM_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Writer writer = oracleClob.getDBAccess().newWriter((oracle.jdbc.internal.OracleClob)((Object)this), oracleClob.getBufferSize(), l2, true);
            return (Writer)this.postForAll(method, writer);
        }
        catch (SQLException sQLException) {
            return (Writer)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(1L);
    }

    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        return this.setAsciiStream(l2);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(1L);
    }

    public Writer getCharacterOutputStream(long l2) throws SQLException {
        return this.setCharacterStream(l2);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleClob oracleClob = (oracle.jdbc.internal.OracleClob)this.getDelegate();
        return oracleClob.getInternalConnection();
    }
}

