/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import java.util.Vector;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;

public class AddressList
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    public boolean sourceRoute = false;
    public boolean loadBalance = false;
    public boolean failover = true;
    protected SchemaObjectFactoryInterface f = null;

    public AddressList(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    @Override
    public int isA() {
        return 1;
    }

    @Override
    public String isA_String() {
        return "ADDRESS_LIST";
    }

    @Override
    public void initFromString(String string) throws NLException, SOException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        this.initFromNVPair(nVPair);
    }

    @Override
    public void initFromNVPair(NVPair nVPair) throws SOException {
        this.init();
        int n2 = nVPair.getListSize();
        if (n2 == 0) {
            throw new SOException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.childnv = nVPair.getListElement(i2);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            throw new SOException();
        }
        if (this.children.size() == 0) {
            throw new SOException();
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        String string = new String("");
        if (this.children.size() < 1) {
            return string;
        }
        string = string + "(ADDRESS_LIST=";
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            string = string + ((SchemaObject)this.children.elementAt(i2)).toString();
        }
        if (this.sourceRoute) {
            string = string + "(SOURCE_ROUTE=yes)";
        }
        if (this.loadBalance) {
            string = string + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            string = string + "(FAILOVER=false)";
        }
        string = string + ")";
        return string;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
    }
}

