/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetJAEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterJAEUC";
    static final transient short MAX_7BIT = 127;
    static final transient short LEADINGCODE = 143;
    static Class m_charConvSuperclass;

    CharacterSetJAEUC(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSetJAEUC getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 2) {
            return new CharacterSetJAEUC(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 127) {
            if (n2 != 143) {
                if (characterWalker.bytes.length > characterWalker.next) {
                    n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                    ++characterWalker.next;
                }
            } else {
                for (int i2 = 0; i2 < 2; ++i2) {
                    if (characterWalker.bytes.length <= characterWalker.next) continue;
                    n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                    ++characterWalker.next;
                }
            }
        }
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = 0;
        int n4 = 1;
        while (n2 >> n3 != 0) {
            n3 = (short)(n3 + 8);
            n4 = (short)(n4 + 1);
        }
        CharacterSetJAEUC.need(characterBuffer, n4);
        while (n3 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n3 & 0xFF);
            n3 = (short)(n3 - 8);
        }
    }
}

