/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.javadoc;

import java.util.Objects;
import java.util.Optional;
import org.apache.maven.tools.plugin.javadoc.JavadocReference;

public class FullyQualifiedJavadocReference
extends JavadocReference {
    private final boolean isExternal;
    private final Optional<String> packageName;
    private final Optional<MemberType> memberType;

    public FullyQualifiedJavadocReference(String packageName, boolean isExternal) {
        this(packageName, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), isExternal);
    }

    public FullyQualifiedJavadocReference(String packageName, Optional<String> label, boolean isExternal) {
        this(packageName, Optional.empty(), Optional.empty(), Optional.empty(), label, isExternal);
    }

    public FullyQualifiedJavadocReference(String packageName, String className, boolean isExternal) {
        this(packageName, Optional.of(className), Optional.empty(), Optional.empty(), Optional.empty(), isExternal);
    }

    public FullyQualifiedJavadocReference(String packageName, String className, String member, MemberType memberType, boolean isExternal) {
        this(packageName, Optional.of(className), Optional.of(member), Optional.of(memberType), Optional.empty(), isExternal);
    }

    public FullyQualifiedJavadocReference(String packageName, Optional<String> className, Optional<String> member, Optional<MemberType> memberType, Optional<String> label, boolean isExternal) {
        this(Optional.empty(), Optional.of(packageName), className, member, memberType, label, isExternal);
    }

    public FullyQualifiedJavadocReference(Optional<String> moduleName, Optional<String> packageName, Optional<String> className, Optional<String> member, Optional<MemberType> memberType, Optional<String> label, boolean isExternal) {
        super(moduleName, className, member, label);
        this.packageName = packageName;
        this.isExternal = isExternal;
        if (!moduleName.isPresent() && !packageName.isPresent()) {
            throw new IllegalArgumentException("At least one of module name or package name needs to be set");
        }
        if (member.isPresent()) {
            if (!memberType.isPresent()) {
                throw new IllegalArgumentException("When member is set, also the member type needs to be set");
            }
            if (member.get().matches(".*\\s.*")) {
                throw new IllegalArgumentException("member must not contain any whitespace characters!");
            }
        }
        this.memberType = memberType;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public Optional<String> getPackageName() {
        return this.packageName;
    }

    public Optional<String> getClassName() {
        return this.getPackageNameClassName();
    }

    public Optional<MemberType> getMemberType() {
        return this.memberType;
    }

    public Optional<String> getFullyQualifiedClassName() {
        if (this.getClassName().isPresent() && this.getPackageName().isPresent()) {
            return Optional.of(this.getPackageName().get() + "." + this.getClassName().get());
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "FullyQualifiedJavadocReference [moduleName=" + this.getModuleName() + ", packageName=" + this.packageName + ", className=" + this.getClassName() + ", memberType=" + this.memberType + ", member=" + this.getMember() + ", label=" + this.getLabel() + ", isExternal=" + this.isExternal + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.memberType, this.packageName, this.isExternal);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FullyQualifiedJavadocReference other = (FullyQualifiedJavadocReference)obj;
        return Objects.equals(this.memberType, other.memberType) && Objects.equals(this.packageName, other.packageName) && this.isExternal == other.isExternal;
    }

    public static enum MemberType {
        FIELD,
        METHOD,
        CONSTRUCTOR;

    }
}

