/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_JOB_CODE;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.PN;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NK1
extends AbstractSegment {
    public NK1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - Next of Kin");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "NK Name");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Relationship");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "Address");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Phone Number");
            this.add(TN.class, false, 1, 40, new Object[]{this.getMessage()}, "Business Phone Number");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Contact Role");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Start Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "End Date");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Next of Kin");
            this.add(CM_JOB_CODE.class, false, 1, 60, new Object[]{this.getMessage()}, "Next of kin job code / class");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Next of Kin Employee Number");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Organization Name");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating NK1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDNextOfKin() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getNk11_SetIDNextOfKin() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public PN getNKName() {
        PN retVal = (PN)this.getTypedField(2, 0);
        return retVal;
    }

    public PN getNk12_NKName() {
        PN retVal = (PN)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRelationship() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getNk13_Relationship() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public AD getAddress() {
        AD retVal = (AD)this.getTypedField(4, 0);
        return retVal;
    }

    public AD getNk14_Address() {
        AD retVal = (AD)this.getTypedField(4, 0);
        return retVal;
    }

    public TN[] getPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(5, (Type[])new TN[0]);
        return retVal;
    }

    public TN[] getNk15_PhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(5, (Type[])new TN[0]);
        return retVal;
    }

    public int getPhoneNumberReps() {
        return this.getReps(5);
    }

    public TN getPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(5, rep);
        return retVal;
    }

    public TN getNk15_PhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getNk15_PhoneNumberReps() {
        return this.getReps(5);
    }

    public TN insertPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(5, rep);
    }

    public TN insertNk15_PhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(5, rep);
    }

    public TN removePhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(5, rep);
    }

    public TN removeNk15_PhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(5, rep);
    }

    public TN getBusinessPhoneNumber() {
        TN retVal = (TN)this.getTypedField(6, 0);
        return retVal;
    }

    public TN getNk16_BusinessPhoneNumber() {
        TN retVal = (TN)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getContactRole() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getNk17_ContactRole() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public DT getStartDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getNk18_StartDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getEndDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getNk19_EndDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getNextOfKin() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getNk110_NextOfKin() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public CM_JOB_CODE getNextOfKinJobCodeClass() {
        CM_JOB_CODE retVal = (CM_JOB_CODE)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_JOB_CODE getNk111_NextOfKinJobCodeClass() {
        CM_JOB_CODE retVal = (CM_JOB_CODE)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getNextOfKinEmployeeNumber() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getNk112_NextOfKinEmployeeNumber() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getOrganizationName() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getNk113_OrganizationName() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new PN(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new AD(this.getMessage());
            }
            case 4: {
                return new TN(this.getMessage());
            }
            case 5: {
                return new TN(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new DT(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new CM_JOB_CODE(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

