/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PPG_PCG_GOAL;
import ca.uhn.hl7v2.model.v23.group.PPG_PCG_PATHWAY_ROLE;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PTH;
import ca.uhn.hl7v2.model.v23.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPG_PCG_PATHWAY
extends AbstractGroup {
    public PPG_PCG_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PTH.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(VAR.class, false, true, false);
            this.add(PPG_PCG_PATHWAY_ROLE.class, false, true, false);
            this.add(PPG_PCG_GOAL.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PPG_PCG_PATHWAY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PTH getPTH() {
        PTH retVal = (PTH)this.getTyped("PTH", PTH.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPG_PCG_PATHWAY_ROLE getPATHWAY_ROLE() {
        PPG_PCG_PATHWAY_ROLE retVal = (PPG_PCG_PATHWAY_ROLE)this.getTyped("PATHWAY_ROLE", PPG_PCG_PATHWAY_ROLE.class);
        return retVal;
    }

    public PPG_PCG_PATHWAY_ROLE getPATHWAY_ROLE(int rep) {
        PPG_PCG_PATHWAY_ROLE retVal = (PPG_PCG_PATHWAY_ROLE)this.getTyped("PATHWAY_ROLE", rep, PPG_PCG_PATHWAY_ROLE.class);
        return retVal;
    }

    public int getPATHWAY_ROLEReps() {
        return this.getReps("PATHWAY_ROLE");
    }

    public List<PPG_PCG_PATHWAY_ROLE> getPATHWAY_ROLEAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY_ROLE", PPG_PCG_PATHWAY_ROLE.class);
    }

    public void insertPATHWAY_ROLE(PPG_PCG_PATHWAY_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY_ROLE", (Structure)structure, rep);
    }

    public PPG_PCG_PATHWAY_ROLE insertPATHWAY_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY_ROLE)super.insertRepetition("PATHWAY_ROLE", rep);
    }

    public PPG_PCG_PATHWAY_ROLE removePATHWAY_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY_ROLE)super.removeRepetition("PATHWAY_ROLE", rep);
    }

    public PPG_PCG_GOAL getGOAL() {
        PPG_PCG_GOAL retVal = (PPG_PCG_GOAL)this.getTyped("GOAL", PPG_PCG_GOAL.class);
        return retVal;
    }

    public PPG_PCG_GOAL getGOAL(int rep) {
        PPG_PCG_GOAL retVal = (PPG_PCG_GOAL)this.getTyped("GOAL", rep, PPG_PCG_GOAL.class);
        return retVal;
    }

    public int getGOALReps() {
        return this.getReps("GOAL");
    }

    public List<PPG_PCG_GOAL> getGOALAll() throws HL7Exception {
        return this.getAllAsList("GOAL", PPG_PCG_GOAL.class);
    }

    public void insertGOAL(PPG_PCG_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", (Structure)structure, rep);
    }

    public PPG_PCG_GOAL insertGOAL(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL)super.insertRepetition("GOAL", rep);
    }

    public PPG_PCG_GOAL removeGOAL(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL)super.removeRepetition("GOAL", rep);
    }
}

