/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.DLN;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PID
extends AbstractSegment {
    public PID(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - Patient ID");
            this.add(CX.class, false, 1, 16, new Object[]{this.getMessage()}, "Patient ID (External ID)");
            this.add(CX.class, true, 0, 20, new Object[]{this.getMessage()}, "Patient ID (Internal ID)");
            this.add(CX.class, false, 1, 12, new Object[]{this.getMessage()}, "Alternate Patient ID");
            this.add(XPN.class, true, -1, 48, new Object[]{this.getMessage()}, "Patient Name");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage()}, "Mother's Maiden Name");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date of Birth");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Sex");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage()}, "Patient Alias");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(5)}, "Race");
            this.add(XAD.class, false, 0, 106, new Object[]{this.getMessage()}, "Patient Address");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "County Code");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Phone Number - Home");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Phone Number - Business");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Primary Language");
            this.add(IS.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(2)}, "Marital Status");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(6)}, "Religion");
            this.add(CX.class, false, 1, 20, new Object[]{this.getMessage()}, "Patient Account Number");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "SSN Number - Patient");
            this.add(DLN.class, false, 1, 25, new Object[]{this.getMessage()}, "Driver's License Number");
            this.add(CX.class, false, 1, 20, new Object[]{this.getMessage()}, "Mother's Identifier");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(189)}, "Ethnic Group");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Birth Place");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(136)}, "Multiple Birth Indicator");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Birth Order");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(171)}, "Citizenship");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Veterans Military Status");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Nationality Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Patient Death Date and Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Patient Death Indicator");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PID - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPatientID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPid1_SetIDPatientID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CX getPatientIDExternalID() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CX getPid2_PatientIDExternalID() {
        CX retVal = (CX)this.getTypedField(2, 0);
        return retVal;
    }

    public CX[] getPatientIDInternalID() {
        CX[] retVal = (CX[])this.getTypedField(3, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getPid3_PatientIDInternalID() {
        CX[] retVal = (CX[])this.getTypedField(3, (Type[])new CX[0]);
        return retVal;
    }

    public int getPatientIDInternalIDReps() {
        return this.getReps(3);
    }

    public CX getPatientIDInternalID(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public CX getPid3_PatientIDInternalID(int rep) {
        CX retVal = (CX)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPid3_PatientIDInternalIDReps() {
        return this.getReps(3);
    }

    public CX insertPatientIDInternalID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX insertPid3_PatientIDInternalID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX removePatientIDInternalID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX removePid3_PatientIDInternalID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX getAlternatePatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getPid4_AlternatePatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public XPN[] getPatientName() {
        XPN[] retVal = (XPN[])this.getTypedField(5, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getPid5_PatientName() {
        XPN[] retVal = (XPN[])this.getTypedField(5, (Type[])new XPN[0]);
        return retVal;
    }

    public int getPatientNameReps() {
        return this.getReps(5);
    }

    public XPN getPatientName(int rep) {
        XPN retVal = (XPN)this.getTypedField(5, rep);
        return retVal;
    }

    public XPN getPid5_PatientName(int rep) {
        XPN retVal = (XPN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPid5_PatientNameReps() {
        return this.getReps(5);
    }

    public XPN insertPatientName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(5, rep);
    }

    public XPN insertPid5_PatientName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(5, rep);
    }

    public XPN removePatientName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(5, rep);
    }

    public XPN removePid5_PatientName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(5, rep);
    }

    public XPN getMotherSMaidenName() {
        XPN retVal = (XPN)this.getTypedField(6, 0);
        return retVal;
    }

    public XPN getPid6_MotherSMaidenName() {
        XPN retVal = (XPN)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getDateOfBirth() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getPid7_DateOfBirth() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public IS getSex() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getPid8_Sex() {
        IS retVal = (IS)this.getTypedField(8, 0);
        return retVal;
    }

    public XPN[] getPatientAlias() {
        XPN[] retVal = (XPN[])this.getTypedField(9, (Type[])new XPN[0]);
        return retVal;
    }

    public XPN[] getPid9_PatientAlias() {
        XPN[] retVal = (XPN[])this.getTypedField(9, (Type[])new XPN[0]);
        return retVal;
    }

    public int getPatientAliasReps() {
        return this.getReps(9);
    }

    public XPN getPatientAlias(int rep) {
        XPN retVal = (XPN)this.getTypedField(9, rep);
        return retVal;
    }

    public XPN getPid9_PatientAlias(int rep) {
        XPN retVal = (XPN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPid9_PatientAliasReps() {
        return this.getReps(9);
    }

    public XPN insertPatientAlias(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN insertPid9_PatientAlias(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN removePatientAlias(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public XPN removePid9_PatientAlias(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public IS getRace() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getPid10_Race() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD[] getPatientAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getPid11_PatientAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public int getPatientAddressReps() {
        return this.getReps(11);
    }

    public XAD getPatientAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getPid11_PatientAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPid11_PatientAddressReps() {
        return this.getReps(11);
    }

    public XAD insertPatientAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertPid11_PatientAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removePatientAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removePid11_PatientAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public IS getCountyCode() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public IS getPid12_CountyCode() {
        IS retVal = (IS)this.getTypedField(12, 0);
        return retVal;
    }

    public XTN[] getPhoneNumberHome() {
        XTN[] retVal = (XTN[])this.getTypedField(13, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getPid13_PhoneNumberHome() {
        XTN[] retVal = (XTN[])this.getTypedField(13, (Type[])new XTN[0]);
        return retVal;
    }

    public int getPhoneNumberHomeReps() {
        return this.getReps(13);
    }

    public XTN getPhoneNumberHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(13, rep);
        return retVal;
    }

    public XTN getPid13_PhoneNumberHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPid13_PhoneNumberHomeReps() {
        return this.getReps(13);
    }

    public XTN insertPhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN insertPid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN removePhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public XTN removePid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public XTN[] getPhoneNumberBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(14, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getPid14_PhoneNumberBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(14, (Type[])new XTN[0]);
        return retVal;
    }

    public int getPhoneNumberBusinessReps() {
        return this.getReps(14);
    }

    public XTN getPhoneNumberBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public XTN getPid14_PhoneNumberBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPid14_PhoneNumberBusinessReps() {
        return this.getReps(14);
    }

    public XTN insertPhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN insertPid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN removePhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public XTN removePid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public CE getPrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public CE getPid15_PrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(15, 0);
        return retVal;
    }

    public IS[] getMaritalStatus() {
        IS[] retVal = (IS[])this.getTypedField(16, (Type[])new IS[0]);
        return retVal;
    }

    public IS[] getPid16_MaritalStatus() {
        IS[] retVal = (IS[])this.getTypedField(16, (Type[])new IS[0]);
        return retVal;
    }

    public int getMaritalStatusReps() {
        return this.getReps(16);
    }

    public IS getMaritalStatus(int rep) {
        IS retVal = (IS)this.getTypedField(16, rep);
        return retVal;
    }

    public IS getPid16_MaritalStatus(int rep) {
        IS retVal = (IS)this.getTypedField(16, rep);
        return retVal;
    }

    public int getPid16_MaritalStatusReps() {
        return this.getReps(16);
    }

    public IS insertMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(16, rep);
    }

    public IS insertPid16_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(16, rep);
    }

    public IS removeMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(16, rep);
    }

    public IS removePid16_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(16, rep);
    }

    public IS getReligion() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public IS getPid17_Religion() {
        IS retVal = (IS)this.getTypedField(17, 0);
        return retVal;
    }

    public CX getPatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(18, 0);
        return retVal;
    }

    public CX getPid18_PatientAccountNumber() {
        CX retVal = (CX)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getSSNNumberPatient() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getPid19_SSNNumberPatient() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public DLN getDriverSLicenseNumber() {
        DLN retVal = (DLN)this.getTypedField(20, 0);
        return retVal;
    }

    public DLN getPid20_DriverSLicenseNumber() {
        DLN retVal = (DLN)this.getTypedField(20, 0);
        return retVal;
    }

    public CX getMotherSIdentifier() {
        CX retVal = (CX)this.getTypedField(21, 0);
        return retVal;
    }

    public CX getPid21_MotherSIdentifier() {
        CX retVal = (CX)this.getTypedField(21, 0);
        return retVal;
    }

    public IS getEthnicGroup() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public IS getPid22_EthnicGroup() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getBirthPlace() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getPid23_BirthPlace() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getMultipleBirthIndicator() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getPid24_MultipleBirthIndicator() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getBirthOrder() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getPid25_BirthOrder() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public IS getCitizenship() {
        IS retVal = (IS)this.getTypedField(26, 0);
        return retVal;
    }

    public IS getPid26_Citizenship() {
        IS retVal = (IS)this.getTypedField(26, 0);
        return retVal;
    }

    public CE getVeteransMilitaryStatus() {
        CE retVal = (CE)this.getTypedField(27, 0);
        return retVal;
    }

    public CE getPid27_VeteransMilitaryStatus() {
        CE retVal = (CE)this.getTypedField(27, 0);
        return retVal;
    }

    public CE getNationalityCode() {
        CE retVal = (CE)this.getTypedField(28, 0);
        return retVal;
    }

    public CE getPid28_NationalityCode() {
        CE retVal = (CE)this.getTypedField(28, 0);
        return retVal;
    }

    public TS getPatientDeathDateAndTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public TS getPid29_PatientDeathDateAndTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getPatientDeathIndicator() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getPid30_PatientDeathIndicator() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
            case 4: {
                return new XPN(this.getMessage());
            }
            case 5: {
                return new XPN(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 8: {
                return new XPN(this.getMessage());
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(5));
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new IS(this.getMessage(), new Integer(0));
            }
            case 12: {
                return new XTN(this.getMessage());
            }
            case 13: {
                return new XTN(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new IS(this.getMessage(), new Integer(2));
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(6));
            }
            case 17: {
                return new CX(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new DLN(this.getMessage());
            }
            case 20: {
                return new CX(this.getMessage());
            }
            case 21: {
                return new IS(this.getMessage(), new Integer(189));
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new IS(this.getMessage(), new Integer(171));
            }
            case 26: {
                return new CE(this.getMessage());
            }
            case 27: {
                return new CE(this.getMessage());
            }
            case 28: {
                return new TS(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

