/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.OMG_O19_INSURANCE;
import ca.uhn.hl7v2.model.v25.group.OMG_O19_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v25.segment.AL1;
import ca.uhn.hl7v2.model.v25.segment.GT1;
import ca.uhn.hl7v2.model.v25.segment.NK1;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.PD1;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMG_O19_PATIENT
extends AbstractGroup {
    public OMG_O19_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(NK1.class, false, true, false);
            this.add(OMG_O19_PATIENT_VISIT.class, false, false, false);
            this.add(OMG_O19_INSURANCE.class, false, true, false);
            this.add(GT1.class, false, false, false);
            this.add(AL1.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OMG_O19_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = (PD1)this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public NK1 getNK1() {
        NK1 retVal = (NK1)this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = (NK1)this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public OMG_O19_PATIENT_VISIT getPATIENT_VISIT() {
        OMG_O19_PATIENT_VISIT retVal = (OMG_O19_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", OMG_O19_PATIENT_VISIT.class);
        return retVal;
    }

    public OMG_O19_INSURANCE getINSURANCE() {
        OMG_O19_INSURANCE retVal = (OMG_O19_INSURANCE)this.getTyped("INSURANCE", OMG_O19_INSURANCE.class);
        return retVal;
    }

    public OMG_O19_INSURANCE getINSURANCE(int rep) {
        OMG_O19_INSURANCE retVal = (OMG_O19_INSURANCE)this.getTyped("INSURANCE", rep, OMG_O19_INSURANCE.class);
        return retVal;
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<OMG_O19_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", OMG_O19_INSURANCE.class);
    }

    public void insertINSURANCE(OMG_O19_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public OMG_O19_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (OMG_O19_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public OMG_O19_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (OMG_O19_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public GT1 getGT1() {
        GT1 retVal = (GT1)this.getTyped("GT1", GT1.class);
        return retVal;
    }

    public AL1 getAL1() {
        AL1 retVal = (AL1)this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public AL1 getAL1(int rep) {
        AL1 retVal = (AL1)this.getTyped("AL1", rep, AL1.class);
        return retVal;
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }
}

