/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.ajde.ui.BuildConfigNode;

public class BuildConfigModel {
    private BuildConfigNode root = null;
    private String sourceFile;

    public BuildConfigModel(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public BuildConfigNode getNodeForPath(String path) {
        BuildConfigNode upPathMatch = this.searchUpPaths(path);
        if (upPathMatch != null && upPathMatch != this.root) {
            return upPathMatch;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        return this.getNodeForPathHelper(st, this.root);
    }

    private BuildConfigNode searchUpPaths(String path) {
        Iterator it = this.root.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode node = (BuildConfigNode)it.next();
            if (!node.getName().equals(path)) continue;
            return node;
        }
        return null;
    }

    private BuildConfigNode getNodeForPathHelper(StringTokenizer st, BuildConfigNode node) {
        BuildConfigNode parent = node;
        while (st.hasMoreElements()) {
            String pathItem = (String)st.nextElement();
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                node = (BuildConfigNode)it.next();
                String childName = node.getName();
                if (!childName.equals(pathItem)) continue;
                return this.getNodeForPathHelper(st, node);
            }
        }
        return parent;
    }

    public List getActiveNodes(BuildConfigNode.Kind kind) {
        ArrayList nodes = new ArrayList();
        this.getActiveNodesHelper(this.root, kind, nodes);
        return nodes;
    }

    private void getActiveNodesHelper(BuildConfigNode node, BuildConfigNode.Kind kind, List nodes) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode currNode = (BuildConfigNode)it.next();
            if (currNode.getBuildConfigNodeKind().equals(kind) && currNode.isActive()) {
                nodes.add(currNode);
            }
            this.getActiveNodesHelper(currNode, kind, nodes);
        }
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public BuildConfigNode getRoot() {
        return this.root;
    }

    public void setRoot(BuildConfigNode node) {
        this.root = node;
    }

    public BuildConfigNode findNodeForSourceLine(String sourceFilePath, int lineNumber) {
        BuildConfigNode node = this.findNodeForSourceLineHelper(this.root, sourceFilePath, lineNumber);
        return node;
    }

    private BuildConfigNode findNodeForSourceLineHelper(BuildConfigNode node, String sourceFilePath, int lineNumber) {
        if (this.matches(node, sourceFilePath, lineNumber) && !this.hasMoreSpecificChild(node, sourceFilePath, lineNumber)) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                BuildConfigNode foundNode = this.findNodeForSourceLineHelper((BuildConfigNode)it.next(), sourceFilePath, lineNumber);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private boolean matches(BuildConfigNode node, String sourceFilePath, int lineNumber) {
        try {
            return node != null && node.getSourceLocation() != null && node.getSourceLocation().getSourceFile().getCanonicalPath().equals(sourceFilePath) && (node.getSourceLocation().getLine() <= lineNumber && node.getSourceLocation().getEndLine() >= lineNumber || lineNumber <= 1);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean hasMoreSpecificChild(BuildConfigNode node, String sourceFilePath, int lineNumber) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode child = (BuildConfigNode)it.next();
            if (!this.matches(child, sourceFilePath, lineNumber)) continue;
            return true;
        }
        return false;
    }
}

