/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.ICommand;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.internal.core.builder.MissingSourceFileException;
import org.aspectj.weaver.Dump;

public class AjdtCommand
implements ICommand {
    public static final String ABORT_MESSAGE = "ABORT";
    AjBuildManager buildManager = null;
    String[] savedArgs = null;

    public boolean runCommand(String[] args, IMessageHandler handler) {
        this.buildManager = new AjBuildManager(handler);
        this.savedArgs = new String[args.length];
        System.arraycopy(args, 0, this.savedArgs, 0, this.savedArgs.length);
        for (int i = 0; i < args.length; ++i) {
            if (!"-X".equals(args[i])) continue;
            MessageUtil.abort(handler, BuildArgParser.getXOptionUsage());
            return true;
        }
        return this.doCommand(handler, false);
    }

    public boolean repeatCommand(IMessageHandler handler) {
        if (null == this.buildManager) {
            MessageUtil.abort(handler, "repeatCommand called before runCommand");
            return false;
        }
        return this.doCommand(handler, true);
    }

    protected boolean doCommand(IMessageHandler handler, boolean repeat) {
        try {
            CountingMessageHandler counter;
            if (handler instanceof IMessageHolder) {
                Dump.saveMessageHolder((IMessageHolder)handler);
            }
            if ((counter = new CountingMessageHandler(handler)).hasErrors()) {
                return false;
            }
            AjBuildConfig config = AjdtCommand.genBuildConfig(this.savedArgs, counter);
            if (!config.shouldProceed()) {
                return true;
            }
            if (!config.hasSources()) {
                MessageUtil.error(counter, "no sources specified");
            }
            if (counter.hasErrors()) {
                String usage = BuildArgParser.getUsage();
                MessageUtil.abort(handler, usage);
                return false;
            }
            boolean result = (repeat ? this.buildManager.incrementalBuild(config, handler) : this.buildManager.batchBuild(config, handler)) && !counter.hasErrors();
            Dump.dumpOnExit();
            return result;
        }
        catch (AbortException ae) {
            if (ae.isSilent()) {
                throw ae;
            }
            MessageUtil.abort(handler, ABORT_MESSAGE, ae);
        }
        catch (MissingSourceFileException t) {
            MessageUtil.error(handler, t.getMessage());
        }
        catch (Throwable t) {
            MessageUtil.abort(handler, ABORT_MESSAGE, t);
            Dump.dumpWithException(t);
        }
        return false;
    }

    public static AjBuildConfig genBuildConfig(String[] args, CountingMessageHandler handler) {
        String message;
        BuildArgParser parser = new BuildArgParser(handler);
        AjBuildConfig config = parser.genBuildConfig(args);
        SourceLocation location = null;
        if (config.getConfigFile() != null) {
            location = new SourceLocation(config.getConfigFile(), 0);
        }
        if (null != (message = parser.getOtherMessages(true))) {
            IMessage.Kind kind = AjdtCommand.inferKind(message);
            Message m = new Message(message, kind, null, location);
            handler.handleMessage(m);
        }
        return config;
    }

    protected static IMessage.Kind inferKind(String message) {
        if (-1 != message.indexOf("error")) {
            return IMessage.ERROR;
        }
        if (-1 != message.indexOf("info")) {
            return IMessage.INFO;
        }
        return IMessage.WARNING;
    }
}

