/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.aspectj.ajdt.core.AspectJCore;
import org.aspectj.ajdt.internal.compiler.CompilerAdapter;
import org.aspectj.ajdt.internal.compiler.IBinarySourceProvider;
import org.aspectj.ajdt.internal.compiler.ICompilerAdapter;
import org.aspectj.ajdt.internal.compiler.ICompilerAdapterFactory;
import org.aspectj.ajdt.internal.compiler.IIntermediateResultsRequestor;
import org.aspectj.ajdt.internal.compiler.IOutputClassFileNameProvider;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.problem.AjProblemReporter;
import org.aspectj.ajdt.internal.core.builder.AjBatchImageBuilder;
import org.aspectj.ajdt.internal.core.builder.AjBuildNotifier;
import org.aspectj.ajdt.internal.core.builder.AjCompilerOptions;
import org.aspectj.ajdt.internal.core.builder.AjIncrementalImageBuilder;
import org.aspectj.ajdt.internal.core.builder.EclipseClassPathManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.aspectj.org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.aspectj.org.eclipse.jdt.internal.core.builder.IncrementalImageBuilder;
import org.aspectj.org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class AspectJBuilder
extends JavaBuilder
implements ICompilerAdapterFactory {
    private BcelWeaver myWeaver = null;
    private BcelWorld myBcelWorld = null;
    private EclipseClassPathManager cpManager = null;
    private UnwovenResultCollector unwovenResultCollector = null;
    private OutputFileNameProvider fileNameProvider = null;
    private boolean isBatchBuild = false;

    protected IProject[] build(int kind, Map ignored, IProgressMonitor monitor) throws CoreException {
        CompilerAdapter.setCompilerAdapterFactory(this);
        return super.build(kind, ignored, monitor);
    }

    protected BatchImageBuilder getBatchImageBuilder() {
        this.isBatchBuild = true;
        return new AjBatchImageBuilder(this);
    }

    protected IncrementalImageBuilder getIncrementalImageBuilder() {
        this.isBatchBuild = false;
        return new AjIncrementalImageBuilder(this);
    }

    public ICompilerAdapter getAdapter(Compiler forCompiler) {
        EclipseFactory eFactory;
        Map javaOptions = forCompiler.options.getMap();
        AjCompilerOptions ajOptions = new AjCompilerOptions(javaOptions);
        forCompiler.options = ajOptions;
        if (this.isBatchBuild || this.myBcelWorld == null || this.myWeaver == null) {
            this.initWorldAndWeaver(ajOptions);
        } else {
            this.cpManager.setNameEnvironment(this.nameEnvironment);
        }
        AjProblemReporter pr = new AjProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), forCompiler.options, new DefaultProblemFactory(Locale.getDefault()));
        forCompiler.problemReporter = pr;
        AjLookupEnvironment le = new AjLookupEnvironment(forCompiler, forCompiler.options, pr, this.nameEnvironment);
        le.factory = eFactory = new EclipseFactory(le, this.myBcelWorld, ajOptions.xSerializableAspects);
        forCompiler.lookupEnvironment = le;
        if (this.fileNameProvider == null) {
            this.fileNameProvider = new OutputFileNameProvider(this.getProject());
        }
        if (this.isBatchBuild) {
            this.unwovenResultCollector = new UnwovenResultCollector();
        }
        this.unwovenResultCollector.getIntermediateResults();
        throw new UnsupportedOperationException("Is anyone actually using the AspectJBuilder class??");
    }

    protected BuildNotifier createBuildNotifier(IProgressMonitor monitor, IProject currentProject) {
        return new AjBuildNotifier(monitor, currentProject);
    }

    private void initWorldAndWeaver(AjCompilerOptions options) {
        this.cpManager = new EclipseClassPathManager(this.nameEnvironment);
        this.myBcelWorld = new BcelWorld(this.cpManager, (IMessageHandler)new UnhandledMessageHandler(this.getProject()), null);
        this.myBcelWorld.setBehaveInJava5Way(options.behaveInJava5Way);
        this.myBcelWorld.setTargetAspectjRuntimeLevel(options.targetAspectjRuntimeLevel);
        this.myBcelWorld.setXnoInline(options.xNoInline);
        this.myBcelWorld.setXlazyTjp(options.xLazyThisJoinPoint);
        this.myBcelWorld.setXHasMemberSupportEnabled(options.xHasMember);
        this.myBcelWorld.setPinpointMode(options.xdevPinpoint);
        this.setLintProperties(this.myBcelWorld, options);
        this.myWeaver = new BcelWeaver(this.myBcelWorld);
        this.myWeaver.setReweavableMode(options.xNotReweavable);
    }

    private void setLintProperties(BcelWorld world, AjCompilerOptions options) {
        Properties p = new Properties();
        Lint lintSettings = world.getLint();
        Map map = options.getMap();
        p.put(lintSettings.invalidAbsoluteTypeName.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName"));
        p.put(lintSettings.invalidWildcardTypeName.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.WildcardTypeName"));
        p.put(lintSettings.unresolvableMember.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.UnresolvableMember"));
        p.put(lintSettings.typeNotExposedToWeaver.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver"));
        p.put(lintSettings.shadowNotInStructure.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure"));
        p.put(lintSettings.unmatchedSuperTypeInCall.getName(), map.get("org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall"));
        p.put(lintSettings.canNotImplementLazyTjp.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP"));
        p.put(lintSettings.needsSerialVersionUIDField.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField"));
        p.put(lintSettings.serialVersionUIDBroken.getName(), map.get("org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility"));
        lintSettings.setFromProperties(p);
    }

    private static class NullBinarySourceProvider
    implements IBinarySourceProvider {
        private NullBinarySourceProvider() {
        }

        public Map getBinarySourcesForThisWeave() {
            return new HashMap();
        }
    }

    private static class OutputFileNameProvider
    implements IOutputClassFileNameProvider {
        private IPath outputLocation;

        public OutputFileNameProvider(IProject p) {
            try {
                this.outputLocation = JavaCore.create(p).getOutputLocation();
            }
            catch (JavaModelException e) {
                this.outputLocation = new Path(".");
                AspectJCore.getPlugin().getLog().log(e.getStatus());
            }
        }

        public String getOutputClassFileName(char[] eclipseClassFileName, CompilationResult result) {
            String filename = new String(eclipseClassFileName);
            IPath out = this.outputLocation.append(filename);
            out.addFileExtension(".class");
            return out.toOSString();
        }
    }

    private static class UnhandledMessageHandler
    implements IMessageHandler {
        private IProject project;

        public UnhandledMessageHandler(IProject p) {
            this.project = p;
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            try {
                IMarker marker = this.project.createMarker("org.aspectj.org.eclipse.jdt.core.problem");
                marker.setAttribute("message", message.getMessage());
                marker.setAttribute("severity", message.isError() ? 2 : 1);
            }
            catch (CoreException e) {
                AspectJCore.getPlugin().getLog().log(e.getStatus());
            }
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return kind == IMessage.DEBUG || kind == IMessage.INFO;
        }

        public void dontIgnore(IMessage.Kind kind) {
        }

        public void ignore(IMessage.Kind kind) {
        }
    }

    private static class UnwovenResultCollector
    implements IIntermediateResultsRequestor {
        private Collection results = new ArrayList();

        private UnwovenResultCollector() {
        }

        public void acceptResult(InterimCompilationResult intRes) {
            this.results.add(intRes);
        }

        public Collection getIntermediateResults() {
            return this.results;
        }
    }
}

