/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForFieldBindings;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationBinding;
import org.aspectj.org.eclipse.jdt.core.dom.BindingComparator;
import org.aspectj.org.eclipse.jdt.core.dom.BindingResolver;
import org.aspectj.org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.aspectj.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IMethodBinding;
import org.aspectj.org.eclipse.jdt.core.dom.ITypeBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IVariableBinding;
import org.aspectj.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.LocalVariable;
import org.aspectj.runtime.internal.AroundClosure;

class VariableBinding
implements IVariableBinding {
    private static final int VALID_MODIFIERS = 223;
    private org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding;
    private ITypeBinding declaringClass;
    private String key;
    private String name;
    private BindingResolver resolver;
    private ITypeBinding type;

    VariableBinding(BindingResolver resolver, org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public IAnnotationBinding[] getAnnotations() {
        org.aspectj.org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] internalAnnotations = this.binding.getAnnotations();
        int length = internalAnnotations == null ? 0 : internalAnnotations.length;
        IAnnotationBinding[] domInstances = length == 0 ? AnnotationBinding.NoAnnotations : new AnnotationBinding[length];
        int i = 0;
        while (i < length) {
            IAnnotationBinding annotationInstance = this.resolver.getAnnotationInstance(internalAnnotations[i]);
            if (annotationInstance == null) {
                return AnnotationBinding.NoAnnotations;
            }
            domInstances[i] = annotationInstance;
            ++i;
        }
        return domInstances;
    }

    public Object getConstantValue() {
        Constant c = this.binding.constant();
        if (c == null || c == Constant.NotAConstant) {
            return null;
        }
        switch (c.typeID()) {
            case 5: {
                return c.booleanValue();
            }
            case 3: {
                return new Byte(c.byteValue());
            }
            case 2: {
                return new Character(c.charValue());
            }
            case 8: {
                return new Double(c.doubleValue());
            }
            case 9: {
                return new Float(c.floatValue());
            }
            case 10: {
                return new Integer(c.intValue());
            }
            case 7: {
                return new Long(c.longValue());
            }
            case 4: {
                return new Short(c.shortValue());
            }
            case 11: {
                return c.stringValue();
            }
        }
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            if (this.declaringClass == null) {
                FieldBinding fieldBinding;
                FieldBinding fieldBinding2 = fieldBinding = (FieldBinding)this.binding;
                this.declaringClass = this.resolver.getTypeBinding((ReferenceBinding)VariableBinding.declaringClass_aroundBody1$advice(this, fieldBinding2, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding2, null));
            }
            return this.declaringClass;
        }
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        if (!this.isField()) {
            for (ASTNode node = this.resolver.findDeclaringNode(this); node != null; node = node.getParent()) {
                switch (node.getNodeType()) {
                    case 28: {
                        return null;
                    }
                    case 31: {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)node;
                        return methodDeclaration.resolveBinding();
                    }
                }
            }
        }
        return null;
    }

    public IJavaElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).getAccessFlags() & 0xDF;
        }
        if (this.binding.isFinal()) {
            return 16;
        }
        return 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    private JavaElement getUnresolvedJavaElement() {
        int nameLength;
        int nameStart;
        int sourceLength;
        int sourceStart;
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            FieldBinding fieldBinding2 = fieldBinding;
            if ((ReferenceBinding)VariableBinding.declaringClass_aroundBody3$advice(this, fieldBinding2, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding2, null) == null) {
                return null;
            }
            IType declaringType = (IType)this.getDeclaringClass().getJavaElement();
            if (declaringType == null) {
                return null;
            }
            return (JavaElement)((Object)declaringType.getField(this.getName()));
        }
        IMethodBinding declaringMethod = this.getDeclaringMethod();
        if (declaringMethod == null) {
            return null;
        }
        JavaElement method = (JavaElement)declaringMethod.getJavaElement();
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        VariableDeclaration localVar = (VariableDeclaration)((DefaultBindingResolver)this.resolver).bindingsToAstNodes.get(this);
        if (localVar == null) {
            return null;
        }
        if (localVar instanceof SingleVariableDeclaration) {
            sourceStart = localVar.getStartPosition();
            sourceLength = localVar.getLength();
            SimpleName simpleName = ((SingleVariableDeclaration)localVar).getName();
            nameStart = simpleName.getStartPosition();
            nameLength = simpleName.getLength();
        } else {
            nameStart = localVar.getStartPosition();
            nameLength = localVar.getLength();
            ASTNode node = localVar.getParent();
            sourceStart = node.getStartPosition();
            sourceLength = node.getLength();
        }
        char[] typeSig = this.binding.type.genericTypeSignature();
        return new LocalVariable(method, localVar.getName().getIdentifier(), sourceStart, sourceStart + sourceLength - 1, nameStart, nameStart + nameLength - 1, new String(typeSig));
    }

    public IVariableBinding getVariableDeclaration() {
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            return this.resolver.getVariableBinding(fieldBinding.original());
        }
        return this;
    }

    public int getVariableId() {
        return this.binding.id;
    }

    public boolean isParameter() {
        return (this.binding.tagBits & 0x400L) != 0L;
    }

    public boolean isDeprecated() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isDeprecated();
        }
        return false;
    }

    public boolean isEnumConstant() {
        return (this.binding.modifiers & 0x4000) != 0;
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof VariableBinding)) {
            return false;
        }
        org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding otherBinding = ((VariableBinding)other).binding;
        if (this.binding instanceof FieldBinding) {
            if (otherBinding instanceof FieldBinding) {
                return BindingComparator.isEqual((FieldBinding)this.binding, (FieldBinding)otherBinding);
            }
            return false;
        }
        if (BindingComparator.isEqual(this.binding, otherBinding)) {
            IMethodBinding declaringMethod = this.getDeclaringMethod();
            IMethodBinding otherDeclaringMethod = ((VariableBinding)other).getDeclaringMethod();
            if (declaringMethod == null) {
                return otherDeclaringMethod == null;
            }
            return declaringMethod.isEqualTo(otherDeclaringMethod);
        }
        return false;
    }

    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    public boolean isSynthetic() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isSynthetic();
        }
        return false;
    }

    public boolean isRecovered() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody0(VariableBinding variableBinding, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody1$advice(VariableBinding ajc$this, FieldBinding target, OwningClassSupportForFieldBindings ajc$aspectInstance, FieldBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(aBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody2(VariableBinding variableBinding, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody3$advice(VariableBinding ajc$this, FieldBinding target, OwningClassSupportForFieldBindings ajc$aspectInstance, FieldBinding aBinding, AroundClosure ajc$aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(aBinding);
    }
}

