/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.field;

import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IRefCountedField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;

public class FieldOneToOne<T extends NdNode>
implements IField,
IDestructableField,
IRefCountedField {
    private int offset;
    public final Class<T> nodeType;
    FieldOneToOne<?> backPointer;
    private boolean pointsToOwner;

    private FieldOneToOne(Class<T> nodeType, FieldOneToOne<?> backPointer, boolean pointsToOwner) {
        this.nodeType = nodeType;
        if (backPointer != null) {
            if (backPointer.backPointer != null && backPointer.backPointer != this) {
                throw new IllegalArgumentException("Attempted to construct a FieldOneToOne referring to a backpointer list that is already in use by another field");
            }
            backPointer.backPointer = this;
        }
        this.backPointer = backPointer;
        this.pointsToOwner = pointsToOwner;
    }

    public static <T extends NdNode, B extends NdNode> FieldOneToOne<T> create(StructDef<B> builder, Class<T> nodeType, FieldOneToOne<B> forwardPointer) {
        FieldOneToOne<T> result = new FieldOneToOne<T>(nodeType, forwardPointer, false);
        builder.add(result);
        builder.addDestructableField(result);
        return result;
    }

    public static <T extends NdNode, B extends NdNode> FieldOneToOne<T> createOwner(StructDef<B> builder, Class<T> nodeType, FieldOneToOne<B> forwardPointer) {
        FieldOneToOne<T> result = new FieldOneToOne<T>(nodeType, forwardPointer, true);
        builder.add(result);
        builder.addDestructableField(result);
        builder.addOwnerField(result);
        return result;
    }

    public T get(Nd nd, long address) {
        long ptr = nd.getDB().getRecPtr(address + (long)this.offset);
        return NdNode.load(nd, ptr, this.nodeType);
    }

    public void put(Nd nd, long address, T target) {
        this.cleanup(nd, address);
        nd.getDB().putRecPtr(address + (long)this.offset, target == null ? 0L : ((NdNode)target).address);
        if (target == null && this.pointsToOwner) {
            nd.scheduleDeletion(address);
        }
    }

    @Override
    public void destruct(Nd nd, long address) {
        this.cleanup(nd, address);
    }

    private void cleanup(Nd nd, long address) {
        Database db = nd.getDB();
        long ptr = db.getRecPtr(address + (long)this.offset);
        if (ptr != 0L) {
            db.putRecPtr(ptr + (long)this.backPointer.offset, 0L);
            if (this.backPointer.pointsToOwner) {
                nd.scheduleDeletion(ptr);
            }
        }
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getRecordSize() {
        return 4;
    }

    @Override
    public boolean hasReferences(Nd nd, long address) {
        if (this.pointsToOwner) {
            long ptr = nd.getDB().getRecPtr(address + (long)this.offset);
            return ptr != 0L;
        }
        return false;
    }
}

