/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToOne;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdAnnotationInMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdConstant;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethodException;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethodId;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdMethodParameter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdType;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeAnnotationInMethod;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeParameter;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeSignature;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdVariable;
import org.aspectj.org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.aspectj.org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public class NdMethod
extends NdBinding {
    public static final FieldManyToOne<NdMethodId> METHOD_ID;
    public static final FieldShort METHOD_FLAGS;
    public static final FieldManyToOne<NdType> PARENT;
    public static final FieldOneToMany<NdVariable> DECLARED_VARIABLES;
    public static final FieldOneToMany<NdMethodParameter> PARAMETERS;
    public static final FieldOneToOne<NdConstant> DEFAULT_VALUE;
    public static final FieldOneToMany<NdMethodException> EXCEPTIONS;
    public static final FieldManyToOne<NdTypeSignature> RETURN_TYPE;
    public static final FieldLong TAG_BITS;
    public static final FieldOneToMany<NdAnnotationInMethod> ANNOTATIONS;
    public static final FieldOneToMany<NdTypeAnnotationInMethod> TYPE_ANNOTATIONS;
    public static final StructDef<NdMethod> type;
    public static final byte FLG_GENERIC_SIGNATURE_PRESENT = 1;
    public static final byte FLG_THROWS_SIGNATURE_PRESENT = 2;

    static {
        type = StructDef.create(NdMethod.class, NdBinding.type);
        METHOD_ID = FieldManyToOne.create(type, NdMethodId.METHODS);
        METHOD_FLAGS = type.addShort();
        PARENT = FieldManyToOne.create(type, NdType.METHODS);
        PARAMETERS = FieldOneToMany.create(type, NdMethodParameter.PARENT);
        DECLARED_VARIABLES = FieldOneToMany.create(type, NdVariable.DECLARING_METHOD);
        DEFAULT_VALUE = FieldOneToOne.create(type, NdConstant.class, NdConstant.PARENT_METHOD);
        EXCEPTIONS = FieldOneToMany.create(type, NdMethodException.PARENT);
        RETURN_TYPE = FieldManyToOne.create(type, NdTypeSignature.USED_AS_RETURN_TYPE);
        TAG_BITS = type.addLong();
        ANNOTATIONS = FieldOneToMany.create(type, NdAnnotationInMethod.OWNER);
        TYPE_ANNOTATIONS = FieldOneToMany.create(type, NdTypeAnnotationInMethod.OWNER);
        type.done();
    }

    public NdMethod(Nd nd, long address) {
        super(nd, address);
    }

    public NdMethod(NdType parent) {
        super(parent.getNd(), parent.getFile());
        PARENT.put(this.getNd(), this.address, parent);
    }

    public NdMethodId getMethodId() {
        return METHOD_ID.get(this.getNd(), this.address);
    }

    public char[][] getParameterNames() {
        List<NdMethodParameter> params = this.getMethodParameters();
        int index = 0;
        char[][] result = new char[params.size()][];
        int idx = 0;
        while (idx < result.length) {
            NdMethodParameter param = params.get(idx);
            if (!param.isCompilerDefined()) {
                result[index] = param.getName().getChars();
                ++index;
            }
            ++idx;
        }
        return CharArrayUtils.subarray(result, 0, index);
    }

    public List<NdMethodParameter> getMethodParameters() {
        return PARAMETERS.asList(this.getNd(), this.address);
    }

    public List<NdAnnotationInMethod> getAnnotations() {
        return ANNOTATIONS.asList(this.getNd(), this.address);
    }

    public void setDefaultValue(NdConstant value) {
        DEFAULT_VALUE.put(this.getNd(), this.address, value);
    }

    public NdConstant getDefaultValue() {
        return DEFAULT_VALUE.get(this.getNd(), this.address);
    }

    public void setReturnType(NdTypeSignature createTypeSignature) {
        RETURN_TYPE.put(this.getNd(), this.address, createTypeSignature);
    }

    public void setMethodId(NdMethodId methodId) {
        METHOD_ID.put(this.getNd(), this.address, methodId);
    }

    public List<NdTypeAnnotationInMethod> getTypeAnnotations() {
        return TYPE_ANNOTATIONS.asList(this.getNd(), this.address);
    }

    public List<NdMethodException> getExceptions() {
        return EXCEPTIONS.asList(this.getNd(), this.address);
    }

    public NdTypeSignature getReturnType() {
        return RETURN_TYPE.get(this.getNd(), this.address);
    }

    public int getFlags() {
        return METHOD_FLAGS.get(this.getNd(), this.address);
    }

    public boolean hasAllFlags(int flags) {
        int ourFlags = this.getFlags();
        return (ourFlags & flags) == flags;
    }

    public void setFlags(int flags) {
        METHOD_FLAGS.put(this.getNd(), this.address, (short)(this.getFlags() | flags));
    }

    public void setTagBits(long bits) {
        TAG_BITS.put(this.getNd(), this.address, bits);
    }

    public long getTagBits() {
        return TAG_BITS.get(this.getNd(), this.address);
    }

    public String toString() {
        try {
            CharArrayBuffer arrayBuffer = new CharArrayBuffer();
            arrayBuffer.append(this.getMethodId().getSelector());
            this.getGenericSignature(arrayBuffer, true);
            return arrayBuffer.toString();
        }
        catch (RuntimeException e) {
            return super.toString();
        }
    }

    public void getGenericSignature(CharArrayBuffer result, boolean includeExceptions) {
        NdTypeParameter.getSignature(result, this.getTypeParameters());
        result.append('(');
        for (NdMethodParameter next : this.getMethodParameters()) {
            if (next.isCompilerDefined()) continue;
            next.getType().getSignature(result);
        }
        result.append(')');
        NdTypeSignature returnType = this.getReturnType();
        if (returnType == null) {
            result.append('V');
        } else {
            returnType.getSignature(result);
        }
        if (includeExceptions) {
            List<NdMethodException> exceptions = this.getExceptions();
            for (NdMethodException next : exceptions) {
                result.append('^');
                next.getExceptionType().getSignature(result);
            }
        }
    }
}

