/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageDeclaration;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModel;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.ClasspathSourceDirectory;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class JavaSearchNameEnvironment
implements INameEnvironment,
SuffixConstants {
    LinkedHashSet<ClasspathLocation> locationSet;
    Map<String, ICompilationUnit> workingCopies;

    public JavaSearchNameEnvironment(IJavaProject javaProject, ICompilationUnit[] copies) {
        this.locationSet = this.computeClasspathLocations((JavaProject)javaProject);
        this.workingCopies = JavaSearchNameEnvironment.getWorkingCopyMap(copies);
    }

    public static Map<String, ICompilationUnit> getWorkingCopyMap(ICompilationUnit[] copies) {
        int length = copies == null ? 0 : copies.length;
        HashMap<String, ICompilationUnit> result = new HashMap<String, ICompilationUnit>(length);
        try {
            if (copies != null) {
                int i = 0;
                while (i < length) {
                    ICompilationUnit workingCopy = copies[i];
                    IPackageDeclaration[] pkgs = workingCopy.getPackageDeclarations();
                    String pkg = pkgs.length > 0 ? pkgs[0].getElementName() : "";
                    String cuName = workingCopy.getElementName();
                    String mainTypeName = Util.getNameWithoutJavaLikeExtension(cuName);
                    String qualifiedMainTypeName = pkg.length() == 0 ? mainTypeName : String.valueOf(pkg.replace('.', '/')) + '/' + mainTypeName;
                    result.put(qualifiedMainTypeName, workingCopy);
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void cleanup() {
        this.locationSet.clear();
    }

    void addProjectClassPath(JavaProject javaProject) {
        LinkedHashSet<ClasspathLocation> locations = this.computeClasspathLocations(javaProject);
        if (locations != null) {
            this.locationSet.addAll(locations);
        }
    }

    private LinkedHashSet<ClasspathLocation> computeClasspathLocations(JavaProject javaProject) {
        IPackageFragmentRoot[] roots = null;
        try {
            roots = javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            return null;
        }
        LinkedHashSet<ClasspathLocation> locations = new LinkedHashSet<ClasspathLocation>();
        int length = roots.length;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            ClasspathLocation cp = this.mapToClassPathLocation(manager, (PackageFragmentRoot)roots[i]);
            if (cp != null) {
                locations.add(cp);
            }
            ++i;
        }
        return locations;
    }

    private ClasspathLocation mapToClassPathLocation(JavaModelManager manager, PackageFragmentRoot root) {
        ClasspathLocation cp = null;
        IPath path = root.getPath();
        try {
            if (root.isArchive()) {
                ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                cp = new ClasspathJar(manager.getZipFile(path), rawClasspathEntry.getAccessRuleSet(), ClasspathEntry.getExternalAnnotationPath(rawClasspathEntry, ((IJavaProject)root.getParent()).getProject(), true));
            } else {
                Object target = JavaModel.getTarget(path, true);
                if (target != null) {
                    if (root.getKind() == 1) {
                        cp = new ClasspathSourceDirectory((IContainer)target, root.fullExclusionPatternChars(), root.fullInclusionPatternChars());
                    } else {
                        ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                        cp = ClasspathLocation.forBinaryFolder((IContainer)target, false, rawClasspathEntry.getAccessRuleSet(), ClasspathEntry.getExternalAnnotationPath(rawClasspathEntry, ((IJavaProject)root.getParent()).getProject(), true));
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return cp;
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String binaryFileName = null;
        String qBinaryFileName = null;
        String sourceFileName = null;
        String qSourceFileName = null;
        String qPackageName = null;
        NameEnvironmentAnswer suggestedAnswer = null;
        for (ClasspathLocation location : this.locationSet) {
            NameEnvironmentAnswer answer;
            if (location instanceof ClasspathSourceDirectory) {
                org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit workingCopy;
                if (sourceFileName == null) {
                    sourceFileName = qSourceFileName = qualifiedTypeName;
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        int typeNameStart = qSourceFileName.length() - typeName.length;
                        qPackageName = qSourceFileName.substring(0, typeNameStart - 1);
                        sourceFileName = qSourceFileName.substring(typeNameStart);
                    }
                }
                answer = (workingCopy = (org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)this.workingCopies.get(qualifiedTypeName))) != null ? new NameEnvironmentAnswer(workingCopy, null) : location.findClass(sourceFileName, qPackageName, qSourceFileName);
            } else {
                if (binaryFileName == null) {
                    binaryFileName = qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        int typeNameStart = qBinaryFileName.length() - typeName.length - 6;
                        qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
                        binaryFileName = qBinaryFileName.substring(typeNameStart);
                    }
                }
                answer = location.findClass(binaryFileName, qPackageName, qBinaryFileName);
            }
            if (answer == null) continue;
            if (!answer.ignoreIfBetter()) {
                if (!answer.isBetter(suggestedAnswer)) continue;
                return answer;
            }
            if (!answer.isBetter(suggestedAnswer)) continue;
            suggestedAnswer = answer;
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    @Override
    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.isPackage(new String(CharOperation.concatWith(compoundName, packageName, '/')));
    }

    public boolean isPackage(String qualifiedPackageName) {
        Iterator iter = this.locationSet.iterator();
        while (iter.hasNext()) {
            if (!((ClasspathLocation)iter.next()).isPackage(qualifiedPackageName)) continue;
            return true;
        }
        return false;
    }
}

