/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.ConfigurationNavigator;
import org.hibernate.tool.hbm2x.pojo.ComponentPOJOClass;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.type.Type;

public final class DocHelper {
    static final Comparator POJOCLASS_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            POJOClass that = (POJOClass)o1;
            POJOClass what = (POJOClass)o2;
            return that.getDeclarationName().compareTo(what.getDeclarationName());
        }
    };
    private static final Comparator PROPERTY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Property property1 = (Property)o1;
            Property property2 = (Property)o2;
            return property1.getName().compareTo(property2.getName());
        }
    };
    public static final String DEFAULT_NO_SCHEMA_NAME = "default";
    public static final String DEFAULT_NO_PACKAGE = "All Entities";
    private Configuration cfg;
    private Map tablesBySchema = new HashMap();
    private Map classesByPackage = new HashMap();
    private List classes = new ArrayList();
    private Map valuesByColumn = new HashMap();
    private Map propsByValue = new HashMap();
    private List tables = new ArrayList();
    private Map tableSchemaNames = new HashMap();
    private Dialect dialect;

    public DocHelper(Configuration cfg, Cfg2JavaTool cfg2JavaTool) {
        if (cfg == null) {
            throw new IllegalArgumentException("Hibernate Configuration cannot be null");
        }
        this.cfg = cfg;
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        builder.applySettings((Map)cfg.getProperties());
        StandardServiceRegistry serviceRegistry = builder.build();
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        Settings settings = cfg.buildSettings((ServiceRegistry)serviceRegistry);
        this.dialect = jdbcServices.getDialect();
        String defaultCatalog = settings.getDefaultCatalogName();
        String defaultSchema = settings.getDefaultSchemaName();
        if (defaultSchema == null) {
            defaultSchema = DEFAULT_NO_SCHEMA_NAME;
        }
        Iterator tablesIter = cfg.getTableMappings();
        while (tablesIter.hasNext()) {
            String schema;
            Table table = (Table)tablesIter.next();
            if (!table.isPhysicalTable()) continue;
            this.tables.add(table);
            StringBuffer sb = new StringBuffer();
            String catalog = table.getCatalog();
            if (catalog == null) {
                catalog = defaultCatalog;
            }
            if (catalog != null) {
                sb.append(catalog + ".");
            }
            if ((schema = table.getSchema()) == null) {
                schema = defaultSchema;
            }
            sb.append(schema);
            String qualSchemaName = sb.toString();
            this.tableSchemaNames.put(table, qualSchemaName);
            ArrayList<Table> tableList = (ArrayList<Table>)this.tablesBySchema.get(qualSchemaName);
            if (tableList == null) {
                tableList = new ArrayList<Table>();
                this.tablesBySchema.put(qualSchemaName, tableList);
            }
            tableList.add(table);
            Iterator columns = table.getColumnIterator();
            while (columns.hasNext()) {
                Column column = (Column)columns.next();
                String columnFQN = this.getQualifiedColumnName(table, column);
                ArrayList<Value> values = (ArrayList<Value>)this.valuesByColumn.get(columnFQN);
                if (values == null) {
                    values = new ArrayList<Value>();
                    this.valuesByColumn.put(columnFQN, values);
                }
                values.add(column.getValue());
            }
        }
        HashMap components = new HashMap();
        Iterator classesItr = cfg.getClassMappings();
        while (classesItr.hasNext()) {
            PersistentClass clazz = (PersistentClass)classesItr.next();
            POJOClass pojoClazz = cfg2JavaTool.getPOJOClass(clazz);
            ConfigurationNavigator.collectComponents(components, pojoClazz);
            this.processClass(pojoClazz);
            Iterator properties = clazz.getPropertyIterator();
            while (properties.hasNext()) {
                Property property = (Property)properties.next();
                Value value = property.getValue();
                ArrayList<Property> props = (ArrayList<Property>)this.propsByValue.get(value);
                if (props == null) {
                    props = new ArrayList<Property>();
                    this.propsByValue.put(value, props);
                }
                props.add(property);
            }
        }
        for (Component component : components.values()) {
            ComponentPOJOClass element = new ComponentPOJOClass(component, cfg2JavaTool);
            this.processClass(element);
        }
    }

    private void processClass(POJOClass pojoClazz) {
        ArrayList<POJOClass> classList;
        this.classes.add(pojoClazz);
        String packageName = pojoClazz.getPackageName();
        if ("".equals(packageName)) {
            packageName = DEFAULT_NO_PACKAGE;
        }
        if ((classList = (ArrayList<POJOClass>)this.classesByPackage.get(packageName)) == null) {
            classList = new ArrayList<POJOClass>();
            this.classesByPackage.put(packageName, classList);
        }
        classList.add(pojoClazz);
    }

    public Configuration getCfg() {
        return this.cfg;
    }

    public Map getTablesBySchema() {
        return this.tablesBySchema;
    }

    public Map getClassesByPackage() {
        return this.classesByPackage;
    }

    public List getSchemas() {
        ArrayList schemas = new ArrayList(this.tablesBySchema.keySet());
        Collections.sort(schemas);
        return schemas;
    }

    public List getPackages() {
        ArrayList packages = new ArrayList(this.classesByPackage.keySet());
        Collections.sort(packages);
        return packages;
    }

    public List getTables(String schema) {
        List list = (List)this.tablesBySchema.get(schema);
        return list;
    }

    public List getClasses(String packageName) {
        List clazzes = (List)this.classesByPackage.get(packageName);
        ArrayList orderedClasses = new ArrayList(clazzes);
        Collections.sort(orderedClasses, POJOCLASS_COMPARATOR);
        return orderedClasses;
    }

    public List getTables() {
        return this.tables;
    }

    public List getClasses() {
        ArrayList orderedClasses = new ArrayList(this.classes);
        Collections.sort(orderedClasses, POJOCLASS_COMPARATOR);
        return orderedClasses;
    }

    public String getQualifiedSchemaName(Table table) {
        return (String)this.tableSchemaNames.get(table);
    }

    public String getQualifiedTableName(Table table) {
        String qualifiedSchemaName = this.getQualifiedSchemaName(table);
        return qualifiedSchemaName + '.' + table.getName();
    }

    public String getPropertyType(Property p) {
        Value v = p.getValue();
        String propertyString = "N/D";
        try {
            Type t = v.getType();
            propertyString = t.getReturnedClass().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyString;
    }

    public String getQualifiedColumnName(Table table, Column column) {
        String qualifiedTableName = this.getQualifiedTableName(table);
        return qualifiedTableName + '.' + column.getName();
    }

    public String getSQLTypeName(Column column) {
        try {
            return column.getSqlType(this.dialect, null);
        }
        catch (HibernateException ex) {
            return "N/D";
        }
    }

    public List getValues(Table table, Column column) {
        String columnFQN = this.getQualifiedColumnName(table, column);
        List values = (List)this.valuesByColumn.get(columnFQN);
        if (values != null) {
            return values;
        }
        return new ArrayList();
    }

    public List getProperties(Table table, Column column) {
        ArrayList result = new ArrayList();
        for (Value value : this.getValues(table, column)) {
            List props = (List)this.propsByValue.get(value);
            if (props == null) continue;
            result.addAll(props);
        }
        return result;
    }

    public POJOClass getComponentPOJO(Property property) {
        if (property.getValue() instanceof Component) {
            Component comp = (Component)property.getValue();
            ComponentPOJOClass componentPOJOClass = new ComponentPOJOClass(comp, new Cfg2JavaTool());
            return componentPOJOClass;
        }
        return null;
    }

    public List getInheritanceHierarchy(POJOClass pc) {
        if (pc.isSubclass()) {
            ArrayList<POJOClass> superClasses = new ArrayList<POJOClass>();
            for (POJOClass superClass = pc.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                superClasses.add(superClass);
            }
            return superClasses;
        }
        return Collections.EMPTY_LIST;
    }

    public List getOrderedProperties(POJOClass pojoClass) {
        List orderedProperties = this.getAllProperties(pojoClass);
        Collections.sort(orderedProperties, PROPERTY_COMPARATOR);
        return orderedProperties;
    }

    public List getSimpleProperties(POJOClass pojoClass) {
        List properties = this.getAllProperties(pojoClass);
        if (pojoClass.hasIdentifierProperty()) {
            properties.remove(pojoClass.getIdentifierProperty());
        }
        if (pojoClass.hasVersionProperty()) {
            properties.remove(pojoClass.getVersionProperty());
        }
        return properties;
    }

    public List getOrderedSimpleProperties(POJOClass pojoClass) {
        List orderedProperties = this.getSimpleProperties(pojoClass);
        Collections.sort(orderedProperties, PROPERTY_COMPARATOR);
        return orderedProperties;
    }

    private List getAllProperties(POJOClass pojoClass) {
        ArrayList properties = new ArrayList();
        Iterator iterator = pojoClass.getAllPropertiesIterator();
        while (iterator.hasNext()) {
            properties.add(iterator.next());
        }
        return properties;
    }
}

