/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.GZIPInputStream;
import com.jcraft.jzlib.GZIPOutputStream;
import com.jcraft.jzlib.Inflater;
import com.jcraft.jzlib.JZlib;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jcodings.Encoding;
import org.joda.time.DateTime;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStringIO;
import org.jruby.RubyTime;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.Adler32Ext;
import org.jruby.util.ByteList;
import org.jruby.util.CRC32Ext;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.Stream;

@JRubyModule(name={"Zlib"})
public class RubyZlib {
    public static final String ZLIB_VERSION = "1.2.3.3";
    public static final String VERSION = "0.6.0";
    private static final long[] crctab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    public static RubyModule createZlibModule(Ruby runtime2) {
        RubyModule mZlib = runtime2.defineModule("Zlib");
        mZlib.defineAnnotatedMethods(RubyZlib.class);
        RubyClass cStandardError = runtime2.getStandardError();
        RubyClass cZlibError = mZlib.defineClassUnder("Error", cStandardError, cStandardError.getAllocator());
        mZlib.defineClassUnder("StreamEnd", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("StreamError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("BufError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("NeedDict", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("MemError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("VersionError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("DataError", cZlibError, cZlibError.getAllocator());
        RubyClass cGzFile = mZlib.defineClassUnder("GzipFile", runtime2.getObject(), RubyGzipFile.GZIPFILE_ALLOCATOR);
        cGzFile.defineAnnotatedMethods(RubyGzipFile.class);
        cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        RubyClass cGzError = cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        if (runtime2.is1_9()) {
            cGzError.addReadAttribute(runtime2.getCurrentContext(), "input");
        }
        cGzError.defineAnnotatedMethods(RubyGzipFile.Error.class);
        cGzFile.defineClassUnder("CRCError", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("NoFooter", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("LengthError", cGzError, cGzError.getAllocator());
        RubyClass cGzReader = mZlib.defineClassUnder("GzipReader", cGzFile, JZlibRubyGzipReader.GZIPREADER_ALLOCATOR);
        cGzReader.includeModule(runtime2.getEnumerable());
        cGzReader.defineAnnotatedMethods(JZlibRubyGzipReader.class);
        RubyClass cGzWriter = mZlib.defineClassUnder("GzipWriter", cGzFile, JZlibRubyGzipWriter.GZIPWRITER_ALLOCATOR);
        cGzWriter.defineAnnotatedMethods(JZlibRubyGzipWriter.class);
        mZlib.defineConstant("ZLIB_VERSION", runtime2.newString(ZLIB_VERSION));
        mZlib.defineConstant("VERSION", runtime2.newString(VERSION));
        mZlib.defineConstant("BINARY", runtime2.newFixnum(0));
        mZlib.defineConstant("ASCII", runtime2.newFixnum(1));
        mZlib.defineConstant("UNKNOWN", runtime2.newFixnum(2));
        mZlib.defineConstant("DEF_MEM_LEVEL", runtime2.newFixnum(8));
        mZlib.defineConstant("MAX_MEM_LEVEL", runtime2.newFixnum(9));
        mZlib.defineConstant("OS_UNIX", runtime2.newFixnum(3));
        mZlib.defineConstant("OS_UNKNOWN", runtime2.newFixnum(-1));
        mZlib.defineConstant("OS_CODE", runtime2.newFixnum(11));
        mZlib.defineConstant("OS_ZSYSTEM", runtime2.newFixnum(8));
        mZlib.defineConstant("OS_VMCMS", runtime2.newFixnum(4));
        mZlib.defineConstant("OS_VMS", runtime2.newFixnum(2));
        mZlib.defineConstant("OS_RISCOS", runtime2.newFixnum(13));
        mZlib.defineConstant("OS_MACOS", runtime2.newFixnum(7));
        mZlib.defineConstant("OS_OS2", runtime2.newFixnum(6));
        mZlib.defineConstant("OS_AMIGA", runtime2.newFixnum(1));
        mZlib.defineConstant("OS_QDOS", runtime2.newFixnum(12));
        mZlib.defineConstant("OS_WIN32", runtime2.newFixnum(11));
        mZlib.defineConstant("OS_ATARI", runtime2.newFixnum(5));
        mZlib.defineConstant("OS_MSDOS", runtime2.newFixnum(0));
        mZlib.defineConstant("OS_CPM", runtime2.newFixnum(9));
        mZlib.defineConstant("OS_TOPS20", runtime2.newFixnum(10));
        mZlib.defineConstant("DEFAULT_STRATEGY", runtime2.newFixnum(0));
        mZlib.defineConstant("FILTERED", runtime2.newFixnum(1));
        mZlib.defineConstant("HUFFMAN_ONLY", runtime2.newFixnum(2));
        mZlib.defineConstant("NO_FLUSH", runtime2.newFixnum(0));
        mZlib.defineConstant("SYNC_FLUSH", runtime2.newFixnum(2));
        mZlib.defineConstant("FULL_FLUSH", runtime2.newFixnum(3));
        mZlib.defineConstant("FINISH", runtime2.newFixnum(4));
        mZlib.defineConstant("NO_COMPRESSION", runtime2.newFixnum(0));
        mZlib.defineConstant("BEST_SPEED", runtime2.newFixnum(1));
        mZlib.defineConstant("DEFAULT_COMPRESSION", runtime2.newFixnum(-1));
        mZlib.defineConstant("BEST_COMPRESSION", runtime2.newFixnum(9));
        mZlib.defineConstant("MAX_WBITS", runtime2.newFixnum(15));
        RubyClass cZStream = mZlib.defineClassUnder("ZStream", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cZStream.defineAnnotatedMethods(ZStream.class);
        cZStream.undefineMethod("new");
        RubyClass cInflate = mZlib.defineClassUnder("Inflate", cZStream, JZlibInflate.INFLATE_ALLOCATOR);
        cInflate.defineAnnotatedMethods(JZlibInflate.class);
        RubyClass cDeflate = mZlib.defineClassUnder("Deflate", cZStream, JZlibDeflate.DEFLATE_ALLOCATOR);
        cDeflate.defineAnnotatedMethods(JZlibDeflate.class);
        runtime2.getKernel().callMethod(runtime2.getCurrentContext(), "require", (IRubyObject)runtime2.newString("stringio"));
        return mZlib;
    }

    @JRubyMethod(name={"zlib_version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zlib_version(IRubyObject recv2) {
        RubyBasicObject res = (RubyBasicObject)((RubyModule)recv2).getConstant("ZLIB_VERSION");
        res.setTaint(true);
        return res;
    }

    @JRubyMethod(name={"crc32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        long crc2 = 0L;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            crc2 = RubyNumeric.num2long(args2[1]);
        }
        CRC32Ext ext2 = new CRC32Ext((int)crc2);
        if (bytes2 != null) {
            ext2.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        return recv2.getRuntime().newFixnum(ext2.getValue());
    }

    @JRubyMethod(name={"adler32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        int adler2 = 1;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            adler2 = RubyNumeric.fix2int(args2[1]);
        }
        Adler32Ext ext2 = new Adler32Ext(adler2);
        if (bytes2 != null) {
            ext2.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        return recv2.getRuntime().newFixnum(ext2.getValue());
    }

    @JRubyMethod(name={"crc_table"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc_table(IRubyObject recv2) {
        ArrayList<IRubyObject> ll = new ArrayList<IRubyObject>(crctab.length);
        for (int i2 = 0; i2 < crctab.length; ++i2) {
            ll.add(recv2.getRuntime().newFixnum(crctab[i2]));
        }
        return recv2.getRuntime().newArray(ll);
    }

    @JRubyMethod(name={"crc32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long crc1 = RubyNumeric.num2long(arg0);
        long crc2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long crc3 = JZlib.crc32_combine(crc1, crc2, len2);
        return recv2.getRuntime().newFixnum(crc3);
    }

    @JRubyMethod(name={"adler32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long adler1 = RubyNumeric.num2long(arg0);
        long adler2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long adler3 = JZlib.adler32_combine(adler1, adler2, len2);
        return recv2.getRuntime().newFixnum(adler3);
    }

    static RaiseException newZlibError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "Error", message2);
    }

    static RaiseException newBufError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "BufError", message2);
    }

    static RaiseException newDictError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "NeedDict", message2);
    }

    static RaiseException newStreamError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "StreamError", message2);
    }

    static RaiseException newDataError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "DataError", message2);
    }

    private static RaiseException newZlibError(Ruby runtime2, String klass, String message2) {
        RubyClass errorClass = runtime2.getModule("Zlib").getClass(klass);
        return new RaiseException(RubyException.newException(runtime2, errorClass, message2), true);
    }

    static RaiseException newGzipFileError(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "Error", message2);
    }

    static RaiseException newCRCError(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "CRCError", message2);
    }

    static RaiseException newNoFooter(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "NoFooter", message2);
    }

    static RaiseException newLengthError(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "LengthError", message2);
    }

    private static RaiseException newGzipFileError(Ruby runtime2, String klass, String message2) {
        RubyClass errorClass = runtime2.getModule("Zlib").getClass("GzipFile").getClass(klass);
        RubyException excn = RubyException.newException(runtime2, errorClass, message2);
        if (runtime2.is1_9()) {
            excn.setInstanceVariable("@input", runtime2.getNil());
        }
        return new RaiseException(excn, true);
    }

    @JRubyClass(name={"Zlib::GzipWriter"}, parent="Zlib::GzipFile")
    public static class JZlibRubyGzipWriter
    extends RubyGzipFile {
        protected static final ObjectAllocator GZIPWRITER_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new JZlibRubyGzipWriter(runtime2, klass);
            }
        };
        private GZIPOutputStream io;

        @JRubyMethod(name={"new"}, rest=true, meta=true)
        public static JZlibRubyGzipWriter newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
            RubyClass klass = (RubyClass)recv2;
            JZlibRubyGzipWriter result2 = (JZlibRubyGzipWriter)klass.allocate();
            result2.callInit(args2, block);
            return result2;
        }

        @JRubyMethod(name={"open"}, required=1, optional=2, meta=true, compat=CompatVersion.RUBY1_8)
        public static IRubyObject open18(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", args2[0], (IRubyObject)runtime2.newString("wb"));
            JZlibRubyGzipWriter gzio = JZlibRubyGzipWriter.newInstance(recv2, JZlibRubyGzipWriter.argsWithIo(io2, args2), block);
            return RubyGzipFile.wrapBlock(context, gzio, block);
        }

        @JRubyMethod(name={"open"}, required=1, optional=3, meta=true, compat=CompatVersion.RUBY1_9)
        public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", args2[0], (IRubyObject)runtime2.newString("wb"));
            JZlibRubyGzipWriter gzio = JZlibRubyGzipWriter.newInstance(recv2, JZlibRubyGzipWriter.argsWithIo(io2, args2), block);
            return RubyGzipFile.wrapBlock(context, gzio, block);
        }

        public JZlibRubyGzipWriter(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"initialize"}, required=1, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
        public IRubyObject initialize(IRubyObject[] args2) {
            if (args2.length > 2) {
                JZlibRubyGzipWriter.checkLevel(this.getRuntime(), RubyNumeric.fix2int(args2[2]));
            }
            return this.initializeCommon(args2[0]);
        }

        private IRubyObject initializeCommon(IRubyObject stream) {
            this.realIo = (RubyObject)stream;
            try {
                this.io = new GZIPOutputStream((OutputStream)new IOOutputStream(this.realIo, false, false), 512, false);
                return this;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
        public IRubyObject initialize19(IRubyObject[] args2, Block unused2) {
            IRubyObject opt;
            IRubyObject obj = this.initializeCommon(args2[0]);
            if (args2.length > 2 && !(opt = TypeConverter.checkHashType(this.getRuntime(), args2[args2.length - 1])).isNil()) {
                RubyIO.EncodingOption enc = RubyIO.extractEncodingOptions(opt);
                if (enc != null) {
                    this.readEncoding = enc.getExternalEncoding();
                    this.writeEncoding = enc.getInternalEncoding();
                }
                IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
                System.arraycopy(args2, 0, newArgs, 0, args2.length - 1);
                args2 = newArgs;
            }
            if (args2.length > 2) {
                JZlibRubyGzipWriter.checkLevel(this.getRuntime(), RubyNumeric.fix2int(args2[2]));
            }
            if (this.realIo.respondsTo("path")) {
                obj.getSingletonClass().defineMethod("path", new Callback(){

                    public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                        return ((JZlibRubyGzipWriter)recv2).realIo.callMethod(recv2.getRuntime().getCurrentContext(), "path");
                    }

                    public Arity getArity() {
                        return Arity.NO_ARGUMENTS;
                    }
                });
            }
            return obj;
        }

        private static void checkLevel(Ruby runtime2, int level2) {
            if (level2 < 0 || level2 > 9) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid level");
            }
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() {
            if (!this.closed) {
                try {
                    this.io.close();
                    if (this.realIo.respondsTo("close")) {
                        this.realIo.callMethod(this.realIo.getRuntime().getCurrentContext(), "close");
                    }
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"append", "<<"}, required=1)
        public IRubyObject append(IRubyObject p1) {
            this.write(p1);
            return this;
        }

        @JRubyMethod(name={"printf"}, required=1, rest=true)
        public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
            this.write(RubyKernel.sprintf(context, this, args2));
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"print"}, rest=true)
        public IRubyObject print(IRubyObject[] args2) {
            IRubyObject sep;
            if (args2.length != 0) {
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    this.write(args2[i2]);
                }
            }
            if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
                this.write(sep);
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"pos", "tell"})
        public IRubyObject pos() {
            return RubyNumeric.int2fix(this.getRuntime(), this.io.getTotalIn());
        }

        @JRubyMethod(name={"orig_name="}, required=1)
        public IRubyObject set_orig_name(IRubyObject obj) {
            this.nullFreeOrigName = obj.convertToString();
            this.ensureNonNull(this.nullFreeOrigName);
            try {
                this.io.setName(this.nullFreeOrigName.toString());
            }
            catch (GZIPException e) {
                throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
            }
            return obj;
        }

        @JRubyMethod(name={"comment="}, required=1)
        public IRubyObject set_comment(IRubyObject obj) {
            this.nullFreeComment = obj.convertToString();
            this.ensureNonNull(this.nullFreeComment);
            try {
                this.io.setComment(this.nullFreeComment.toString());
            }
            catch (GZIPException e) {
                throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
            }
            return obj;
        }

        private void ensureNonNull(RubyString obj) {
            String str = obj.toString();
            if (str.indexOf(0) >= 0) {
                String trim = str.substring(0, str.toString().indexOf(0));
                obj.setValue(new ByteList(trim.getBytes()));
            }
        }

        @JRubyMethod(name={"putc"}, required=1)
        public IRubyObject putc(IRubyObject p1) {
            try {
                this.io.write(RubyNumeric.num2chr(p1));
                return p1;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"puts"}, rest=true)
        public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
            RubyStringIO sio = (RubyStringIO)this.getRuntime().getClass("StringIO").newInstance(context, new IRubyObject[0], Block.NULL_BLOCK);
            sio.puts(context, args2);
            this.write(sio.string());
            return this.getRuntime().getNil();
        }

        public IRubyObject finish() {
            if (!this.finished) {
                try {
                    this.io.finish();
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            this.finished = true;
            return this.realIo;
        }

        @JRubyMethod(name={"flush"}, optional=1)
        public IRubyObject flush(IRubyObject[] args2) {
            int flush2 = 2;
            if (args2.length > 0 && !args2[0].isNil()) {
                flush2 = RubyNumeric.fix2int(args2[0]);
            }
            boolean tmp = this.io.getSyncFlush();
            try {
                try {
                    if (flush2 != 0) {
                        this.io.setSyncFlush(true);
                    }
                    this.io.flush();
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.io.setSyncFlush(tmp);
                throw throwable;
            }
            this.io.setSyncFlush(tmp);
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"mtime="}, required=1)
        public IRubyObject set_mtime(IRubyObject arg2) {
            if (arg2 instanceof RubyTime) {
                this.mtime = (RubyTime)arg2;
            } else if (!arg2.isNil()) {
                this.mtime.setDateTime(new DateTime(RubyNumeric.fix2long(arg2) * 1000L));
            }
            try {
                this.io.setModifiedTime(this.mtime.to_i().getLongValue());
            }
            catch (GZIPException e) {
                throw RubyZlib.newGzipFileError(this.getRuntime(), "header is already written");
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"crc"})
        public IRubyObject crc() {
            long crc2 = 0L;
            try {
                crc2 = this.io.getCRC();
            }
            catch (GZIPException gZIPException) {
                // empty catch block
            }
            return this.getRuntime().newFixnum(crc2);
        }

        @JRubyMethod(name={"write"}, required=1)
        public IRubyObject write(IRubyObject p1) {
            ByteList bytes2 = p1.asString().getByteList();
            Ruby runtime2 = this.getRuntime();
            if (runtime2.is1_9() && this.writeEncoding != null && this.writeEncoding != runtime2.getEncodingService().getAscii8bitEncoding()) {
                bytes2 = RubyString.transcode(runtime2.getCurrentContext(), bytes2, null, this.writeEncoding, runtime2.getNil());
            }
            try {
                if (bytes2.length() > 0) {
                    this.io.write(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
                }
                return this.getRuntime().newFixnum(bytes2.length());
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod
        public IRubyObject set_sync(IRubyObject arg2) {
            IRubyObject s2 = super.set_sync(arg2);
            this.io.setSyncFlush(this.sync);
            return s2;
        }
    }

    @JRubyClass(name={"Zlib::GzipReader"}, parent="Zlib::GzipFile", include={"Enumerable"})
    public static class JZlibRubyGzipReader
    extends RubyGzipFile {
        protected static final ObjectAllocator GZIPREADER_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new JZlibRubyGzipReader(runtime2, klass);
            }
        };
        private int line;
        private long position;
        private GZIPInputStream io;
        private InputStream bufferedStream;
        private static final int BUFF_SIZE = 4096;

        @JRubyMethod(name={"new"}, rest=true, meta=true)
        public static JZlibRubyGzipReader newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
            RubyClass klass = (RubyClass)recv2;
            JZlibRubyGzipReader result2 = (JZlibRubyGzipReader)klass.allocate();
            result2.callInit(args2, block);
            return result2;
        }

        @JRubyMethod(name={"open"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
        public static IRubyObject open18(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", args2[0], (IRubyObject)runtime2.newString("rb"));
            JZlibRubyGzipReader gzio = JZlibRubyGzipReader.newInstance(recv2, new IRubyObject[]{io2}, block);
            return RubyGzipFile.wrapBlock(context, gzio, block);
        }

        @JRubyMethod(name={"open"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
        public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            IRubyObject io2 = RuntimeHelpers.invoke(context, (IRubyObject)runtime2.getFile(), "open", args2[0], (IRubyObject)runtime2.newString("rb"));
            JZlibRubyGzipReader gzio = JZlibRubyGzipReader.newInstance(recv2, JZlibRubyGzipReader.argsWithIo(io2, args2), block);
            return RubyGzipFile.wrapBlock(context, gzio, block);
        }

        public JZlibRubyGzipReader(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
        public IRubyObject initialize(IRubyObject stream) {
            this.realIo = stream;
            this.line = 0;
            this.position = 0L;
            try {
                this.io = new GZIPInputStream((InputStream)new IOInputStream(this.realIo), 512, false);
                this.io.readHeader();
            }
            catch (IOException e) {
                byte[] input;
                RaiseException re = RubyZlib.newGzipFileError(this.getRuntime(), "not in gzip format");
                if (this.getRuntime().is1_9() && (input = this.io.getAvailIn()) != null && input.length > 0) {
                    ByteList i2 = new ByteList(input, 0, input.length);
                    RubyException rubye = re.getException();
                    rubye.setInstanceVariable("@input", RubyString.newString(this.getRuntime(), i2));
                }
                throw re;
            }
            this.bufferedStream = new BufferedInputStream(this.io);
            return this;
        }

        @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
        public IRubyObject initialize19(IRubyObject[] args2) {
            RubyIO.EncodingOption enc;
            IRubyObject opt;
            IRubyObject obj = this.initialize(args2[0]);
            if (args2.length > 1 && !(opt = TypeConverter.checkHashType(this.getRuntime(), args2[args2.length - 1])).isNil() && (enc = RubyIO.extractEncodingOptions(opt)) != null) {
                this.readEncoding = enc.getExternalEncoding();
                this.writeEncoding = enc.getInternalEncoding();
            }
            if (this.realIo.respondsTo("path")) {
                obj.getSingletonClass().defineMethod("path", new Callback(){

                    public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                        return ((JZlibRubyGzipReader)recv2).realIo.callMethod(recv2.getRuntime().getCurrentContext(), "path");
                    }

                    public Arity getArity() {
                        return Arity.NO_ARGUMENTS;
                    }
                });
            }
            return obj;
        }

        private long internalPosition() {
            long n = this.io.getTotalIn();
            if (this.io.getAvailIn() != null) {
                n += (long)this.io.getAvailIn().length;
            }
            return n;
        }

        @JRubyMethod
        public IRubyObject rewind() {
            Ruby rt = this.getRuntime();
            this.realIo.callMethod(rt.getCurrentContext(), "seek", new IRubyObject[]{rt.newFixnum(-this.internalPosition()), rt.newFixnum(1)});
            this.initialize(this.realIo);
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"lineno"})
        public IRubyObject lineno() {
            return this.getRuntime().newFixnum(this.line);
        }

        @JRubyMethod(name={"readline"}, writes={FrameField.LASTLINE})
        public IRubyObject readline(ThreadContext context) {
            IRubyObject dst = this.gets_18(context, new IRubyObject[0]);
            if (dst.isNil()) {
                throw this.getRuntime().newEOFError();
            }
            return dst;
        }

        private IRubyObject internalGets(IRubyObject[] args2) throws IOException {
            ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            int limit2 = -1;
            switch (args2.length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (args2[0].isNil()) {
                        return this.readAll();
                    }
                    IRubyObject tmp = args2[0].checkStringType();
                    if (tmp.isNil()) {
                        limit2 = RubyNumeric.fix2int(args2[0]);
                        break;
                    }
                    sep = tmp.convertToString().getByteList();
                    break;
                }
                default: {
                    limit2 = RubyNumeric.fix2int(args2[1]);
                    if (args2[0].isNil()) {
                        return this.readAll(limit2);
                    }
                    sep = args2[0].convertToString().getByteList();
                }
            }
            return this.internalSepGets(sep, limit2);
        }

        private IRubyObject internalSepGets(ByteList sep) throws IOException {
            return this.internalSepGets(sep, -1);
        }

        private ByteList newReadByteList() {
            ByteList byteList = new ByteList();
            if (this.readEncoding != null) {
                byteList.setEncoding(this.readEncoding);
            }
            return byteList;
        }

        private ByteList newReadByteList(int size2) {
            ByteList byteList = new ByteList(size2);
            if (this.readEncoding != null) {
                byteList.setEncoding(this.readEncoding);
            }
            return byteList;
        }

        private IRubyObject internalSepGets(ByteList sep, int limit2) throws IOException {
            ByteList result2 = this.newReadByteList();
            if (sep.getRealSize() == 0) {
                sep = Stream.PARAGRAPH_SEPARATOR;
            }
            int ce = -1;
            while (result2.indexOf(sep) == -1 && (ce = this.bufferedStream.read()) != -1) {
                result2.append(ce);
                if (limit2 <= 0 || result2.length() < limit2) continue;
            }
            if (0 == result2.length() && -1 == ce) {
                return this.getRuntime().getNil();
            }
            ++this.line;
            this.position = result2.length();
            return this.newStr(this.getRuntime(), result2);
        }

        @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_8)
        public IRubyObject gets_18(ThreadContext context, IRubyObject[] args2) {
            return this.gets(context, args2);
        }

        @JRubyMethod(name={"gets"}, optional=2, writes={FrameField.LASTLINE}, compat=CompatVersion.RUBY1_9)
        public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
            try {
                IRubyObject result2 = this.internalGets(args2);
                if (!result2.isNil()) {
                    context.getCurrentScope().setLastLine(result2);
                }
                return result2;
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"read"}, optional=1)
        public IRubyObject read(IRubyObject[] args2) {
            try {
                if (args2.length == 0 || args2[0].isNil()) {
                    return this.readAll();
                }
                int len = RubyNumeric.fix2int(args2[0]);
                if (len < 0) {
                    throw this.getRuntime().newArgumentError("negative length " + len + " given");
                }
                if (len > 0) {
                    return this.readSize(len);
                }
                return RubyString.newEmptyString(this.getRuntime());
            }
            catch (IOException ioe) {
                String m = ioe.getMessage();
                if (m.startsWith("Unexpected end of ZLIB input stream")) {
                    throw RubyZlib.newGzipFileError(this.getRuntime(), ioe.getMessage());
                }
                if (m.startsWith("footer is not found")) {
                    throw RubyZlib.newNoFooter(this.getRuntime(), "footer is not found");
                }
                if (m.startsWith("incorrect data check")) {
                    throw RubyZlib.newCRCError(this.getRuntime(), "invalid compressed data -- crc error");
                }
                if (m.startsWith("incorrect length check")) {
                    throw RubyZlib.newLengthError(this.getRuntime(), "invalid compressed data -- length error");
                }
                throw RubyZlib.newDataError(this.getRuntime(), ioe.getMessage());
            }
        }

        @JRubyMethod(name={"readpartial"}, required=1, optional=1)
        public IRubyObject readpartial(IRubyObject[] args2) {
            try {
                int len = RubyNumeric.fix2int(args2[0]);
                if (len < 0) {
                    throw this.getRuntime().newArgumentError("negative length " + len + " given");
                }
                if (args2.length > 1) {
                    if (!(args2[1] instanceof RubyString)) {
                        throw this.getRuntime().newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected String)");
                    }
                    return this.readPartial(len, (RubyString)args2[1]);
                }
                return this.readPartial(len, null);
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        private IRubyObject readPartial(int len, RubyString outbuf) throws IOException {
            ByteList val = this.newReadByteList(10);
            byte[] buffer = new byte[len];
            int read2 = this.bufferedStream.read(buffer, 0, len);
            if (read2 == -1) {
                return this.getRuntime().getNil();
            }
            val.append(buffer, 0, read2);
            this.position += (long)val.length();
            if (outbuf != null) {
                outbuf.view(val);
            }
            return this.newStr(this.getRuntime(), val);
        }

        private IRubyObject readAll() throws IOException {
            return this.readAll(-1);
        }

        private IRubyObject readAll(int limit2) throws IOException {
            int read2;
            ByteList val = this.newReadByteList(10);
            int rest2 = limit2 == -1 ? 4096 : limit2;
            byte[] buffer = new byte[rest2];
            while (rest2 > 0 && (read2 = this.bufferedStream.read(buffer, 0, rest2)) != -1) {
                val.append(buffer, 0, read2);
                if (limit2 == -1) continue;
                rest2 -= read2;
            }
            this.position += (long)val.length();
            return this.newStr(this.getRuntime(), val);
        }

        private IRubyObject readSize(int len) throws IOException {
            byte[] buffer = new byte[len];
            int toRead = len;
            int offset2 = 0;
            int read2 = 0;
            while (toRead > 0) {
                read2 = this.bufferedStream.read(buffer, offset2, toRead);
                if (read2 == -1) {
                    if (offset2 != 0) break;
                    return this.getRuntime().getNil();
                }
                toRead -= read2;
                offset2 += read2;
            }
            this.position += (long)buffer.length;
            return RubyString.newString(this.getRuntime(), new ByteList(buffer, 0, len - toRead, false));
        }

        @JRubyMethod(name={"lineno="}, required=1)
        public IRubyObject set_lineno(IRubyObject lineArg) {
            this.line = RubyNumeric.fix2int(lineArg);
            return lineArg;
        }

        @JRubyMethod(name={"pos", "tell"})
        public IRubyObject pos() {
            return RubyNumeric.int2fix(this.getRuntime(), this.position);
        }

        @JRubyMethod(name={"readchar"})
        public IRubyObject readchar() {
            try {
                int value2 = this.bufferedStream.read();
                if (value2 == -1) {
                    throw this.getRuntime().newEOFError();
                }
                ++this.position;
                return this.getRuntime().newFixnum(value2);
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"getc", "getbyte"}, compat=CompatVersion.RUBY1_8)
        public IRubyObject getc() {
            try {
                int value2 = this.bufferedStream.read();
                if (value2 == -1) {
                    return this.getRuntime().getNil();
                }
                ++this.position;
                return this.getRuntime().newFixnum(value2);
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"getbyte"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject getbyte() {
            return this.getc();
        }

        @JRubyMethod(name={"getc"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject getc_19() {
            try {
                int value2 = this.bufferedStream.read();
                if (value2 == -1) {
                    return this.getRuntime().getNil();
                }
                ++this.position;
                return this.getRuntime().newString("" + (char)(value2 & 0xFF));
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        private boolean isEof() throws IOException {
            if (this.bufferedStream.available() == 0) {
                return true;
            }
            this.bufferedStream.mark(16);
            this.bufferedStream.read();
            this.bufferedStream.reset();
            return this.bufferedStream.available() == 0;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() {
            if (!this.closed) {
                try {
                    this.bufferedStream.close();
                    if (this.realIo.respondsTo("close")) {
                        this.realIo.callMethod(this.realIo.getRuntime().getCurrentContext(), "close");
                    }
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            this.closed = true;
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"eof"})
        public IRubyObject eof() {
            try {
                return this.isEof() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        @JRubyMethod(name={"eof?"})
        public IRubyObject eof_p() {
            return this.eof();
        }

        @JRubyMethod
        public IRubyObject unused() {
            byte[] tmp = this.io.getAvailIn();
            if (tmp == null) {
                return this.getRuntime().getNil();
            }
            return RubyString.newString(this.getRuntime(), tmp);
        }

        @JRubyMethod
        public IRubyObject crc() {
            long crc2 = 0L;
            try {
                crc2 = this.io.getCRC();
            }
            catch (GZIPException gZIPException) {
                // empty catch block
            }
            return this.getRuntime().newFixnum(crc2);
        }

        @JRubyMethod
        public IRubyObject os_code() {
            int os = this.io.getOS();
            if (os == 255) {
                os = 11;
            }
            return this.getRuntime().newFixnum(os & 0xFF);
        }

        @JRubyMethod
        public IRubyObject orig_name() {
            String name2 = this.io.getName();
            this.nullFreeOrigName = this.getRuntime().newString(name2);
            return super.orig_name();
        }

        @JRubyMethod
        public IRubyObject comment() {
            String comment2 = this.io.getComment();
            this.nullFreeComment = this.getRuntime().newString(comment2);
            return super.comment();
        }

        @JRubyMethod(optional=1)
        public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
            ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
            if (args2.length > 0 && !args2[0].isNil()) {
                sep = args2[0].convertToString().getByteList();
            }
            try {
                IRubyObject result2 = this.internalSepGets(sep);
                while (!result2.isNil()) {
                    block.yield(context, result2);
                    result2 = this.internalSepGets(sep);
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(optional=1)
        public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
            return this.each(context, args2, block);
        }

        @JRubyMethod
        public IRubyObject ungetc(IRubyObject arg2) {
            return this.getRuntime().getNil();
        }

        @JRubyMethod(optional=1)
        public IRubyObject readlines(IRubyObject[] args2) {
            ArrayList<IRubyObject> array = new ArrayList<IRubyObject>();
            if (args2.length != 0 && args2[0].isNil()) {
                array.add(this.read(new IRubyObject[0]));
            } else {
                ByteList sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
                if (args2.length > 0) {
                    sep = args2[0].convertToString().getByteList();
                }
                try {
                    IRubyObject result2 = this.internalSepGets(sep);
                    while (!result2.isNil()) {
                        array.add(result2);
                        result2 = this.internalSepGets(sep);
                    }
                }
                catch (IOException ioe) {
                    throw this.getRuntime().newIOErrorFromException(ioe);
                }
            }
            return this.getRuntime().newArray(array);
        }

        @JRubyMethod
        public IRubyObject each_byte(ThreadContext context, Block block) {
            try {
                int value2 = this.bufferedStream.read();
                while (value2 != -1) {
                    ++this.position;
                    block.yield(context, this.getRuntime().newFixnum(value2));
                    value2 = this.bufferedStream.read();
                }
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            return this.getRuntime().getNil();
        }

        @JRubyClass(name={"Zlib::GzipReader::Error"}, parent="Zlib::GzipReader")
        public static class Error {
        }
    }

    @JRubyClass(name={"Zlib::GzipFile"})
    public static class RubyGzipFile
    extends RubyObject {
        protected static final ObjectAllocator GZIPFILE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new RubyGzipFile(runtime2, klass);
            }
        };
        protected boolean closed = false;
        protected boolean finished = false;
        protected byte osCode = (byte)-1;
        protected int level = -1;
        protected RubyString nullFreeOrigName;
        protected RubyString nullFreeComment;
        protected IRubyObject realIo;
        protected RubyTime mtime;
        protected Encoding readEncoding;
        protected Encoding writeEncoding;
        protected boolean sync = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static IRubyObject wrapBlock(ThreadContext context, RubyGzipFile instance, Block block) {
            if (block.isGiven()) {
                IRubyObject iRubyObject;
                block4: {
                    try {
                        iRubyObject = block.yield(context, instance);
                        Object var5_4 = null;
                        if (instance.isClosed()) break block4;
                        instance.close();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (!instance.isClosed()) {
                            instance.close();
                        }
                        throw throwable;
                    }
                }
                return iRubyObject;
            }
            return instance;
        }

        static IRubyObject[] argsWithIo(IRubyObject io2, IRubyObject[] args2) {
            ArrayList<IRubyObject> newArgs = new ArrayList<IRubyObject>();
            newArgs.add(io2);
            for (IRubyObject arg2 : args2) {
                if (arg2 == null) break;
                newArgs.add(arg2);
            }
            return newArgs.toArray(new IRubyObject[0]);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject wrap(ThreadContext context, IRubyObject recv2, IRubyObject io2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            RubyGzipFile instance = recv2 == runtime2.getModule("Zlib").getClass("GzipWriter") ? JZlibRubyGzipWriter.newInstance(recv2, new IRubyObject[]{io2}, block) : JZlibRubyGzipReader.newInstance(recv2, new IRubyObject[]{io2}, block);
            return RubyGzipFile.wrapBlock(context, instance, block);
        }

        @JRubyMethod(name={"new"}, meta=true)
        public static RubyGzipFile newInstance(IRubyObject recv2, Block block) {
            RubyClass klass = (RubyClass)recv2;
            RubyGzipFile result2 = (RubyGzipFile)klass.allocate();
            result2.callInit(new IRubyObject[0], block);
            return result2;
        }

        public RubyGzipFile(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            this.mtime = RubyTime.newTime(runtime2, new DateTime());
            this.readEncoding = runtime2.getDefaultExternalEncoding();
            this.writeEncoding = null;
        }

        protected RubyString newStr(Ruby runtime2, ByteList value2) {
            if (runtime2.is1_9()) {
                if (this.writeEncoding == null) {
                    return RubyString.newString(runtime2, value2, this.readEncoding);
                }
                return RubyString.newStringNoCopy(runtime2, RubyString.transcode(runtime2.getCurrentContext(), value2, this.readEncoding, this.writeEncoding, runtime2.getNil()));
            }
            return RubyString.newString(runtime2, value2);
        }

        @JRubyMethod(name={"os_code"})
        public IRubyObject os_code() {
            return this.getRuntime().newFixnum(this.osCode & 0xFF);
        }

        @JRubyMethod(name={"closed?"})
        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        protected boolean isClosed() {
            return this.closed;
        }

        @JRubyMethod(name={"orig_name"})
        public IRubyObject orig_name() {
            if (this.closed) {
                throw RubyZlib.newGzipFileError(this.getRuntime(), "closed gzip stream");
            }
            return this.nullFreeOrigName == null ? this.getRuntime().getNil() : this.nullFreeOrigName;
        }

        @JRubyMethod(name={"to_io"})
        public IRubyObject to_io() {
            return this.realIo;
        }

        @JRubyMethod(name={"comment"})
        public IRubyObject comment() {
            if (this.closed) {
                throw RubyZlib.newGzipFileError(this.getRuntime(), "closed gzip stream");
            }
            return this.nullFreeComment == null ? this.getRuntime().getNil() : this.nullFreeComment;
        }

        @JRubyMethod(name={"crc"})
        public IRubyObject crc() {
            return this.getRuntime().newFixnum(0);
        }

        @JRubyMethod(name={"mtime"})
        public IRubyObject mtime() {
            return this.mtime;
        }

        @JRubyMethod(name={"sync"})
        public IRubyObject sync() {
            return this.sync ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"finish"})
        public IRubyObject finish() {
            if (!this.finished) {
                // empty if block
            }
            this.finished = true;
            return this.realIo;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close() {
            return null;
        }

        @JRubyMethod(name={"level"})
        public IRubyObject level() {
            return this.getRuntime().newFixnum(this.level);
        }

        @JRubyMethod(name={"sync="}, required=1)
        public IRubyObject set_sync(IRubyObject arg2) {
            this.sync = ((RubyBoolean)arg2).isTrue();
            return this.sync ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyClass(name={"Zlib::GzipFile::LengthError"}, parent="Zlib::GzipFile::Error")
        public static class LengthError
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::NoFooter"}, parent="Zlib::GzipFile::Error")
        public static class NoFooter
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::CRCError"}, parent="Zlib::GzipFile::Error")
        public static class CRCError
        extends Error {
        }

        @JRubyClass(name={"Zlib::GzipFile::Error"}, parent="Zlib::Error")
        public static class Error {
        }
    }

    @JRubyClass(name={"Zlib::Deflate"}, parent="Zlib::ZStream")
    public static class JZlibDeflate
    extends ZStream {
        public static final int BASE_SIZE = 100;
        private int level;
        private int windowBits;
        private int strategy;
        private byte[] collected;
        private int collectedIdx;
        protected static final ObjectAllocator DEFLATE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new JZlibDeflate(runtime2, klass);
            }
        };
        private Deflater flater = null;
        private int flush = 0;

        @JRubyMethod(name={"deflate"}, required=1, optional=1, meta=true)
        public static IRubyObject s_deflate(IRubyObject recv2, IRubyObject[] args2) {
            Ruby runtime2 = recv2.getRuntime();
            args2 = Arity.scanArgs(runtime2, args2, 1, 1);
            int level2 = -1;
            if (!args2[1].isNil()) {
                level2 = RubyNumeric.fix2int(args2[1]);
                JZlibDeflate.checkLevel(runtime2, level2);
            }
            RubyClass klass = (RubyClass)recv2;
            JZlibDeflate deflate2 = (JZlibDeflate)klass.allocate();
            deflate2.init(level2, 15, 8, 0);
            try {
                IRubyObject result2 = deflate2.deflate(args2[0].convertToString().getByteList(), 4);
                deflate2.close();
                return result2;
            }
            catch (IOException ioe) {
                throw runtime2.newIOErrorFromException(ioe);
            }
        }

        public JZlibDeflate(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"initialize"}, optional=4, visibility=Visibility.PRIVATE)
        public IRubyObject _initialize(IRubyObject[] args2) {
            args2 = Arity.scanArgs(this.getRuntime(), args2, 0, 4);
            this.level = -1;
            this.windowBits = 15;
            int memlevel = 8;
            this.strategy = 0;
            if (!args2[0].isNil()) {
                this.level = RubyNumeric.fix2int(args2[0]);
                JZlibDeflate.checkLevel(this.getRuntime(), this.level);
            }
            if (!args2[1].isNil()) {
                this.windowBits = RubyNumeric.fix2int(args2[1]);
                JZlibDeflate.checkWindowBits(this.getRuntime(), this.windowBits, false);
            }
            if (!args2[2].isNil()) {
                memlevel = RubyNumeric.fix2int(args2[2]);
            }
            if (!args2[3].isNil()) {
                this.strategy = RubyNumeric.fix2int(args2[3]);
            }
            this.init(this.level, this.windowBits, memlevel, this.strategy);
            return this;
        }

        private void init(int level2, int windowBits, int memlevel, int strategy) {
            this.flush = 0;
            this.flater = new Deflater();
            int err = this.flater.init(level2, windowBits, memlevel);
            if (err == -2) {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
            err = this.flater.params(level2, strategy);
            if (err == -2) {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
            this.collected = new byte[100];
            this.collectedIdx = 0;
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize_copy(IRubyObject _other) {
            if (!(_other instanceof JZlibDeflate)) {
                throw this.getRuntime().newTypeError("Expecting an instance of class JZlibDeflate");
            }
            if (this == _other) {
                return this;
            }
            JZlibDeflate other = (JZlibDeflate)_other;
            this.level = other.level;
            this.windowBits = other.windowBits;
            this.strategy = other.strategy;
            this.collected = new byte[other.collected.length];
            System.arraycopy(other.collected, 0, this.collected, 0, other.collected.length);
            this.collectedIdx = other.collectedIdx;
            this.flush = other.flush;
            this.flater = new Deflater();
            int ret = this.flater.copy(other.flater);
            if (ret != 0) {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
            return this;
        }

        @JRubyMethod(name={"<<"}, required=1)
        public IRubyObject append(IRubyObject arg2) {
            this.checkClosed();
            try {
                this.append(arg2.convertToString().getByteList());
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
            return this;
        }

        @JRubyMethod(name={"params"}, required=2)
        public IRubyObject params(ThreadContext context, IRubyObject level2, IRubyObject strategy) {
            int err;
            int l = RubyNumeric.fix2int(level2);
            JZlibDeflate.checkLevel(this.getRuntime(), l);
            int s2 = RubyNumeric.fix2int(strategy);
            JZlibDeflate.checkStrategy(this.getRuntime(), s2);
            if (this.flater.next_out == null) {
                this.flater.setOutput(new byte[0]);
            }
            if ((err = this.flater.params(l, s2)) == -2) {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
            if (this.collectedIdx != this.flater.next_out_index) {
                this.collectedIdx = this.flater.next_out_index;
            }
            this.run();
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"set_dictionary"}, required=1)
        public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
            try {
                byte[] tmp = arg2.convertToString().getBytes();
                int err = this.flater.setDictionary(tmp, tmp.length);
                if (err == -2) {
                    throw RubyZlib.newStreamError(context.getRuntime(), "stream error: ");
                }
                this.run();
                return arg2;
            }
            catch (IllegalArgumentException iae) {
                throw RubyZlib.newStreamError(context.getRuntime(), "stream error: " + iae.getMessage());
            }
        }

        @JRubyMethod(name={"flush"}, optional=1)
        public IRubyObject flush(IRubyObject[] args2) {
            int flush2 = 2;
            if (args2.length == 1 && !args2[0].isNil()) {
                flush2 = RubyNumeric.fix2int(args2[0]);
            }
            return this.flush(flush2);
        }

        @JRubyMethod(name={"deflate"}, required=1, optional=1)
        public IRubyObject deflate(IRubyObject[] args2) {
            args2 = Arity.scanArgs(this.getRuntime(), args2, 1, 1);
            if (this.internalFinished()) {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
            ByteList data = null;
            if (!args2[0].isNil()) {
                data = args2[0].convertToString().getByteList();
            }
            int flush2 = 0;
            if (!args2[1].isNil()) {
                flush2 = RubyNumeric.fix2int(args2[1]);
            }
            try {
                return this.deflate(data, flush2);
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }

        protected int internalTotalIn() {
            return (int)this.flater.total_in;
        }

        protected int internalTotalOut() {
            return (int)this.flater.total_out;
        }

        protected boolean internalStreamEndP() {
            return this.flater.finished();
        }

        protected void internalReset() {
            this.init(this.level, this.windowBits, 8, this.strategy);
        }

        public boolean internalFinished() {
            return this.flater.finished();
        }

        protected long internalAdler() {
            return this.flater.getAdler();
        }

        protected IRubyObject internalFinish() {
            return this.finish();
        }

        protected void internalClose() {
            this.flater.end();
        }

        private void append(ByteList obj) throws IOException {
            this.flater.setInput(obj.getUnsafeBytes(), obj.getBegin(), obj.getRealSize(), true);
            this.run();
        }

        private IRubyObject flush(int flush2) {
            int last_flush = this.flush;
            this.flush = flush2;
            if (flush2 == 0) {
                return RubyString.newEmptyString(this.getRuntime());
            }
            this.run();
            this.flush = last_flush;
            RubyString obj = RubyString.newString(this.getRuntime(), this.collected, 0, this.collectedIdx);
            this.collectedIdx = 0;
            this.flater.setOutput(this.collected);
            return obj;
        }

        private IRubyObject deflate(ByteList str, int flush2) throws IOException {
            if (null != str) {
                this.append(str);
            }
            return this.flush(flush2);
        }

        private IRubyObject finish() {
            return this.flush(4);
        }

        private void run() {
            if (this.internalFinished()) {
                return;
            }
            while (!this.internalFinished()) {
                this.flater.setOutput(this.collected, this.collectedIdx, this.collected.length - this.collectedIdx);
                int err = this.flater.deflate(this.flush);
                switch (err) {
                    case -2: {
                        throw RubyZlib.newStreamError(this.getRuntime(), "stream error: ");
                    }
                }
                if (this.collectedIdx == this.flater.next_out_index) break;
                this.collectedIdx = this.flater.next_out_index;
                if (this.collected.length != this.collectedIdx || this.internalFinished()) continue;
                byte[] tmp = new byte[this.collected.length * 3];
                System.arraycopy(this.collected, 0, tmp, 0, this.collected.length);
                this.collected = tmp;
            }
        }
    }

    @JRubyClass(name={"Zlib::Inflate"}, parent="Zlib::ZStream")
    public static class JZlibInflate
    extends ZStream {
        public static final int BASE_SIZE = 100;
        private int windowBits;
        private byte[] collected;
        private int collectedIdx;
        private ByteList input;
        private Inflater flater = null;
        protected static final ObjectAllocator INFLATE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new JZlibInflate(runtime2, klass);
            }
        };

        public JZlibInflate(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JRubyMethod(name={"inflate"}, required=1, meta=true)
        public static IRubyObject s_inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
            void var7_7;
            RubyClass klass = (RubyClass)recv2;
            JZlibInflate inflate2 = (JZlibInflate)klass.allocate();
            inflate2.init(15);
            try {
                inflate2.append(string2.convertToString().getByteList());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                IRubyObject result2 = inflate2.finish(context);
                inflate2.close();
                throw throwable;
            }
            IRubyObject result2 = inflate2.finish(context);
            inflate2.close();
            return var7_7;
        }

        @JRubyMethod(name={"initialize"}, optional=1, visibility=Visibility.PRIVATE)
        public IRubyObject _initialize(IRubyObject[] args2) {
            this.windowBits = 15;
            if (args2.length > 0 && !args2[0].isNil()) {
                this.windowBits = RubyNumeric.fix2int(args2[0]);
                JZlibInflate.checkWindowBits(this.getRuntime(), this.windowBits, true);
            }
            this.init(this.windowBits);
            return this;
        }

        private void init(int windowBits) {
            this.flater = new Inflater();
            this.flater.init(windowBits);
            this.collected = new byte[100];
            this.collectedIdx = 0;
            this.input = new ByteList();
        }

        @JRubyMethod(name={"flush_next_out"})
        public IRubyObject flush_next_out(ThreadContext context) {
            return this.flushOutput(context.getRuntime());
        }

        private RubyString flushOutput(Ruby runtime2) {
            if (this.collectedIdx > 0) {
                RubyString res = RubyString.newString(runtime2, this.collected, 0, this.collectedIdx);
                this.collectedIdx = 0;
                this.flater.setOutput(this.collected);
                return res;
            }
            return RubyString.newEmptyString(runtime2);
        }

        @JRubyMethod(name={"<<"}, required=1)
        public IRubyObject append(ThreadContext context, IRubyObject arg2) {
            this.checkClosed();
            if (arg2.isNil()) {
                this.run(true);
            } else {
                this.append(arg2.convertToString().getByteList());
            }
            return this;
        }

        public void append(ByteList obj) {
            if (!this.internalFinished()) {
                this.flater.setInput(obj.bytes(), true);
            } else {
                this.input.append(obj);
            }
            this.run(false);
        }

        @JRubyMethod(name={"sync_point?"})
        public IRubyObject sync_point_p() {
            return this.sync_point();
        }

        public IRubyObject sync_point() {
            int ret = this.flater.syncPoint();
            switch (ret) {
                case 1: {
                    return this.getRuntime().getTrue();
                }
                case -3: {
                    throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
                }
            }
            return this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"set_dictionary"}, required=1)
        public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
            try {
                return this.set_dictionary(arg2);
            }
            catch (IllegalArgumentException iae) {
                throw RubyZlib.newStreamError(context.getRuntime(), "stream error: " + iae.getMessage());
            }
        }

        private IRubyObject set_dictionary(IRubyObject str) {
            byte[] tmp = str.convertToString().getBytes();
            int ret = this.flater.setDictionary(tmp, tmp.length);
            switch (ret) {
                case -2: {
                    throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
                }
                case -3: {
                    throw RubyZlib.newDataError(this.getRuntime(), "wrong dictionary");
                }
            }
            this.run(false);
            return str;
        }

        @JRubyMethod(name={"inflate"}, required=1)
        public IRubyObject inflate(ThreadContext context, IRubyObject string2) {
            ByteList data = null;
            if (!string2.isNil()) {
                data = string2.convertToString().getByteList();
            }
            return this.inflate(context, data);
        }

        public IRubyObject inflate(ThreadContext context, ByteList str) {
            if (null == str) {
                return this.internalFinish();
            }
            this.append(str);
            return this.flushOutput(context.getRuntime());
        }

        @JRubyMethod(name={"sync"}, required=1)
        public IRubyObject sync(ThreadContext context, IRubyObject string2) {
            if (this.flater.avail_in > 0) {
                switch (this.flater.sync()) {
                    case 0: {
                        this.flater.setInput(string2.convertToString().getByteList().bytes(), true);
                        return this.getRuntime().getTrue();
                    }
                    case -3: {
                        break;
                    }
                    default: {
                        throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
                    }
                }
            }
            if (string2.convertToString().getByteList().length() <= 0) {
                return this.getRuntime().getFalse();
            }
            this.flater.setInput(string2.convertToString().getByteList().bytes(), true);
            switch (this.flater.sync()) {
                case 0: {
                    return this.getRuntime().getTrue();
                }
                case -3: {
                    return this.getRuntime().getFalse();
                }
            }
            throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
        }

        private void run(boolean finish2) {
            int err;
            int resultLength = -1;
            Ruby runtime2 = this.getRuntime();
            while (!this.internalFinished() && resultLength != 0) {
                boolean needsInput;
                boolean bl = needsInput = this.flater.avail_in < 0;
                if (finish2 && needsInput) {
                    throw RubyZlib.newBufError(runtime2, "buffer error");
                }
                this.flater.setOutput(this.collected, this.collectedIdx, this.collected.length - this.collectedIdx);
                int ret = this.flater.inflate(0);
                resultLength = this.flater.next_out_index - this.collectedIdx;
                this.collectedIdx = this.flater.next_out_index;
                switch (ret) {
                    case -3: {
                        throw RubyZlib.newDataError(runtime2, this.flater.getMessage());
                    }
                    case 2: {
                        throw RubyZlib.newDictError(runtime2, "need dictionary");
                    }
                    case 1: {
                        if (this.flater.avail_in > 0) {
                            this.input.append(this.flater.next_in, this.flater.next_in_index, this.flater.avail_in);
                            this.flater.setInput("".getBytes());
                        }
                    }
                    case 0: {
                        resultLength = this.flater.next_out_index;
                        break;
                    }
                    default: {
                        resultLength = 0;
                    }
                }
                if (this.collected.length != this.collectedIdx || this.internalFinished()) continue;
                byte[] tmp = new byte[this.collected.length * 3];
                System.arraycopy(this.collected, 0, tmp, 0, this.collected.length);
                this.collected = tmp;
            }
            if (finish2 && !this.internalFinished() && (err = this.flater.inflate(4)) != 0) {
                throw RubyZlib.newBufError(this.getRuntime(), "buffer error");
            }
        }

        protected int internalTotalIn() {
            return (int)this.flater.total_in;
        }

        protected int internalTotalOut() {
            return (int)this.flater.total_out;
        }

        protected boolean internalStreamEndP() {
            return this.flater.finished();
        }

        protected void internalReset() {
            this.init(this.windowBits);
        }

        protected boolean internalFinished() {
            return this.flater.finished();
        }

        protected long internalAdler() {
            return this.flater.getAdler();
        }

        protected IRubyObject internalFinish() {
            this.run(true);
            if (this.internalFinished() && this.input.getRealSize() > 0) {
                if (this.collected.length - this.collectedIdx < this.input.length()) {
                    byte[] tmp = new byte[this.collected.length + this.input.length()];
                    System.arraycopy(this.collected, 0, tmp, 0, this.collectedIdx);
                    this.collected = tmp;
                }
                System.arraycopy(this.input.getUnsafeBytes(), this.input.begin(), this.collected, this.collectedIdx, this.input.length());
                this.collectedIdx += this.input.length();
                JZlibInflate.resetBuffer(this.input);
            }
            return this.flushOutput(this.getRuntime());
        }

        protected void internalClose() {
            this.flater.end();
        }

        public IRubyObject avail_in() {
            return this.getRuntime().newFixnum(this.flater.avail_in);
        }

        private static void resetBuffer(ByteList l) {
            l.setBegin(0);
            l.setRealSize(0);
            l.invalidate();
        }
    }

    @JRubyClass(name={"Zlib::ZStream"})
    public static abstract class ZStream
    extends RubyObject {
        protected boolean closed = false;

        protected abstract int internalTotalIn();

        protected abstract int internalTotalOut();

        protected abstract boolean internalStreamEndP();

        protected abstract void internalReset();

        protected abstract boolean internalFinished();

        protected abstract long internalAdler();

        protected abstract IRubyObject internalFinish();

        protected abstract void internalClose();

        public ZStream(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize(Block unusedBlock) {
            return this;
        }

        @JRubyMethod
        public IRubyObject flush_next_out(ThreadContext context) {
            return RubyString.newEmptyString(context.getRuntime());
        }

        @JRubyMethod
        public IRubyObject total_out() {
            this.checkClosed();
            return this.getRuntime().newFixnum(this.internalTotalOut());
        }

        @JRubyMethod(name={"stream_end?"})
        public IRubyObject stream_end_p() {
            return this.internalStreamEndP() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"data_type"})
        public IRubyObject data_type() {
            this.checkClosed();
            return this.getRuntime().getModule("Zlib").getConstant("UNKNOWN");
        }

        @JRubyMethod(name={"closed?", "ended?"})
        public IRubyObject closed_p() {
            return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod(name={"reset"})
        public IRubyObject reset() {
            this.checkClosed();
            this.internalReset();
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"avail_out"})
        public IRubyObject avail_out() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"avail_out="}, required=1)
        public IRubyObject set_avail_out(IRubyObject p1) {
            this.checkClosed();
            return p1;
        }

        @JRubyMethod(name={"adler"})
        public IRubyObject adler() {
            this.checkClosed();
            return this.getRuntime().newFixnum(this.internalAdler());
        }

        @JRubyMethod(name={"finish"})
        public IRubyObject finish(ThreadContext context) {
            this.checkClosed();
            IRubyObject result2 = this.internalFinish();
            return result2;
        }

        @JRubyMethod(name={"avail_in"})
        public IRubyObject avail_in() {
            return RubyFixnum.zero(this.getRuntime());
        }

        @JRubyMethod(name={"flush_next_in"})
        public IRubyObject flush_next_in(ThreadContext context) {
            return RubyString.newEmptyString(context.getRuntime());
        }

        @JRubyMethod(name={"total_in"})
        public IRubyObject total_in() {
            this.checkClosed();
            return this.getRuntime().newFixnum(this.internalTotalIn());
        }

        @JRubyMethod(name={"finished?"})
        public IRubyObject finished_p(ThreadContext context) {
            this.checkClosed();
            Ruby runtime2 = context.getRuntime();
            return this.internalFinished() ? runtime2.getTrue() : runtime2.getFalse();
        }

        @JRubyMethod(name={"close", "end"})
        public IRubyObject close() {
            this.checkClosed();
            this.internalClose();
            this.closed = true;
            return this.getRuntime().getNil();
        }

        void checkClosed() {
            if (this.closed) {
                throw RubyZlib.newZlibError(this.getRuntime(), "stream is not ready");
            }
        }

        static void checkLevel(Ruby runtime2, int level2) {
            if ((level2 < 0 || level2 > 9) && level2 != -1) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid level");
            }
        }

        static void checkWindowBits(Ruby runtime2, int wbits, boolean forInflate) {
            if (((wbits = Math.abs(wbits)) & 0xF) < 8) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid window bits");
            }
            if ((wbits & 0xF) != 15) {
                runtime2.getWarnings().warn("windowBits < 15 is ignored on this platform");
            }
            if (forInflate && wbits > 47) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid window bits");
            }
            if (!forInflate && wbits > 31) {
                throw RubyZlib.newStreamError(runtime2, "stream error: invalid window bits");
            }
        }

        static void checkStrategy(Ruby runtime2, int strategy) {
            switch (strategy) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw RubyZlib.newStreamError(runtime2, "stream error: invalid strategy");
                }
            }
        }
    }

    @JRubyClass(name={"Zlib::DataError"}, parent="Zlib::Error")
    public static class DataError
    extends Error {
    }

    @JRubyClass(name={"Zlib::VersionError"}, parent="Zlib::Error")
    public static class VersionError
    extends Error {
    }

    @JRubyClass(name={"Zlib::MemError"}, parent="Zlib::Error")
    public static class MemError
    extends Error {
    }

    @JRubyClass(name={"Zlib::NeedDict"}, parent="Zlib::Error")
    public static class NeedDict
    extends Error {
    }

    @JRubyClass(name={"Zlib::BufError"}, parent="Zlib::Error")
    public static class BufError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamError"}, parent="Zlib::Error")
    public static class StreamError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamEnd"}, parent="Zlib::Error")
    public static class StreamEnd
    extends Error {
    }

    @JRubyClass(name={"Zlib::Error"}, parent="StandardError")
    public static class Error {
    }
}

