/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashMap<V> {
    private transient Entry<V>[] table;
    private transient int count;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private int threshold;
    private final float loadFactor;
    private transient Set entrySet = null;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        Entry<V>[] tab = this.table;
        int i2 = tab.length;
        while (i2-- > 0) {
            Entry e = tab[i2];
            while (e != null) {
                if (e.value.equals(value2)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value2) {
        return this.contains(value2);
    }

    public boolean containsKey(int key2) {
        Entry<V>[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public V get(int key2) {
        Entry<V>[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry old = oldMap[i2];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index2];
                newMap[index2] = e;
            }
        }
    }

    Entry<V> getEntry(int key2) {
        Entry<V>[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public V put(int key2, V value2) {
        Entry<V>[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry<V> e = tab[index2];
        while (e != null) {
            if (e.hash == hash2) {
                Object old = e.value;
                e.value = value2;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        }
        e = new Entry<V>(hash2, key2, value2, tab[index2]);
        tab[index2] = e;
        ++this.count;
        return null;
    }

    public V remove(int key2) {
        Entry<V>[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index2];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash2) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index2] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry<V>[] tab = this.table;
        int index2 = tab.length;
        while (--index2 >= 0) {
            tab[index2] = null;
        }
        this.count = 0;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    public Set<Integer> keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection<V> values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<Entry> entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Entry> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry> iterator() {
            return IntHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = IntHashMap.this.getEntry(e.key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return IntHashMap.this.count;
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return IntHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return IntHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return IntHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return IntHashMap.this.count;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Number) {
                return IntHashMap.this.containsKey(((Number)o).intValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            IntHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().key;
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<V>
    implements Iterator<V> {
        Entry<V> next;
        int index;

        HashIterator() {
            Entry[] t = IntHashMap.this.table;
            int i2 = t.length;
            Entry n = null;
            if (IntHashMap.this.count != 0) {
                while (i2 > 0 && (n = t[--i2]) == null) {
                }
            }
            this.next = n;
            this.index = i2;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<V> nextEntry() {
            Entry<V> e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = e.next;
            Entry[] t = IntHashMap.this.table;
            int i2 = this.index;
            while (n == null && i2 > 0) {
                n = t[--i2];
            }
            this.index = i2;
            this.next = n;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        final int hash;
        final int key;
        V value;
        Entry next;

        protected Entry(int hash2, int key2, V value2, Entry next2) {
            this.hash = hash2;
            this.key = key2;
            this.value = value2;
            this.next = next2;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

