/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.DriverSpy;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;

public class Log4jdbcProxyDataSource
implements DataSource {
    private DataSource realDataSource;

    public Log4jdbcProxyDataSource(DataSource realDataSource) {
        this.realDataSource = realDataSource;
    }

    public SpyLogDelegator getLogFormatter() {
        return SpyLogFactory.getSpyLogDelegator();
    }

    public void setLogFormatter(SpyLogDelegator spyLogDelegator) {
        SpyLogFactory.setSpyLogDelegator(spyLogDelegator);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.realDataSource.getConnection();
        return new ConnectionSpy(connection, DriverSpy.getRdbmsSpecifics(connection));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.realDataSource.getConnection(username, password);
        return new ConnectionSpy(connection, DriverSpy.getRdbmsSpecifics(connection));
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.realDataSource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.realDataSource.getLogWriter();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.realDataSource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.realDataSource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.realDataSource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.realDataSource.unwrap(iface);
    }
}

