/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.mongo;

import com.mongodb.reactivestreams.client.MongoClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.SimpleReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
@ConditionalOnClass(value={MongoClient.class, ReactiveMongoTemplate.class})
@EnableConfigurationProperties(value={MongoProperties.class})
@AutoConfigureAfter(value={MongoReactiveAutoConfiguration.class, MongoDataAutoConfiguration.class})
public class MongoReactiveDataAutoConfiguration {
    private final MongoProperties properties;

    public MongoReactiveDataAutoConfiguration(MongoProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveMongoDatabaseFactory.class})
    public SimpleReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory(MongoClient mongo) {
        String database = this.properties.getMongoClientDatabase();
        return new SimpleReactiveMongoDatabaseFactory(mongo, database);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveMongoTemplate reactiveMongoTemplate(ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory, MongoConverter converter) {
        return new ReactiveMongoTemplate(reactiveMongoDatabaseFactory, converter);
    }
}

