/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDecoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class KotlinSerializationJsonDecoder
extends AbstractDecoder<Object> {
    private static final Map<Type, KSerializer<Object>> serializerCache = new ConcurrentReferenceHashMap();
    private final Json json;
    private final StringDecoder stringDecoder = StringDecoder.allMimeTypes((List)StringDecoder.DEFAULT_DELIMITERS, (boolean)false);

    public KotlinSerializationJsonDecoder() {
        this((Json)Json.Default);
    }

    public KotlinSerializationJsonDecoder(Json json) {
        super(new MimeType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
        this.json = json;
    }

    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return super.canDecode(elementType, mimeType) && !CharSequence.class.isAssignableFrom(elementType.toClass());
    }

    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.error((Throwable)new UnsupportedOperationException());
    }

    public Mono<Object> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return this.stringDecoder.decodeToMono(inputStream, elementType, mimeType, hints).map(jsonText -> this.json.decodeFromString(this.serializer(elementType.getType()), jsonText));
    }

    private KSerializer<Object> serializer(Type type) {
        KSerializer serializer = serializerCache.get(type);
        if (serializer == null) {
            serializer = SerializersKt.serializer((Type)type);
            serializerCache.put(type, (KSerializer<Object>)serializer);
        }
        return serializer;
    }
}

