/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.sax;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public abstract class SaxUtils {
    public static InputSource createInputSource(Resource resource) throws IOException {
        InputSource inputSource = new InputSource(resource.getInputStream());
        inputSource.setSystemId(SaxUtils.getSystemId(resource));
        return inputSource;
    }

    public static String getSystemId(Resource resource) {
        try {
            return new URI(resource.getURL().toExternalForm()).toString();
        }
        catch (IOException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

