/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.stream;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.springframework.xml.sax.AbstractXmlReader;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

@Deprecated
public abstract class AbstractStaxXmlReader
extends AbstractXmlReader {
    private static final String NAMESPACES_FEATURE_NAME = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_NAME = "http://xml.org/sax/features/namespace-prefixes";
    private static final String IS_STANDALONE_FEATURE_NAME = "http://xml.org/sax/features/is-standalone";
    private boolean namespacesFeature = true;
    private boolean namespacePrefixesFeature = false;
    private Boolean isStandalone;

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE_NAME.equals(name)) {
            return this.namespacesFeature;
        }
        if (NAMESPACE_PREFIXES_FEATURE_NAME.equals(name)) {
            return this.namespacePrefixesFeature;
        }
        if (IS_STANDALONE_FEATURE_NAME.equals(name)) {
            if (this.isStandalone != null) {
                return this.isStandalone;
            }
            throw new SAXNotSupportedException("startDocument() callback not completed yet");
        }
        return super.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE_NAME.equals(name)) {
            this.namespacesFeature = value;
        } else if (NAMESPACE_PREFIXES_FEATURE_NAME.equals(name)) {
            this.namespacePrefixesFeature = value;
        } else {
            super.setFeature(name, value);
        }
    }

    protected boolean hasNamespacesFeature() {
        return this.namespacesFeature;
    }

    protected boolean hasNamespacePrefixesFeature() {
        return this.namespacePrefixesFeature;
    }

    protected void setStandalone(boolean standalone) {
        this.isStandalone = standalone ? Boolean.TRUE : Boolean.FALSE;
    }

    public final void parse(InputSource ignored) throws SAXException {
        this.parse();
    }

    public final void parse(String ignored) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        try {
            this.parseInternal();
        }
        catch (XMLStreamException ex) {
            StaxLocator locator = null;
            if (ex.getLocation() != null) {
                locator = new StaxLocator(ex.getLocation());
            }
            SAXParseException saxException = new SAXParseException(ex.getMessage(), locator, ex);
            if (this.getErrorHandler() != null) {
                this.getErrorHandler().fatalError(saxException);
            }
            throw saxException;
        }
    }

    protected void setLocator(Location location) {
        if (this.getContentHandler() != null) {
            this.getContentHandler().setDocumentLocator(new StaxLocator(location));
        }
    }

    protected abstract void parseInternal() throws SAXException, XMLStreamException;

    private static class StaxLocator
    implements Locator {
        private Location location;

        protected StaxLocator(Location location) {
            this.location = location;
        }

        public String getPublicId() {
            return this.location.getPublicId();
        }

        public String getSystemId() {
            return this.location.getSystemId();
        }

        public int getLineNumber() {
            return this.location.getLineNumber();
        }

        public int getColumnNumber() {
            return this.location.getColumnNumber();
        }
    }
}

