/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.helpers;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;

public class InboundCookieParser {
    public static List<HttpCookie> parse(List<String> headerValues) {
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        for (String headerValue : headerValues) {
            result.addAll(InboundCookieParser.toHttpCookie(new CookieDecoder().decode(headerValue)));
        }
        return result;
    }

    private static List<HttpCookie> toHttpCookie(Set<Cookie> nettyCookies) {
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        for (Cookie n : nettyCookies) {
            HttpCookie cookie = new HttpCookie(n.getName(), n.getValue());
            cookie.setSecure(n.isSecure());
            cookie.setPath(n.getPath());
            cookie.setDomain(n.getDomain());
            long maxAge = n.getMaxAge() == Integer.MIN_VALUE ? -1L : (long)n.getMaxAge();
            cookie.setMaxAge(maxAge);
            cookie.setDiscard(n.isDiscard());
            cookie.setVersion(n.getVersion());
            result.add(cookie);
        }
        return result;
    }
}

