package pt.digitalis.dif.content.model;

import org.hibernate.Session;
import org.hibernate.cfg.Configuration;

import pt.digitalis.dif.model.hibernate.HibernateUtil;

/**
 * NOTE: This file is auto generated and will be overwritten in a future file generation.
 */
public class ContentManagerFactory {

	/** The session factory name. */
    public static String SESSION_FACTORY_NAME = "ContentManager";

    /**
     * Obtains the current session Configuration
     * 
     * @return the Configuration object
     */
    static public Configuration getConfiguration()
    {
        return HibernateUtil.getDatabaseConfiguration(SESSION_FACTORY_NAME, null);
    }

	/**
	 * Obtains the current session
	 *
	 * @return the session object
	 */
    static public Session getSession() 
    {
    	return HibernateUtil.getSessionFactory(SESSION_FACTORY_NAME).getCurrentSession();
    }
    
    /**
     * Sets the session factory name.
     * 
     * @param name
     *            the new session factory name
     */
    public static void setSessionFactoryName(String name)
    {
        SESSION_FACTORY_NAME = name;
    }
}