package pt.digitalis.dif.content.model.data;


import java.sql.Blob;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pt.digitalis.dif.model.utils.AbstractBeanAttributes;
import pt.digitalis.utils.common.DateUtils;

/**
 * ContentItem
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class ContentItem extends AbstractBeanAttributes implements java.io.Serializable {

    /** ContentItem attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** name column */
        public static final String NAME = "name";
        /** description column */
        public static final String DESCRIPTION = "description";
        /** creationDate column */
        public static final String CREATIONDATE = "creationDate";
        /** creatorId column */
        public static final String CREATORID = "creatorId";
        /** content column */
        public static final String CONTENT = "content";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");
            list.add("creationDate");
            list.add("creatorId");
            list.add("content");

            return list;
        }
    }

    /** ContentItem FK class */
    public static class FK {
        /** node relation */
        public static final String NODE = "node";
        /** contentItemAcls relation */
        public static final String CONTENTITEMACLS = "contentItemAcls";
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("node".equalsIgnoreCase(attributeName))
            return node;
        if ("name".equalsIgnoreCase(attributeName))
            return name;
        if ("description".equalsIgnoreCase(attributeName))
            return description;
        if ("creationDate".equalsIgnoreCase(attributeName))
            return creationDate;
        if ("creatorId".equalsIgnoreCase(attributeName))
            return creatorId;
        if ("content".equalsIgnoreCase(attributeName))
            return content;
        if ("contentItemAcls".equalsIgnoreCase(attributeName))
            return contentItemAcls;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (String)attributeValue;
        if ("node".equalsIgnoreCase(attributeName))
            node = (Node)attributeValue;
        if ("name".equalsIgnoreCase(attributeName))
            name = (String)attributeValue;
        if ("description".equalsIgnoreCase(attributeName))
            description = (String)attributeValue;
        if ("creationDate".equalsIgnoreCase(attributeName))
            creationDate = (Date)attributeValue;
        if ("creatorId".equalsIgnoreCase(attributeName))
            creatorId = (String)attributeValue;
        if ("content".equalsIgnoreCase(attributeName))
            content = (Blob)attributeValue;
        if ("contentItemAcls".equalsIgnoreCase(attributeName))
            contentItemAcls = (Set<ContentItemAcl>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private String id;

    /** node private attribute */
    private Node node;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** creationDate private attribute */
    private Date creationDate;

    /** creatorId private attribute */
    private String creatorId;

    /** content private attribute */
    private Blob content;

    /** contentItemAcls private attribute */
    private Set<ContentItemAcl> contentItemAcls = new HashSet<ContentItemAcl>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            if ("creationDate".equalsIgnoreCase(attributeName))
        	    return DateUtils.simpleDateToString((Date)value);
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public ContentItem() {
    }

	/** 
	 * minimal constructor
	 *
     * @param node
     * @param name
     * @param creationDate
     * @param creatorId
    }
	 */
    public ContentItem(Node node, String name, Date creationDate, String creatorId) {
        this.node = node;
        this.name = name;
        this.creationDate = creationDate;
        this.creatorId = creatorId;
    }

    /**
     * full constructor
	 *
     * @param node
     * @param name
     * @param description
     * @param creationDate
     * @param creatorId
     * @param content
     * @param contentItemAcls
     */
    public ContentItem(Node node, String name, String description, Date creationDate, String creatorId, Blob content, Set<ContentItemAcl> contentItemAcls) {
        this.node = node;
        this.name = name;
        this.description = description;
        this.creationDate = creationDate;
        this.creatorId = creatorId;
        this.content = content;
        this.contentItemAcls = contentItemAcls;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public String getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return ContentItem modified instance
     */
    public ContentItem setId(String id) {
        this.id = id;
        
        return this;
    }
    /**       
     * node getter method
     *
     * @return node method
     */
    public Node getNode() {
        return this.node;
    }
    
    /**       
     * node setter method
     *
     * @param node
     *
     * @return ContentItem modified instance
     */
    public ContentItem setNode(Node node) {
        this.node = node;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name
     *
     * @return ContentItem modified instance
     */
    public ContentItem setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description
     *
     * @return ContentItem modified instance
     */
    public ContentItem setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * creationDate getter method
     *
     * @return creationDate method
     */
    public Date getCreationDate() {
        return this.creationDate;
    }
    
    /**       
     * creationDate setter method
     *
     * @param creationDate
     *
     * @return ContentItem modified instance
     */
    public ContentItem setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        
        return this;
    }
    /**       
     * creatorId getter method
     *
     * @return creatorId method
     */
    public String getCreatorId() {
        return this.creatorId;
    }
    
    /**       
     * creatorId setter method
     *
     * @param creatorId
     *
     * @return ContentItem modified instance
     */
    public ContentItem setCreatorId(String creatorId) {
        this.creatorId = creatorId;
        
        return this;
    }
    /**       
     * content getter method
     *
     * @return content method
     */
    public Blob getContent() {
        return this.content;
    }
    
    /**       
     * content setter method
     *
     * @param content
     *
     * @return ContentItem modified instance
     */
    public ContentItem setContent(Blob content) {
        this.content = content;
        
        return this;
    }
    /**       
     * contentItemAcls getter method
     *
     * @return contentItemAcls method
     */
    public Set<ContentItemAcl> getContentItemAcls() {
        return this.contentItemAcls;
    }
    
    /**       
     * contentItemAcls setter method
     *
     * @param contentItemAcls
     *
     * @return ContentItem modified instance
     */
    public ContentItem setContentItemAcls(Set<ContentItemAcl> contentItemAcls) {
        this.contentItemAcls = contentItemAcls;
        
        return this;
    }

    /**
     * Creates a String representation of the ContentItem object
     *
     * @return the compiled String
     */
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("creationDate").append("='").append(getCreationDate()).append("' ");			
        buffer.append("creatorId").append("='").append(getCreatorId()).append("' ");			
        buffer.append("content").append("='").append(getContent()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the ContentItem object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(ContentItem other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
        	this.id = attributeValue;

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("creationDate".equalsIgnoreCase(attributeName))
	        try {
        	    this.creationDate = DateUtils.stringToSimpleDate(attributeValue);
	        } catch (ParseException e) {
	            // Do nothing. The value will not be set!
	        }

        if ("creatorId".equalsIgnoreCase(attributeName))
        	this.creatorId = attributeValue;

    }


}
