package pt.digitalis.dif.content.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.content.model.IDocumentsService;
import pt.digitalis.dif.content.model.dao.IContentItemDAO;
import pt.digitalis.dif.content.model.dao.impl.ContentItemDAOImpl;
import pt.digitalis.dif.content.model.data.ContentItem;
import pt.digitalis.dif.content.model.dao.IContentItemAclDAO;
import pt.digitalis.dif.content.model.dao.impl.ContentItemAclDAOImpl;
import pt.digitalis.dif.content.model.data.ContentItemAcl;
import pt.digitalis.dif.content.model.dao.INodeDAO;
import pt.digitalis.dif.content.model.dao.impl.NodeDAOImpl;
import pt.digitalis.dif.content.model.data.Node;
import pt.digitalis.dif.content.model.dao.INodeAclDAO;
import pt.digitalis.dif.content.model.dao.impl.NodeAclDAOImpl;
import pt.digitalis.dif.content.model.data.NodeAcl;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class DocumentsServiceImpl implements IDocumentsService {

	/**
	 * Obtains a new ContentItem DAO
	 *
	 * @return A new IContentItemDAO
	 */
    public IContentItemDAO getContentItemDAO() {
    	return new ContentItemDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ContentItem entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ContentItem> getContentItemDataSet() {
        return new HibernateDataSet<ContentItem>(ContentItem.class, new ContentItemDAOImpl(),
                ContentItem.getPKFieldListAsString());
    }

	/**
	 * Obtains a new ContentItemAcl DAO
	 *
	 * @return A new IContentItemAclDAO
	 */
    public IContentItemAclDAO getContentItemAclDAO() {
    	return new ContentItemAclDAOImpl();
    }

    /**
     * Obtains a new DataSet for the ContentItemAcl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ContentItemAcl> getContentItemAclDataSet() {
        return new HibernateDataSet<ContentItemAcl>(ContentItemAcl.class, new ContentItemAclDAOImpl(),
                ContentItemAcl.getPKFieldListAsString());
    }

	/**
	 * Obtains a new Node DAO
	 *
	 * @return A new INodeDAO
	 */
    public INodeDAO getNodeDAO() {
    	return new NodeDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Node entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Node> getNodeDataSet() {
        return new HibernateDataSet<Node>(Node.class, new NodeDAOImpl(),
                Node.getPKFieldListAsString());
    }

	/**
	 * Obtains a new NodeAcl DAO
	 *
	 * @return A new INodeAclDAO
	 */
    public INodeAclDAO getNodeAclDAO() {
    	return new NodeAclDAOImpl();
    }

    /**
     * Obtains a new DataSet for the NodeAcl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<NodeAcl> getNodeAclDataSet() {
        return new HibernateDataSet<NodeAcl>(NodeAcl.class, new NodeAclDAOImpl(),
                NodeAcl.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == ContentItem.class)
            return getContentItemDataSet();

        if (clazz == ContentItemAcl.class)
            return getContentItemAclDataSet();

        if (clazz == Node.class)
            return getNodeDataSet();

        if (clazz == NodeAcl.class)
            return getNodeAclDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(ContentItem.class.getSimpleName()))
            return getContentItemDataSet();

        if (entityName.equalsIgnoreCase(ContentItemAcl.class.getSimpleName()))
            return getContentItemAclDataSet();

        if (entityName.equalsIgnoreCase(Node.class.getSimpleName()))
            return getNodeDataSet();

        if (entityName.equalsIgnoreCase(NodeAcl.class.getSimpleName()))
            return getNodeAclDataSet();

        return null;
    }
}