DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'CMS'
  AND    TABLE_NAME = 'NODE';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
    'CREATE TABLE CMS.NODE ' ||
    '( ' ||
    '  ID             NUMBER(10) NOT NULL, ' ||
    '  NAME           VARCHAR2(80) NOT NULL, ' ||
    '  DESCRIPTION    VARCHAR2(200), ' ||
    '  CREATION_DATE  DATE DEFAULT SYSDATE NOT NULL, ' ||
    '  CREATOR_ID     VARCHAR2(50) NOT NULL, ' ||
    '  FULL_PATH      VARCHAR2(200), ' ||
    '  PARENT_NODE_ID NUMBER(10), ' ||
    '  IS_PUBLIC      CHAR(1) NOT NULL ' ||
    ') ';     
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'NODE'
  AND    CONSTRAINT_NAME = 'NODE_PK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.NODE ADD CONSTRAINT NODE_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'NODE'
  AND    CONSTRAINT_NAME = 'FULL_PATH_UK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.NODE ADD CONSTRAINT FULL_PATH_UK UNIQUE (FULL_PATH)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'NODE'
  AND    CONSTRAINT_NAME = 'NODE_IS_PUBLIC_CK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.NODE ADD CONSTRAINT NODE_IS_PUBLIC_CK CHECK (IS_PUBLIC IN(''S'',''N''))';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'CMS'
  AND    INDEX_NAME      = 'IDX_NODE_DESCRIPTION';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX CMS.IDX_NODE_DESCRIPTION ON CMS.NODE (DESCRIPTION)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'CMS'
  AND    INDEX_NAME      = 'IDX_NODE_NAME';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX CMS.IDX_NODE_NAME ON CMS.NODE (NAME)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'CMS'
  AND    TABLE_NAME = 'CONTENT_ITEM';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
    'CREATE TABLE CMS.CONTENT_ITEM ' ||
    '( ' ||
    '  ID             VARCHAR2(4000) NOT NULL, ' ||
    '  NAME           VARCHAR2(80) NOT NULL, ' ||
    '  DESCRIPTION    VARCHAR2(200), ' ||
    '  CREATION_DATE  DATE DEFAULT SYSDATE NOT NULL, ' ||
    '  CREATOR_ID     VARCHAR2(50) NOT NULL, ' ||
    '  PARENT_NODE_ID NUMBER(10) NOT NULL, ' ||
    '  CONTENT        BLOB ' ||
    ')';   
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'CONTENT_ITEM'
  AND    CONSTRAINT_NAME = 'CONTENT_ITEM_PK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.CONTENT_ITEM ADD CONSTRAINT CONTENT_ITEM_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'CONTENT_ITEM'
  AND    CONSTRAINT_NAME = 'NAME_PARENTNODE_UK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.CONTENT_ITEM ADD CONSTRAINT NAME_PARENTNODE_UK UNIQUE (NAME, PARENT_NODE_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'CONTENT_ITEM'
  AND    CONSTRAINT_NAME = 'FK_NODE_CONTENT_ITEM';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.CONTENT_ITEM ADD CONSTRAINT FK_NODE_CONTENT_ITEM FOREIGN KEY (PARENT_NODE_ID) REFERENCES CMS.NODE (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'CMS'
  AND    INDEX_NAME      = 'IDX_CONTENT_ITEM_DESCRIPTION';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX CMS.IDX_CONTENT_ITEM_DESCRIPTION ON CMS.CONTENT_ITEM (DESCRIPTION)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'CMS'
  AND    INDEX_NAME      = 'IDX_CONTENT_ITEM_NAME';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX CMS.IDX_CONTENT_ITEM_NAME ON CMS.CONTENT_ITEM (NAME)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'CMS'
  AND    TABLE_NAME = 'CONTENT_ITEM_ACL';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
    'CREATE TABLE CMS.CONTENT_ITEM_ACL ' ||
    '( ' ||
    '  ID              NUMBER(10) NOT NULL, ' ||
    '  CONTENT_ITEM_ID VARCHAR2(4000) NOT NULL, ' ||
    '  USER_ID         VARCHAR2(50), ' ||
    '  GROUP_ID        VARCHAR2(50) ' ||
    ') ';   
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'CONTENT_ITEM_ACL'
  AND    CONSTRAINT_NAME = 'CONTENT_ITEM_ACL_PK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.CONTENT_ITEM_ACL ADD CONSTRAINT CONTENT_ITEM_ACL_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'CONTENT_ITEM_ACL'
  AND    CONSTRAINT_NAME = 'CONTENT_ITEM_FK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.CONTENT_ITEM_ACL ADD CONSTRAINT CONTENT_ITEM_FK FOREIGN KEY (CONTENT_ITEM_ID) REFERENCES CMS.CONTENT_ITEM (ID) ON DELETE CASCADE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'CMS'
  AND    INDEX_NAME      = 'CONTENT_USER_GROUP_UK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE UNIQUE INDEX CMS.CONTENT_USER_GROUP_UK ON CMS.CONTENT_ITEM_ACL (CONTENT_ITEM_ID, USER_ID, GROUP_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'CMS'
  AND    INDEX_NAME      = 'IDX_CIA_CONTENT_ITEM_ID';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX CMS.IDX_CIA_CONTENT_ITEM_ID ON CMS.CONTENT_ITEM_ACL (CONTENT_ITEM_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'CMS'
  AND    TABLE_NAME = 'NODE_ACL';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
    'CREATE TABLE CMS.NODE_ACL ' ||
    '( ' ||
    '  ID       NUMBER(10) NOT NULL, ' ||
    '  NODE_ID  NUMBER(10) NOT NULL, ' ||
    '  USER_ID  VARCHAR2(50), ' ||
    '  GROUP_ID VARCHAR2(50) ' ||
    ')'; 
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'NODE_ACL'
  AND    CONSTRAINT_NAME = 'NODE_ACL_PK';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.NODE_ACL ADD CONSTRAINT NODE_ACL_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'CMS'
  AND    TABLE_NAME      = 'NODE_ACL'
  AND    CONSTRAINT_NAME = 'FK_NODE_ACL_NODE';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.NODE_ACL ADD CONSTRAINT FK_NODE_ACL_NODE FOREIGN KEY (NODE_ID) REFERENCES CMS.NODE (ID) ON DELETE CASCADE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER           = 'CMS'
  AND    INDEX_NAME      = 'IDX_NODE_ACL_NODE_ID';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX CMS.IDX_NODE_ACL_NODE_ID ON CMS.NODE_ACL (NODE_ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS
  WHERE  OWNER       = 'CMS'
  AND    TABLE_NAME  = 'CONTENT_ITEM'
  AND    COLUMN_NAME = 'NAME'
  AND    DATA_LENGTH = 160;
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.CONTENT_ITEM MODIFY NAME VARCHAR2(160)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS
  WHERE  OWNER       = 'CMS'
  AND    TABLE_NAME  = 'NODE'
  AND    COLUMN_NAME = 'NAME'
  AND    DATA_LENGTH = 160;
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE CMS.NODE MODIFY NAME VARCHAR2(160)';
  END IF;
END;
/
