/**
 * - Digitalis Internal Framework v2.0 - (C) 2008, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.content.ioc;

import pt.digitalis.dif.content.ContentManagerDBImpl;
import pt.digitalis.dif.content.ContentManagerDBModelManager;
import pt.digitalis.dif.controller.interfaces.IModelManager;
import pt.digitalis.dif.utils.extensions.cms.IContentManager;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Application Module.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitlais.pt">pviegas@digitalis.pt</a>
 */
public class ContentManagerModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {
        binder.bind(IContentManager.class, ContentManagerDBImpl.class).asSingleton();
        binder.bind(IModelManager.class, ContentManagerDBModelManager.class)
                .withId(ContentManagerDBModelManager.MODEL_ID);
    }
}
