/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.content.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.content.model.dao.auto.IAutoNodeDAO;
import pt.digitalis.dif.content.model.data.Node;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoNodeDAOImpl
implements IAutoNodeDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Node> getNodeDataSet() {
        return new HibernateDataSet(Node.class, (IHibernateDAO)this, Node.getPKFieldListAsString());
    }

    public Session getSession() {
        return ContentManagerFactory.getSession();
    }

    @Override
    public void persist(Node transientInstance) {
        this.logger.debug((Object)"persisting Node instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Node instance) {
        this.logger.debug((Object)"attaching dirty Node instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Node instance) {
        this.logger.debug((Object)"attaching clean Node instance");
        this.getSession().lock((Object)instance, LockMode.NONE);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Node persistentInstance) {
        this.logger.debug((Object)"deleting Node instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Node merge(Node detachedInstance) {
        this.logger.debug((Object)"merging Node instance");
        Node result = (Node)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Node findById(Long id) {
        this.logger.debug((Object)("getting Node instance with id: " + id));
        Node instance = (Node)this.getSession().get(Node.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Node> findAll() {
        List<Node> instances = new ArrayList();
        this.logger.debug((Object)"getting all Node instances");
        instances = this.getSession().createCriteria(Node.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Node> findByExample(Node instance) {
        this.logger.debug((Object)"finding Node instance by example");
        List results = this.getSession().createCriteria(Node.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Node> findByFieldParcial(Node.Fields field, String value) {
        this.logger.debug((Object)("finding Node instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Node.class).add((Criterion)Expression.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Node> findByName(String name) {
        Node instance = new Node();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<Node> findByDescription(String description) {
        Node instance = new Node();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Node> findByCreationDate(Date creationDate) {
        Node instance = new Node();
        instance.setCreationDate(creationDate);
        return this.findByExample(instance);
    }

    @Override
    public List<Node> findByCreatorId(String creatorId) {
        Node instance = new Node();
        instance.setCreatorId(creatorId);
        return this.findByExample(instance);
    }

    @Override
    public List<Node> findByFullPath(String fullPath) {
        Node instance = new Node();
        instance.setFullPath(fullPath);
        return this.findByExample(instance);
    }

    @Override
    public List<Node> findByParentNodeId(Long parentNodeId) {
        Node instance = new Node();
        instance.setParentNodeId(parentNodeId);
        return this.findByExample(instance);
    }

    @Override
    public List<Node> findByIsPublic(Character isPublic) {
        Node instance = new Node();
        instance.setIsPublic(isPublic);
        return this.findByExample(instance);
    }
}

