package pt.digitalis.dif.dataintegration.events;

import pt.digitalis.dif.dataintegration.DataIntegrationManager;
import pt.digitalis.dif.dataintegration.events.publishers.DISetEventCategory;
import pt.digitalis.dif.dataintegration.events.publishers.DISetEventPublisher;
import pt.digitalis.dif.dem.managers.impl.model.IDataIntegrationService;
import pt.digitalis.dif.dem.managers.impl.model.data.DataIntegrationSet;
import pt.digitalis.dif.dem.managers.impl.model.data.Event;
import pt.digitalis.dif.dem.managers.impl.model.data.EventSubscription;
import pt.digitalis.dif.events.exceptions.EventException;
import pt.digitalis.dif.events.impl.EventsManager;
import pt.digitalis.dif.events.impl.subscriber.AbstractEventSubscriber;
import pt.digitalis.dif.events.model.BusinessCategory;
import pt.digitalis.dif.events.model.EventResult;
import pt.digitalis.dif.events.model.EventState;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.presentation.views.jsp.taglibs.TagLibUtils;

/**
 * The type Abstract data integrator event subscriber.
 */
public abstract class AbstractDataIntegratorEventSubscriber<T extends Object> extends AbstractEventSubscriber
{
    /** The Data integration service. */
    protected IDataIntegrationService dataIntegrationService =
            DIFIoCRegistry.getRegistry().getImplementation(IDataIntegrationService.class);

    /**
     * Async process dataset.
     *
     * @param category the category
     * @param dataset  the dataset
     *
     * @return the string
     *
     * @exception Exception the exception
     */
    public abstract String asyncProcessDISet(BusinessCategory category, DataIntegrationSet dataset) throws Exception;

    /**
     * Data set to integrate di data set.
     *
     * @param event        the event
     * @param subscription the subscription
     *
     * @return the di data set
     *
     * @exception Exception the exception
     */
    protected abstract T dataIntegrationSetToIntegrate(Event event, EventSubscription subscription) throws Exception;

    @Override
    protected EventResult internalProcessEvent(Event event, EventSubscription subscription) throws Exception
    {
        T businessObject = this.dataIntegrationSetToIntegrate(event, subscription);

        String processId = event.getPublisherId() + ":" + event.getCategoryId() + ":" + this.getID();

        DataIntegrationSet dis =
                DataIntegrationManager.insertDataIntegrationSet(processId, event.getBusinessId(), businessObject);

        this.syncProcessDISet(event, subscription, dis);

        EventResult<String> result = new EventResult<String>();

        String stageLink =
                TagLibUtils.getStageLinkWithParameters("DataIntegrationManagerStage", "&filtersSetId=" + dis.getId());
        String link = TagLibUtils
                .getLink(stageLink, "filtersSetId=" + dis.getId(), " click here.", "DataIntegrationManagerStage", "",
                        "", "_blank", false);

        result.setBusinessResult(
                "Data from " + businessObject.getClass().getSimpleName() + " with Id " + event.getBusinessId() +
                " has been integrated. For more information," + link);
        result.setState(EventState.SUCCESS);

        return result;
    }

    /**
     * Sync process dataset.
     *
     * @param event              the event
     * @param subscription       the subscription
     * @param dataIntegrationSet the data integration set
     *
     * @exception EventException the event exception
     */
    protected void syncProcessDISet(Event event, EventSubscription subscription, DataIntegrationSet dataIntegrationSet)
            throws EventException
    {
        EventsManager.getInstance().getPublisherByID(DISetEventPublisher.class.getSimpleName())
                .publishEvent(DISetEventCategory.DI_SET_AVAILABLE.getId(), dataIntegrationSet.getId().toString(),
                        event.getUserIdThatTriggeredEvent(), false);
    }
}
