package pt.digitalis.dif.dataintegration.events.publishers;

import pt.digitalis.dif.events.model.BusinessCategory;

/**
 * The enum Data integration dataset event category.
 */
public enum DISetEventCategory
{
    /** New data set available for processing. */
    DI_SET_AVAILABLE;

    /**
     * Gets business category representation.
     *
     * @return the business category representation
     */
    public BusinessCategory getBusinessCategoryRepresentation()
    {
        return new BusinessCategory(this.getId(), this.getDescription());
    }

    /**
     * Gets description.
     *
     * @return the description
     */
    public String getDescription()
    {
        return "Data Integration Set Available";
    }

    /**
     * Gets id.
     *
     * @return the id
     */
    public String getId()
    {
        return this.name();
    }
}
