/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.translator;

import java.util.HashMap;

/**
 * An abstract base implementation for Translation Dictionary
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Dec 16, 2009
 */
public class FieldsDictionary {

    /**  */
    private HashMap<String, FieldDictionaryEntries> fieldDictionariesEntries = new HashMap<String, FieldDictionaryEntries>();

    /**
     * Return value
     *
     * @param fieldName
     * @param originalValue
     * @return the value
     */
    public String getValue(String fieldName, String originalValue)
    {
        String result = null;
        FieldDictionaryEntries dictionaryEntries = this.fieldDictionariesEntries.get(fieldName);
        if (dictionaryEntries != null)
        {
            result = dictionaryEntries.getValue(originalValue);
        }

        return result;

    }

    /**
     * Checks the dictionary existence for a field
     *
     * @param fieldName
     * @return <code>true</code> if a dictionary exists for the field
     */
    public Boolean fieldHasDictionary(String fieldName)
    {
        return fieldDictionariesEntries.containsKey(fieldName);
    }

    /**
     * Adds a new field to the dictionary
     *
     * @param fieldName
     *            the original field name
     * @param entries
     *            the translaction entries
     */
    public void addFieldTodictionary(String fieldName, FieldDictionaryEntries entries)
    {
        fieldDictionariesEntries.put(fieldName, entries);
    }
}
