/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.translator;

import java.util.HashMap;

/**
 * Defines the exporter functionality
 *
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @param <T>
 *            the export output format
 * @created Dec 16, 2009
 */
public interface ITranslatorExporter<T extends Object> {
    /**
     * Process all field values
     *
     * @param values
     *            the values
     */
    public void processValues(HashMap<String, String> values);

    /**
     * Export Initialization actions.
     * @param translatorMappings the translator mappings
     */
    public void init(TranslatorMappings translatorMappings);

    /**
     * Export Finalization actions and return the builded object
     *
     * @return the result object
     */
    public T getResult() ;

    /**
     * Export Finalize actions.
     */
    public void terminate();
}
