/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.documents.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.documents.model.DocumentsFactory;
import pt.digitalis.dif.documents.model.dao.auto.IDocumentsDAO;
import pt.digitalis.dif.documents.model.data.Documents;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class DocumentsDAOImpl
implements IDocumentsDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Documents> getDocumentsDataSet() {
        return new HibernateDataSet(Documents.class, (IHibernateDAO)this, Documents.getPKFieldListAsString());
    }

    public Session getSession() {
        return DocumentsFactory.getSession();
    }

    @Override
    public void persist(Documents transientInstance) {
        this.logger.debug((Object)"persisting Documents instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Documents instance) {
        this.logger.debug((Object)"attaching dirty Documents instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Documents instance) {
        this.logger.debug((Object)"attaching clean Documents instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Documents persistentInstance) {
        this.logger.debug((Object)"deleting Documents instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Documents merge(Documents detachedInstance) {
        this.logger.debug((Object)"merging Documents instance");
        Documents result = (Documents)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Documents findById(Long id) {
        this.logger.debug((Object)("getting Documents instance with id: " + id));
        Documents instance = (Documents)this.getSession().get(Documents.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Documents> findAll() {
        List<Documents> instances = new ArrayList();
        this.logger.debug((Object)"getting all Documents instances");
        instances = this.getSession().createCriteria(Documents.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Documents> findByExample(Documents instance) {
        this.logger.debug((Object)"finding Documents instance by example");
        List results = this.getSession().createCriteria(Documents.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Documents> findByFieldParcial(Documents.Fields field, String value) {
        this.logger.debug((Object)("finding Documents instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Documents.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

