/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.identity.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pt.digitalis.dif.controller.security.managers.impl.AbstractIdentityManager;
import pt.digitalis.dif.controller.security.objects.DIFGroupImpl;
import pt.digitalis.dif.controller.security.objects.DIFUserImpl;
import pt.digitalis.dif.controller.security.objects.IDIFGroup;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.managers.impl.model.IIdentityService;
import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.dem.managers.impl.model.data.UserAttributes;
import pt.digitalis.dif.dem.managers.impl.model.data.UserGroups;
import pt.digitalis.dif.dem.managers.impl.model.data.Users;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.identity.repository.IdentityManagerDBException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.ConditionOperator;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterSet;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.utils.Pagination;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.crypto.IEncryptor;
import pt.digitalis.utils.crypto.exeption.CryptoException;
import pt.digitalis.utils.crypto.impl.EncryptorBase64Impl;

public class IdentityManagerDBImpl
extends AbstractIdentityManager {
    public static final String NAME = "Database";
    private static final char[] hideInPlainSight = new char[]{'a', 's', 'd', 'a', 'a', 's', 'd', 'f', '8', 's', 'a', 'd', '9', 'f', '8', '7', 'a', 's'};
    private static final String variableToReturn = new String(hideInPlainSight);
    private static IEncryptor encryptor = null;
    IIdentityService identityService = (IIdentityService)DIFIoCRegistry.getRegistry().getImplementation(IIdentityService.class);

    public void addGroup(IDIFGroup newGroup) throws IdentityManagerException {
        Groups group = this.convertFromDIFGroupToDBGroup(newGroup);
        try {
            this.identityService.getGroupsDataSet().insert((IBeanAttributes)group);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public void addUser(IDIFUser newUser) throws IdentityManagerException {
        if (((DIFUserImpl)newUser).getPassword() == null) {
            newUser.setPassword("password");
        }
        Users dbUser = this.convertFromDIFUserToDBUser(newUser);
        try {
            dbUser = (Users)this.identityService.getUsersDataSet().insert((IBeanAttributes)dbUser);
            this.processFromDIFUserToDBUserAttributes(newUser, dbUser);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public void addUserToGroup(String userID, String groupID) throws IdentityManagerException {
        try {
            Users user = (Users)this.identityService.getUsersDataSet().get(userID);
            Groups group = (Groups)this.identityService.getGroupsDataSet().get(groupID);
            UserGroups userGroups = new UserGroups();
            userGroups.setGroups(group);
            userGroups.setUsers(user);
            this.identityService.getUserGroupsDataSet().insert((IBeanAttributes)userGroups);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    protected FilterSet<?> applyEqualsOrLike(FilterSet<?> filterSet, String field, String value) throws DataSetException {
        boolean equals = true;
        if (StringUtils.isNotBlank((String)value) && (value.contains("*") || value.contains("%"))) {
            equals = !(value = value.replaceAll("\\*", "%")).contains("%");
        }
        filterSet = equals ? filterSet.equals(field, value) : filterSet.like(field, value);
        return filterSet;
    }

    public void changePassword(String userID, String newPassword) throws IdentityManagerException {
        try {
            Users user = (Users)this.identityService.getUsersDataSet().get(userID);
            user.setPassword(this.getEncryptator().encrypt(newPassword));
            this.identityService.getUsersDataSet().update((IBeanAttributes)user);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
        catch (CryptoException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    private IDIFGroup convertFromDBGroupToDIFGroup(Groups dbGroup) throws IdentityManagerException {
        DIFGroupImpl difGroup = null;
        if (dbGroup != null) {
            difGroup = new DIFGroupImpl();
            difGroup.setID(dbGroup.getId());
            if (dbGroup.getName() != null) {
                difGroup.setName(dbGroup.getName());
            }
            difGroup.setParentGroupID("N/A");
            if (dbGroup.getGroups() != null) {
                difGroup.setParentGroupID(dbGroup.getGroups().getId());
            }
            if (dbGroup.getDescription() != null) {
                difGroup.setDescription(dbGroup.getDescription());
            }
        }
        return difGroup;
    }

    private IDIFUser convertFromDBUserToDIFUser(Users dbUser) throws IdentityManagerException {
        DIFUserImpl difUser = null;
        if (dbUser != null) {
            difUser = new DIFUserImpl();
            if (dbUser.getId() != null) {
                difUser.setID(dbUser.getId());
            }
            if (dbUser.getGroups() != null) {
                difUser.setProfileID(dbUser.getGroups().getId());
            }
            if (dbUser.getId() != null) {
                difUser.setNick(dbUser.getId());
            }
            if (dbUser.getName() != null) {
                difUser.setName(dbUser.getName());
            }
            if (dbUser.getPassword() != null) {
                try {
                    difUser.setPassword(this.getEncryptator().decrypt(dbUser.getPassword()));
                }
                catch (CryptoException e1) {
                    throw new IdentityManagerDBException((Exception)((Object)e1));
                }
            }
            if (dbUser.getEmail() != null) {
                difUser.setEmail(dbUser.getEmail());
            }
            difUser.setDefault(dbUser.isDefaultUser());
            difUser.setEnabled(dbUser.isEnabled());
            Query queryUserAttributes = this.identityService.getUserAttributesDataSet().query();
            try {
                queryUserAttributes.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id".toString())), FilterType.EQUALS, dbUser.getId()));
                List userAttributes = queryUserAttributes.asList();
                CaseInsensitiveHashMap difAttributes = new CaseInsensitiveHashMap();
                for (UserAttributes attrib : userAttributes) {
                    difAttributes.put(attrib.getAttributeKey(), (Object)attrib.getAttributeValue());
                }
                difUser.initializeAttributes((Map)difAttributes);
            }
            catch (DataSetException e) {
                throw new IdentityManagerDBException((Exception)((Object)e));
            }
        }
        return difUser;
    }

    private Groups convertFromDIFGroupToDBGroup(IDIFGroup difGroup) throws IdentityManagerException {
        Groups dbGroup = new Groups();
        if (difGroup.getID() == null) {
            throw new IdentityManagerException("Group has no ID!");
        }
        dbGroup.setId(difGroup.getID());
        if (difGroup.getName() != null) {
            dbGroup.setName(difGroup.getName());
        } else {
            dbGroup.setName(difGroup.getID());
        }
        if (difGroup.getParentGroupID() != null) {
            dbGroup.setGroups(this.getParentGroupDNFromProfileID(difGroup.getParentGroupID()));
        }
        if (difGroup.getDescription() != null) {
            dbGroup.setDescription(difGroup.getDescription());
        }
        dbGroup.setDefaultGroup(difGroup.isDefault());
        return dbGroup;
    }

    private Users convertFromDIFUserToDBUser(IDIFUser difUser) throws IdentityManagerException {
        Users dbUser = null;
        if (difUser.getID() != null) {
            try {
                dbUser = (Users)this.identityService.getUsersDataSet().get(difUser.getID());
            }
            catch (DataSetException e) {
                throw new IdentityManagerDBException((Exception)((Object)e));
            }
            if (dbUser == null) {
                dbUser = new Users();
                dbUser.setId(difUser.getID());
            }
        } else {
            throw new IdentityManagerDBException("User has no ID!");
        }
        dbUser.setName(difUser.getName());
        if (difUser.getProfileID() != null) {
            dbUser.setGroups(this.getParentGroupDNFromProfileID(difUser.getProfileID()));
        }
        if (difUser.getNick() != null) {
            dbUser.setNick(difUser.getNick());
        }
        if (difUser.getName() != null) {
            dbUser.setName(difUser.getName());
        }
        try {
            if (((DIFUserImpl)difUser).getPassword() != null) {
                dbUser.setPassword(this.getEncryptator().encrypt(((DIFUserImpl)difUser).getPassword()));
            }
        }
        catch (CryptoException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
        if (difUser.getEmail() != null) {
            dbUser.setEmail(difUser.getEmail());
        }
        dbUser.setDefaultUser(difUser.isDefault());
        dbUser.setEnabled(difUser.isEnabled());
        return dbUser;
    }

    public int countAllGroups() throws IdentityManagerException {
        try {
            return (int)this.identityService.getGroupsDataSet().query().count();
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public int countAllGroupsOfUser(String userId) throws IdentityManagerException {
        try {
            int result = 0;
            IDIFUser user = this.getUser(userId);
            if (user.getProfileID() != null) {
                ++result;
            }
            Query query = this.identityService.getUserGroupsDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")), FilterType.EQUALS, userId));
            return result += (int)query.count();
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public int countAllUsers() throws IdentityManagerException {
        try {
            return (int)this.identityService.getUsersDataSet().query().count();
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public int countAllUsers(String groupId) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUserGroupsDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id")), FilterType.EQUALS, groupId));
            return (int)query.count();
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public int countUsers(Map<String, String> attributes) throws IdentityManagerException {
        try {
            Query<Users> query = this.getQueryUsersByAllAttributes(attributes, null);
            return (int)query.count();
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public List<String> gatherManagedAttributes() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Query query = this.identityService.getUserAttributesDataSet().query();
            query.addField("attributeKey".toString());
            query.setDistinct(true);
            for (UserAttributes userAttribute : query.asList()) {
                result.add(userAttribute.getAttributeKey());
            }
        }
        catch (DataSetException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Set<IDIFGroup> getAllGroups() throws IdentityManagerException {
        try {
            Query query = this.identityService.getGroupsDataSet().query();
            HashSet<IDIFGroup> result = new HashSet<IDIFGroup>();
            for (Groups group : query.asList()) {
                result.add(this.convertFromDBGroupToDIFGroup(group));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Set<IDIFUser> getAllUsers() throws IdentityManagerException {
        try {
            Query query = this.identityService.getUsersDataSet().query();
            HashSet<IDIFUser> result = new HashSet<IDIFUser>();
            for (Users user : query.asList()) {
                result.add(this.convertFromDBUserToDIFUser(user));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    private IEncryptor getEncryptator() {
        if (encryptor == null) {
            encryptor = new EncryptorBase64Impl();
            encryptor.setSeed(variableToReturn);
        }
        return encryptor;
    }

    public String getExclusionCharaters() {
        return "";
    }

    public IDIFGroup getGroup(String groupID) throws IdentityManagerException {
        if (groupID == null || "N/A".equals(groupID)) {
            return null;
        }
        try {
            Groups group = (Groups)this.identityService.getGroupsDataSet().get(groupID);
            return this.convertFromDBGroupToDIFGroup(group);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public String getGroupAttributeName() {
        return null;
    }

    public Map<String, IDIFGroup> getGroupGroups(String parentGroupID) throws IdentityManagerException {
        try {
            Query query = this.identityService.getGroupsDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id")), FilterType.EQUALS, parentGroupID));
            HashMap<String, IDIFGroup> result = new HashMap<String, IDIFGroup>();
            for (Groups group : query.asList()) {
                result.put(group.getId(), this.convertFromDBGroupToDIFGroup(group));
                result.putAll(this.getGroupGroups(group.getId()));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Map<String, IDIFUser> getGroupUsers(String groupID) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUserGroupsDataSet().query();
            query.addField(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")));
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)UserGroups.FK().users(), JoinType.NORMAL);
            query.addFilter(new Filter(UserGroups.FK().groups().ID(), FilterType.EQUALS, groupID));
            HashMap<String, IDIFUser> result = new HashMap<String, IDIFUser>();
            for (UserGroups group : query.asList()) {
                result.put(group.getUsers().getId(), this.convertFromDBUserToDIFUser(group.getUsers()));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Set<IDIFGroup> getGroups(Pagination page) throws IdentityManagerException {
        try {
            Query query = this.identityService.getGroupsDataSet().query();
            Integer start = page.getStartRow();
            query.filterResults(start, Integer.valueOf(page.getRowsPerPage()));
            HashSet<IDIFGroup> result = new HashSet<IDIFGroup>();
            for (Groups group : query.asList()) {
                result.add(this.convertFromDBGroupToDIFGroup(group));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public String getMailAttributeName() {
        return "mail";
    }

    public String getNameAttributeName() {
        return "name";
    }

    private final Groups getParentGroupDNFromProfileID(String profileID) throws IdentityManagerException {
        Groups result = null;
        try {
            result = (Groups)this.identityService.getGroupsDataSet().get(profileID);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException("Could not fetch parent group for profile ID: " + profileID, (Exception)((Object)e));
        }
        return result;
    }

    private Query<Users> getQueryUsersByAllAttributes(Map<String, String> attributes, Pagination page) throws DataSetException {
        Query query = this.identityService.getUsersDataSet().query();
        query.setDistinctEntities(true, true);
        FilterSet filterSet = (FilterSet)query.filterSet(ConditionOperator.OR);
        if (attributes.containsKey(this.getMailAttributeName())) {
            this.applyEqualsOrLike(filterSet, "email", attributes.get(this.getMailAttributeName()));
            attributes.remove(this.getMailAttributeName());
        }
        if (attributes.containsKey(this.getUserLoginAttributeName())) {
            this.applyEqualsOrLike(filterSet, "id", attributes.get(this.getUserLoginAttributeName()));
            attributes.remove(this.getUserLoginAttributeName());
        }
        if (attributes.containsKey(this.getNameAttributeName())) {
            this.applyEqualsOrLike(filterSet, "name", attributes.get(this.getNameAttributeName()));
            attributes.remove(this.getNameAttributeName());
        }
        if (attributes.containsKey(this.getUserParentGroupAttributeName())) {
            this.applyEqualsOrLike(filterSet, Users.FK().groups().ID(), attributes.get(this.getUserParentGroupAttributeName()));
            attributes.remove(this.getUserParentGroupAttributeName());
        }
        if (page != null) {
            Integer start = page.getStartRow();
            if (start == 0) {
                start = null;
            }
            query.filterResults(start, Integer.valueOf(page.getEndRow()));
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            query.addFilter(new Filter("attributeKey".toString(), FilterType.EQUALS, entry.getKey()));
            query.addFilter(new Filter("attributeValue".toString(), FilterType.EQUALS, entry.getValue()));
        }
        return query;
    }

    private Query<UserAttributes> getQueryUsersByAnyAttribute(Map<String, String> attributes, Pagination page) throws DataSetException {
        HashMap<String, String> attributesToProcess = new HashMap<String, String>();
        attributesToProcess.putAll(attributes);
        Query query = this.identityService.getUserAttributesDataSet().query();
        query.addField(UserAttributes.FK().users().ID());
        query.setDistinct(true);
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)UserAttributes.FK().users(), JoinType.NORMAL);
        ArrayList<String> filters = new ArrayList<String>();
        if (attributesToProcess.containsKey(this.getMailAttributeName())) {
            filters.add("users1_.email = '" + (String)attributesToProcess.get(this.getMailAttributeName()) + "'");
            attributesToProcess.remove(this.getMailAttributeName());
        }
        if (attributesToProcess.containsKey(this.getUserLoginAttributeName())) {
            filters.add("users1_.id = '" + (String)attributesToProcess.get(this.getUserLoginAttributeName()) + "'");
            attributesToProcess.remove(this.getUserLoginAttributeName());
        }
        if (attributesToProcess.containsKey(this.getNameAttributeName())) {
            filters.add("users1_.name = '" + (String)attributesToProcess.get(this.getNameAttributeName()) + "'");
            attributesToProcess.remove(this.getNameAttributeName());
        }
        if (attributesToProcess.containsKey(this.getUserParentGroupAttributeName())) {
            filters.add("profileid = '" + (String)attributesToProcess.get(this.getUserParentGroupAttributeName()) + "'");
            attributesToProcess.remove(this.getUserParentGroupAttributeName());
        }
        if (page != null) {
            Integer start = page.getStartRow();
            if (start == 0) {
                start = null;
            }
            query.filterResults(start, Integer.valueOf(page.getEndRow()));
        }
        for (Map.Entry entry : attributesToProcess.entrySet()) {
            filters.add("(attribute_key = '" + (String)entry.getKey() + "' and " + "attribute_value = '" + (String)entry.getValue() + "')");
        }
        if (!filters.isEmpty()) {
            query.addFilter(new Filter(FilterType.SQL, CollectionUtils.listToSeparatedString(filters, (String)" or ")));
        }
        return query;
    }

    public IDIFUser getUser(String userID) throws IdentityManagerException {
        try {
            Users user = (Users)this.identityService.getUsersDataSet().get(userID);
            return this.convertFromDBUserToDIFUser(user);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Map<String, IDIFGroup> getUserGroups(String userID) throws IdentityManagerException {
        return this.getUserGroupsPagination(userID, null);
    }

    private Set<Groups> getUserGroups(String userID, Pagination page) throws IdentityManagerException {
        try {
            Users user;
            Query query = this.identityService.getUserGroupsDataSet().query();
            query.addField(StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id")));
            query.addField(StringUtils.toLowerFirstChar((String)Groups.class.getSimpleName()) + "." + StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id")));
            query.addField(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")));
            query.addJoin(StringUtils.toLowerFirstChar((String)Groups.class.getSimpleName()), JoinType.NORMAL);
            query.addJoin(StringUtils.toLowerFirstChar((String)Groups.class.getSimpleName()) + "." + StringUtils.toLowerFirstChar((String)Groups.class.getSimpleName()), JoinType.LEFT_OUTER_JOIN);
            query.setDistinct(true);
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")), FilterType.EQUALS, userID));
            if (page != null) {
                Integer start = page.getStartRow();
                if (start == 0) {
                    start = null;
                }
                query.filterResults(start, Integer.valueOf(page.getEndRow()));
            }
            HashSet<Groups> result = new HashSet<Groups>();
            List userGroups = query.asList();
            if (userGroups.size() > 0) {
                for (UserGroups userGroup : userGroups) {
                    result.add(userGroup.getGroups());
                }
            }
            if (page == null && (user = (Users)this.identityService.getUsersDataSet().get(userID)).getGroups() != null) {
                result.add(user.getGroups());
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Set<String> getUserGroupsIDs(String userID) throws IdentityManagerException {
        HashSet<String> result = new HashSet<String>();
        for (Groups group : this.getUserGroups(userID, null)) {
            result.add(group.getId());
        }
        return result;
    }

    public Map<String, IDIFGroup> getUserGroupsPagination(String userID, Pagination page) throws IdentityManagerException {
        HashMap<String, IDIFGroup> result;
        block5: {
            result = new HashMap<String, IDIFGroup>();
            boolean wasActive = this.identityService.getUserGroupsDAO().getSession().getTransaction().isActive();
            if (!wasActive) {
                this.identityService.getUserGroupsDAO().getSession().beginTransaction();
            }
            try {
                for (Groups group : this.getUserGroups(userID, page)) {
                    result.put(group.getId(), this.convertFromDBGroupToDIFGroup(group));
                }
                if (!wasActive) {
                    this.identityService.getUserGroupsDAO().getSession().getTransaction().commit();
                }
            }
            catch (Exception e) {
                if (wasActive) break block5;
                this.identityService.getUserGroupsDAO().getSession().getTransaction().rollback();
            }
        }
        return result;
    }

    public Set<String> getUserIDsInGroup(String groupID) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUserGroupsDataSet().query();
            query.addField(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")));
            query.setDistinct(true);
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id")), FilterType.EQUALS, groupID));
            HashSet<String> result = new HashSet<String>();
            for (UserGroups user : query.asList()) {
                result.add(user.getUsers().getId());
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public String getUserLoginAttributeName() {
        return "id".toString();
    }

    public String getUserParentGroupAttributeName() {
        return StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id".toString()));
    }

    public Set<IDIFUser> getUsers(Pagination page) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUsersDataSet().query();
            if (page != null) {
                Integer first = page.getStartRow();
                Integer last = page.getStartRow() + page.getRowsPerPage() - 1;
                if (first == 0) {
                    first = null;
                }
                query.filterResults(first, last);
            }
            HashSet<IDIFUser> result = new HashSet<IDIFUser>();
            for (Users user : query.asList()) {
                result.add(this.convertFromDBUserToDIFUser(user));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Set<IDIFUser> getUsersByAnyAttribute(Map<String, String> attributes) throws IdentityManagerException {
        try {
            Query<UserAttributes> query = this.getQueryUsersByAnyAttribute(attributes, null);
            HashSet<IDIFUser> result = new HashSet<IDIFUser>();
            for (UserAttributes user : query.asList()) {
                result.add(this.convertFromDBUserToDIFUser(user.getUsers()));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Set<IDIFUser> getUsersByAttribute(String attribute, String value) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUserAttributesDataSet().query();
            query.addField(UserAttributes.FK().users().ID());
            query.addField(UserAttributes.FK().users().NAME());
            query.addField(UserAttributes.FK().users().NICK());
            query.addField(UserAttributes.FK().users().EMAIL());
            query.setDistinct(true);
            if (attribute.equalsIgnoreCase("id")) {
                query.like(UserAttributes.FK().users().ID(), value);
            } else if (attribute.equalsIgnoreCase("name")) {
                query.like(UserAttributes.FK().users().NAME(), value);
            } else if (attribute.equalsIgnoreCase("nick")) {
                query.like(UserAttributes.FK().users().NICK(), value);
            } else if (attribute.equalsIgnoreCase("email")) {
                query.like(UserAttributes.FK().users().EMAIL(), value);
            } else {
                query.equals("attributeKey".toString(), attribute);
                query.like("attributeValue".toString(), value);
            }
            HashSet<IDIFUser> result = new HashSet<IDIFUser>();
            for (UserAttributes userAttribute : query.asList()) {
                result.add(this.convertFromDBUserToDIFUser(userAttribute.getUsers()));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Set<IDIFUser> getUsersByAttributes(Map<String, String> attributes) throws IdentityManagerException {
        return this.getUsersByAttributes(attributes, null);
    }

    public Set<IDIFUser> getUsersByAttributes(Map<String, String> attributes, Pagination page) throws IdentityManagerException {
        try {
            Query<Users> query = this.getQueryUsersByAllAttributes(attributes, page);
            HashSet<IDIFUser> result = new HashSet<IDIFUser>();
            for (Users user : query.asList()) {
                result.add(this.convertFromDBUserToDIFUser(user));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public Set<IDIFUser> getUsersByEmail(String value) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUsersDataSet().query();
            query.addFilter(new Filter("email".toString(), FilterType.EQUALS, value));
            HashSet<IDIFUser> result = new HashSet<IDIFUser>();
            for (Users user : query.asList()) {
                result.add(this.convertFromDBUserToDIFUser(user));
            }
            return result;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public boolean groupExists(String groupID) throws IdentityManagerException {
        try {
            Groups group = (Groups)this.identityService.getGroupsDataSet().get(groupID);
            return group != null;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public boolean isIdentityValid(String userID, String suppliedPassword) throws IdentityManagerException {
        try {
            Users user = (Users)this.identityService.getUsersDataSet().get(userID);
            return user != null && suppliedPassword != null && suppliedPassword.equals(this.getEncryptator().decrypt(user.getPassword()));
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
        catch (CryptoException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isSaveParameterValuesOnlyIfEmpty() {
        return false;
    }

    public boolean isUserInGroup(String userID, String groupID) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUserGroupsDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")), FilterType.EQUALS, userID));
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id")), FilterType.EQUALS, groupID));
            return query.count() > 0L;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public void persistUserAttribute(String userID, String attributeID, Object attributeValue) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUserAttributesDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")), FilterType.EQUALS, userID));
            query.addFilter(new Filter("attributeKey".toString(), FilterType.EQUALS, attributeID));
            UserAttributes userAttribute = (UserAttributes)query.singleValue();
            if (userAttribute != null) {
                userAttribute.setAttributeValue(attributeValue.toString());
                this.identityService.getUserAttributesDataSet().update((IBeanAttributes)userAttribute);
            } else {
                userAttribute = new UserAttributes();
                Users user = (Users)this.identityService.getUsersDataSet().get(userID);
                if (user == null) {
                    throw new IdentityManagerException("User " + userID + " does not exists on the IdentityManager!! ");
                }
                userAttribute.setUsers(user);
                userAttribute.setAttributeKey(attributeID);
                userAttribute.setAttributeValue(attributeValue.toString());
                this.identityService.getUserAttributesDataSet().insert((IBeanAttributes)userAttribute);
            }
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public void persistUserAttributes(String userID, Map<String, Object> attributes) throws IdentityManagerException {
        if (attributes != null && !attributes.isEmpty()) {
            try {
                Users dbUser = (Users)this.identityService.getUsersDataSet().get(userID);
                if (dbUser == null) {
                    throw new IdentityManagerDBException("Could not update attributes for user with ID: " + userID + "!");
                }
                Query query = this.identityService.getUserAttributesDataSet().query();
                query.equals(UserAttributes.FK().users().ID(), userID).in("attributeKey", CollectionUtils.setToCommaSeparatedString(attributes.keySet()));
                for (UserAttributes userAttribute : query.asList()) {
                    String value = "";
                    if (attributes.containsKey(userAttribute.getAttributeKey())) {
                        value = attributes.get(userAttribute.getAttributeKey()).toString();
                    }
                    userAttribute.setAttributeValue(value);
                    this.identityService.getUserAttributesDataSet().update((IBeanAttributes)userAttribute);
                    attributes.remove(userAttribute.getAttributeKey());
                }
                if (attributes.size() > 0) {
                    for (String attribKey : attributes.keySet()) {
                        UserAttributes newAttribute = new UserAttributes();
                        newAttribute.setAttributeKey(attribKey);
                        newAttribute.setAttributeValue(attributes.get(attribKey).toString());
                        newAttribute.setUsers(dbUser);
                        newAttribute = (UserAttributes)this.identityService.getUserAttributesDataSet().insert((IBeanAttributes)newAttribute);
                    }
                }
            }
            catch (DataSetException e) {
                throw new IdentityManagerDBException((Exception)((Object)e));
            }
        }
    }

    private void processFromDIFUserToDBUserAttributes(IDIFUser difUser, Users dbUser) throws IdentityManagerException {
        try {
            CaseInsensitiveHashMap attributes = difUser.getAttributes();
            Query queryUserAttributes = this.identityService.getUserAttributesDataSet().query();
            queryUserAttributes.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id".toString())), FilterType.EQUALS, dbUser.getId()));
            List dbAttributes = null;
            if (attributes != null && attributes.size() > 0) {
                dbAttributes = queryUserAttributes.asList();
                for (String attributeName : attributes.keySet()) {
                    UserAttributes existentAttribute = null;
                    for (UserAttributes attribute : dbAttributes) {
                        if (!attribute.getAttributeKey().equalsIgnoreCase(attributeName)) continue;
                        existentAttribute = attribute;
                        break;
                    }
                    if (existentAttribute != null) {
                        existentAttribute.setAttributeValue(attributes.get((Object)attributeName).toString());
                        this.identityService.getUserAttributesDataSet().update((IBeanAttributes)existentAttribute);
                        continue;
                    }
                    UserAttributes newAttribute = new UserAttributes();
                    newAttribute.setAttributeKey(attributeName);
                    newAttribute.setAttributeValue(attributes.get((Object)attributeName).toString());
                    newAttribute.setUsers(dbUser);
                    newAttribute = (UserAttributes)this.identityService.getUserAttributesDataSet().insert((IBeanAttributes)newAttribute);
                }
            }
            if (difUser.getAttributesToRemove() != null && difUser.getAttributesToRemove().size() > 0) {
                if (dbAttributes == null) {
                    dbAttributes = queryUserAttributes.asList();
                }
                block4: for (String attributeName : difUser.getAttributesToRemove()) {
                    for (UserAttributes attribute : dbAttributes) {
                        if (!attribute.getAttributeKey().equals(attributeName)) continue;
                        this.identityService.getUserAttributesDataSet().delete(attribute.getId().toString());
                        continue block4;
                    }
                }
            }
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public void removeGroup(String groupID) throws IdentityManagerException {
        try {
            this.identityService.getGroupsDataSet().delete(groupID);
        }
        catch (Exception e) {
            throw new IdentityManagerDBException(e);
        }
    }

    public void removeUser(String userID) throws IdentityManagerException {
        try {
            this.identityService.getUsersDataSet().delete(userID);
        }
        catch (Exception e) {
            throw new IdentityManagerDBException(e);
        }
    }

    public void removeUserFromGroup(String userID, String groupID) throws IdentityManagerException {
        try {
            Query query = this.identityService.getUserGroupsDataSet().query();
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Users.class.getSimpleName() + "." + "id")), FilterType.EQUALS, userID));
            query.addFilter(new Filter(StringUtils.toLowerFirstChar((String)(Groups.class.getSimpleName() + "." + "id")), FilterType.EQUALS, groupID));
            UserGroups userGroups = (UserGroups)query.singleValue();
            if (userGroups != null) {
                this.identityService.getUserGroupsDataSet().delete(userGroups.getId().toString());
            }
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public void resetIdentityManager() {
    }

    public void updateGroup(IDIFGroup existingGroup) throws IdentityManagerException {
        Groups dbGroup = this.convertFromDIFGroupToDBGroup(existingGroup);
        try {
            this.identityService.getGroupsDataSet().update((IBeanAttributes)dbGroup);
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }

    public void updateUser(IDIFUser existingUser, String userID) throws IdentityManagerException {
        Users dbUser = this.convertFromDIFUserToDBUser(existingUser);
        try {
            dbUser = (Users)this.identityService.getUsersDataSet().update((IBeanAttributes)dbUser);
            this.processFromDIFUserToDBUserAttributes(existingUser, dbUser);
        }
        catch (Exception e) {
            throw new IdentityManagerDBException(e);
        }
    }

    public void updateUserAttribute(String userID, String attributeID, Object attributeValue) throws IdentityManagerException {
        this.persistUserAttribute(userID, attributeID, attributeValue);
    }

    public void updateUserAttributes(String userID, Map<String, Object> attributes) throws IdentityManagerException {
        this.persistUserAttributes(userID, attributes);
    }

    public boolean userExists(String userID) throws IdentityManagerException {
        try {
            Users user = (Users)this.identityService.getUsersDataSet().get(userID);
            return user != null;
        }
        catch (DataSetException e) {
            throw new IdentityManagerDBException((Exception)((Object)e));
        }
    }
}

