/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.test.impl;

import java.io.IOException;
import java.net.MalformedURLException;

import org.xml.sax.SAXException;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

import pt.digitalis.dif.test.IPageTester;
import pt.digitalis.dif.test.exception.PageTestException;
import pt.digitalis.dif.test.objects.URLCall;

/**
 * Implementation of a page tester.
 * 
 * @author Rodrigo Goncalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/01/22
 */
public class PageTesterImpl implements IPageTester {

    /** GET method identified */
    final static private String GET = "get";

    /** POST method identified */
    final static private String POST = "post";

    /**
     * Runs the page test by issuing an HTTP request.
     * 
     * @param page
     *            the page to test
     * @param action
     *            the HTTP action to use GET/POST
     * @return the response the page response
     * @throws PageTestException
     *             if the test could not be run due to an error
     */
    private WebResponse callHTTPPage(URLCall page, String action) throws PageTestException
    {

        WebRequest request;

        if (action == GET)
            request = new GetMethodWebRequest(page.getURL());
        else
            request = new PostMethodWebRequest(page.getURL());

        WebResponse response = null;

        try
        {
            WebConversation conversation = new WebConversation();

            if ((page.getSession() != null) && (page.getSession().getSessionID() != null))
                conversation.putCookie("JSESSIONID", page.getSession().getSessionID());

            response = conversation.getResponse(request);

            if (page.getSession() != null)
                page.getSession().setSessionID(conversation.getCookieValue("JSESSIONID"));

        }
        catch (MalformedURLException malformedURLException)
        {
            throw new PageTestException("The URL doesn't seem to be valid!", malformedURLException);
        }
        catch (SAXException saxException)
        {
            throw new PageTestException("XML error!", saxException);
        }
        catch (IOException ioException)
        {
            throw new PageTestException("I/O error!", ioException);
        }

        return response;
    }

    /**
     * @param enabled
     *            T to enable scripting analysis, F otherwise
     */
    private void setScripting(boolean enabled)
    {
        HttpUnitOptions.setScriptingEnabled(enabled);
    }

    /**
     * @see pt.digitalis.dif.test.IPageTester#testPageGET(pt.digitalis.dif.test.objects.URLCall)
     */
    public WebResponse testPageGET(URLCall page) throws PageTestException
    {
        setScripting(page.isScriptingEnabled());

        return callHTTPPage(page, GET);
    }

    /**
     * @see pt.digitalis.dif.test.IPageTester#testPagePOST(pt.digitalis.dif.test.objects.URLCall)
     */
    public WebResponse testPagePOST(URLCall page) throws PageTestException
    {
        setScripting(page.isScriptingEnabled());

        return callHTTPPage(page, POST);
    }
}
