/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.test.objects;

import java.util.Map;

/**
 * Manages a JavaSession ID for page tests
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/07/01
 */
public class JavaSession {

    /** If the JavsScript should be parsed */
    private boolean scriptingEnabled = false;

    /** The server info for this session */
    private ServerInfo serverInfo = null;

    /** the session generated ID */
    private String sessionID = null;

    /**
     * Default constructor
     * 
     * @param serverInfo
     */
    public JavaSession(ServerInfo serverInfo)
    {
        this.serverInfo = serverInfo;
    }

    /**
     * Inspector for the 'serverInfo' attribute.
     *
     * @return the serverInfo value
     */
    public ServerInfo getServerInfo()
    {
        return serverInfo;
    }

    /**
     * Inspector for the 'sessionID' attribute.
     *
     * @return the sessionID value
     */
    public String getSessionID()
    {
        return sessionID;
    }

    /**
     * Creates a URLCall to the specified URL for the present session
     * 
     * @param stageID
     *            the stage ID of the stage to run
     * @return an URLCall object
     */
    public StageCall getStageCall(String stageID)
    {
        return getStageCall(stageID, null);
    }

    /**
     * Creates a URLCall to the specified URL for the present session
     * 
     * @param stageID
     *            the stage ID of the stage to run
     * @param parameters
     *            the stage parameters
     * @return an URLCall object
     */
    public StageCall getStageCall(String stageID, Map<String, String> parameters)
    {
        StageCall call = new StageCall(getServerInfo(), stageID, parameters, scriptingEnabled);
        call.setSession(this);

        return call;
    }

    /**
     * Creates a URLCall to the specified URL for the present session
     * 
     * @param relativeURL
     *            the url of the stage to run
     * @return an URLCall object
     */
    public URLCall getURLCall(String relativeURL)
    {
        return getURLCall(relativeURL, null);
    }

    /**
     * Creates a URLCall to the specified URL for the present session
     * 
     * @param relativeURL
     *            the url of the stage to run
     * @param parameters
     *            the stage parameters
     * @return an URLCall object
     */
    public URLCall getURLCall(String relativeURL, Map<String, String> parameters)
    {
        URLCall call = new URLCall(getServerInfo(), relativeURL, parameters, scriptingEnabled);
        call.setSession(this);

        return call;
    }

    /**
     * Inspector for the 'scriptingEnabled' attribute.
     *
     * @return the scriptingEnabled value
     */
    public boolean isScriptingEnabled()
    {
        return scriptingEnabled;
    }

    /**
     * Modifier for the 'scriptingEnabled' attribute.
     *
     * @param scriptingEnabled
     *            the new scriptingEnabled value to set
     */
    public void setScriptingEnabled(boolean scriptingEnabled)
    {
        this.scriptingEnabled = scriptingEnabled;
    }

    /**
     * Modifier for the 'serverInfo' attribute.
     *
     * @param serverInfo
     *            the new serverInfo value to set
     */
    public void setServerInfo(ServerInfo serverInfo)
    {
        this.serverInfo = serverInfo;
    }

    /**
     * Modifier for the 'sessionID' attribute.
     *
     * @param sessionID
     *            the new sessionID value to set
     */
    public void setSessionID(String sessionID)
    {
        this.sessionID = sessionID;
    }
}
