/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.test.objects;

import java.util.Map;

/**
 * Holds information about a server call to a DIF2 stage.
 * 
 * @author Rodrigo Goncalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Jan 23, 2008
 */
public class StageCall extends URLCall {

    /** The 'listener' string. */
    final static private String LISTENER = "listener";

    /** The '?' character as a String. */
    final static private String QUESTION_MARK = "?";

    /** The 'stage=' string. */
    final static private String STAGE = "stage=";

    /** The id of the stage to run. */
    private String stageID;

    /**
     * Constructor.
     * 
     * @param serverInfo
     *            app server info
     * @param stageID
     *            the id of the stage to run
     * @param parameters
     *            the stage parameters
     * @param scriptingEnabled
     *            T if the scripting analysis should be done, F otherwise
     */
    public StageCall(ServerInfo serverInfo, String stageID, Map<String, String> parameters, boolean scriptingEnabled)
    {
        super(serverInfo, null, parameters, scriptingEnabled);

        this.stageID = stageID;
    }

    /**
     * Stage ID inspector.
     * 
     * @return the stageID
     */
    public String getStageID()
    {
        return this.stageID;
    }

    /**
     * @see pt.digitalis.dif.test.objects.URLCall#getURL()
     */
    @Override
    public String getURL()
    {
        StringBuffer url = new StringBuffer(THE_HTTP_PREFIX);

        url.append(this.getServerInfo().getServerName());
        url.append(COLON);
        url.append(this.getServerInfo().getPort());
        url.append(SLASH);
        url.append(this.getServerInfo().getApplication());
        url.append(SLASH);
        url.append(LISTENER);
        url.append(QUESTION_MARK);
        url.append(STAGE);
        url.append(this.stageID.toLowerCase());

        // Append parameters if they exist
        if (parameters.keySet().size() > 0)
        {
            for (String parameterName: this.parameters.keySet())
            {
                url.append(AMPERSAND);
                url.append(parameterName);
                url.append(EQUALS);
                url.append(this.parameters.get(parameterName));
            }
        }
        return url.toString();
    }

    /**
     * Stage ID modifier.
     * 
     * @param stageID
     *            the stageID to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }
}
